/*
 * Decompiled with CFR 0.152.
 */
package dev.thestaticvoid.mi_sound_addon.mixin;

import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.components.CrafterComponent;
import aztech.modern_industrialization.machines.recipe.MachineRecipe;
import aztech.modern_industrialization.machines.recipe.condition.MachineProcessCondition;
import dev.thestaticvoid.mi_sound_addon.MISoundAddonConfig;
import dev.thestaticvoid.mi_sound_addon.sound.ModSounds;
import dev.thestaticvoid.mi_sound_addon.util.SilencedComponent;
import dev.thestaticvoid.mi_sound_addon.util.SilencedComponentInterface;
import java.util.Objects;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={CrafterComponent.class})
public abstract class TickRecipeMixin
implements IComponent.ServerOnly {
    @Unique
    public long lastSoundTime = 0L;
    @Shadow(remap=false)
    @Final
    private MachineProcessCondition.Context conditionContext;
    @Shadow(remap=false)
    private MachineRecipe activeRecipe;

    @Inject(method={"tickRecipe"}, at={@At(value="RETURN")}, locals=LocalCapture.CAPTURE_FAILHARD, remap=false)
    private void tickRecipeInjection(CallbackInfoReturnable<Boolean> cir, boolean isActive) {
        if (MISoundAddonConfig.getConfig().enableSounds) {
            MachineBlockEntity blockEntity = this.conditionContext.getBlockEntity();
            SilencedComponent silencedState = ((SilencedComponentInterface)blockEntity).mISoundAddon$getSilencedState();
            if (silencedState.silenced) {
                return;
            }
            long currentGameTime = Objects.requireNonNull(blockEntity.method_10997()).method_8510();
            if (isActive && this.activeRecipe != null && currentGameTime > this.lastSoundTime + (long)ModSounds.getDuration(this.activeRecipe)) {
                this.lastSoundTime = currentGameTime;
                ModSounds.playSound(blockEntity, this.activeRecipe);
            }
        }
    }
}

