/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.fabric.mixin.perf.resourcepacks;

import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import net.fabricmc.fabric.impl.resource.loader.ModNioResourcePack;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.annotation.RequiresMod;
import org.embeddedt.modernfix.resources.ICachingResourcePack;
import org.embeddedt.modernfix.resources.PackResourcesCacheEngine;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={ModNioResourcePack.class})
@RequiresMod(value="fabric-resource-loader-v0")
public abstract class ModNioResourcePackMixin
implements ICachingResourcePack {
    @Shadow(remap=false)
    @Final
    private List<Path> basePaths;
    @Shadow(remap=false)
    @Final
    private ModMetadata modInfo;
    private PackResourcesCacheEngine cacheEngine;

    @Shadow
    public abstract Set<String> method_14406(class_3264 var1);

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void cacheResources(CallbackInfo ci) {
        this.invalidateCache();
        PackResourcesCacheEngine.track(this);
    }

    @Override
    public void invalidateCache() {
        this.cacheEngine = null;
        if (this.basePaths.size() == 1) {
            Path basePath = this.basePaths.get(0);
            this.cacheEngine = new PackResourcesCacheEngine(this::method_14406, (type, namespace) -> basePath.resolve(type.method_14413()).resolve((String)namespace));
        } else {
            ModernFix.LOGGER.warn("Cannot cache resource pack for mod '{}' as it uses multiple base paths", (Object)this.modInfo.getId());
        }
    }

    @Redirect(method={"getPath"}, at=@At(value="INVOKE", target="Lnet/fabricmc/fabric/impl/resource/loader/ModNioResourcePack;exists(Ljava/nio/file/Path;)Z"), remap=false)
    private boolean checkExists(Path path) {
        return true;
    }

    @Inject(method={"getNamespaces"}, at={@At(value="HEAD")}, cancellable=true)
    private void useCacheForNamespaces(class_3264 type, CallbackInfoReturnable<Set<String>> cir) {
        Set<String> namespaces;
        if (this.cacheEngine != null && (namespaces = this.cacheEngine.getNamespaces(type)) != null) {
            cir.setReturnValue(namespaces);
        }
    }

    @Inject(method={"hasResource"}, at={@At(value="INVOKE", target="Lnet/fabricmc/fabric/impl/resource/loader/ModNioResourcePack;getPath(Ljava/lang/String;)Ljava/nio/file/Path;")}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD)
    private void useCacheForExistence(class_3264 type, class_2960 id, CallbackInfoReturnable<Boolean> cir, String filename) {
        if (this.cacheEngine != null && (filename.startsWith("assets/") || filename.startsWith("data/"))) {
            cir.setReturnValue((Object)this.cacheEngine.hasResource(filename));
        }
    }
}

