/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.client.util;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_1011;
import net.minecraft.class_1159;
import net.minecraft.class_1767;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_757;
import org.apache.commons.lang3.StringUtils;

public class TextUtil {
    private static final class_5481 CURSOR_MARKER = class_5481.method_30747((String)"_", (class_2583)class_2583.field_24360);

    public static Pair<List<class_5481>, Float> fitLinesToBox(class_327 font, class_5348 text, float width, float height) {
        int scalingFactor;
        List splitLines;
        float maxLines;
        int fontWidth = font.method_27525(text);
        do {
            scalingFactor = class_3532.method_15375((float)class_3532.method_15355((float)((float)fontWidth * 8.0f / (width * height))));
            splitLines = font.method_1728(text, class_3532.method_15375((float)(width * (float)scalingFactor)));
            maxLines = height * (float)scalingFactor / 8.0f;
            ++fontWidth;
        } while (maxLines < (float)splitLines.size());
        return Pair.of((Object)splitLines, (Object)Float.valueOf(1.0f / (float)scalingFactor));
    }

    @Deprecated(forRemoval=true)
    public static String getReadableName(String name) {
        return Arrays.stream(name.replace(":", "_").split("_")).map(StringUtils::capitalize).collect(Collectors.joining(" "));
    }

    public static class_5348 parseText(String s) {
        try {
            class_5250 mutableComponent = class_2561.class_2562.method_10877((String)s);
            if (mutableComponent != null) {
                return mutableComponent;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return class_5348.method_29430((String)s);
    }

    public static void renderGuiLine(RenderTextProperties properties, String string, class_327 font, class_4587 poseStack, class_4597.class_4598 buffer, int cursorPos, int selectionPos, boolean isSelected, boolean blink, int yOffset) {
        poseStack.method_22903();
        class_1159 matrix4f = poseStack.method_23760().method_23761();
        if (string != null) {
            if (font.method_1726()) {
                string = font.method_1721(string);
            }
            class_5481 charSequence = class_5481.method_30747((String)string, (class_2583)properties.style);
            float centerX = -font.method_30880(charSequence) / 2;
            TextUtil.renderLineInternal(charSequence, font, centerX, yOffset, matrix4f, (class_4597)buffer, properties);
            String substring = string.substring(0, Math.min(cursorPos, string.length()));
            if (isSelected) {
                int pX = (int)((float)font.method_30880(class_5481.method_30747((String)substring, (class_2583)properties.style)) + centerX);
                if (blink) {
                    if (cursorPos >= string.length()) {
                        TextUtil.renderLineInternal(CURSOR_MARKER, font, pX, yOffset, matrix4f, (class_4597)buffer, properties);
                    }
                    buffer.method_22993();
                }
                if (blink && cursorPos < string.length()) {
                    class_332.method_25294((class_4587)poseStack, (int)pX, (int)(yOffset - 1), (int)(pX + 1), (int)(yOffset + 9), (int)(0xFF000000 | properties.textColor));
                }
                if (selectionPos != cursorPos) {
                    int l3 = Math.min(cursorPos, selectionPos);
                    int l1 = Math.max(cursorPos, selectionPos);
                    int i2 = font.method_1727(string.substring(0, l3)) - font.method_1727(string) / 2;
                    int j2 = font.method_1727(string.substring(0, l1)) - font.method_1727(string) / 2;
                    int k2 = Math.min(i2, j2);
                    int l2 = Math.max(i2, j2);
                    class_289 tesselator = class_289.method_1348();
                    class_287 bufferbuilder = tesselator.method_1349();
                    RenderSystem.setShader(class_757::method_34540);
                    RenderSystem.disableTexture();
                    RenderSystem.enableColorLogicOp();
                    RenderSystem.logicOp((GlStateManager.class_1030)GlStateManager.class_1030.field_5110);
                    bufferbuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
                    bufferbuilder.method_22918(matrix4f, (float)k2, (float)(yOffset + 9), 0.0f).method_1336(0, 0, 255, 255).method_1344();
                    bufferbuilder.method_22918(matrix4f, (float)l2, (float)(yOffset + 9), 0.0f).method_1336(0, 0, 255, 255).method_1344();
                    bufferbuilder.method_22918(matrix4f, (float)l2, (float)yOffset, 0.0f).method_1336(0, 0, 255, 255).method_1344();
                    bufferbuilder.method_22918(matrix4f, (float)k2, (float)yOffset, 0.0f).method_1336(0, 0, 255, 255).method_1344();
                    class_286.method_43433((class_287.class_7433)bufferbuilder.method_1326());
                    RenderSystem.disableColorLogicOp();
                    RenderSystem.enableTexture();
                }
            }
            if (!isSelected || !blink) {
                buffer.method_22993();
            }
        }
    }

    public static void renderGuiText(RenderTextProperties properties, String[] guiLines, class_327 font, class_4587 poseStack, class_4597.class_4598 buffer, int cursorPos, int selectionPos, int currentLine, boolean blink, int lineSpacing) {
        int nOfLines = guiLines.length;
        for (int line = 0; line < nOfLines; ++line) {
            int yOffset = line * lineSpacing - nOfLines * 5;
            TextUtil.renderGuiLine(properties, guiLines[line], font, poseStack, buffer, cursorPos, selectionPos, line == currentLine, blink, yOffset);
        }
    }

    public static void renderLine(class_5481 formattedCharSequences, class_327 font, float yOffset, class_4587 poseStack, class_4597 buffer, RenderTextProperties properties) {
        if (formattedCharSequences == null) {
            return;
        }
        float x = -font.method_30880(formattedCharSequences) / 2;
        TextUtil.renderLineInternal(formattedCharSequences, font, x, yOffset, poseStack.method_23760().method_23761(), buffer, properties);
    }

    public static void renderAllLines(class_5481[] charSequences, int ySeparation, class_327 font, class_4587 poseStack, class_4597 buffer, RenderTextProperties properties) {
        for (int i = 0; i < charSequences.length; ++i) {
            TextUtil.renderLine(charSequences[i], font, ySeparation * i, poseStack, buffer, properties);
        }
    }

    private static void renderLineInternal(class_5481 formattedCharSequences, class_327 font, float xOffset, float yOffset, class_1159 matrix4f, class_4597 buffer, RenderTextProperties properties) {
        if (properties.glowing) {
            font.method_37296(formattedCharSequences, xOffset, yOffset, properties.textColor, properties.darkenedColor, matrix4f, buffer, properties.light);
        } else {
            font.method_22942(formattedCharSequences, xOffset, yOffset, properties.darkenedColor, false, matrix4f, buffer, false, 0, properties.light);
        }
    }

    private static int getDarkenedColor(int color, boolean glowing) {
        if (color == class_1767.field_7963.method_16357() && glowing) {
            return -988212;
        }
        return TextUtil.getDarkenedColor(color, 0.4f);
    }

    private static int getDarkenedColor(int color, float amount) {
        int j = (int)((double)class_1011.method_24033((int)color) * (double)amount);
        int k = (int)((double)class_1011.method_24034((int)color) * (double)amount);
        int l = (int)((double)class_1011.method_24035((int)color) * (double)amount);
        return class_1011.method_24031((int)0, (int)l, (int)k, (int)j);
    }

    public record RenderTextProperties(int textColor, int darkenedColor, boolean glowing, int light, class_2583 style) {
        public RenderTextProperties(class_1767 color, boolean glowing, int combinedLight, class_2583 style, Supplier<Boolean> isVeryNear) {
            this(color.method_16357(), TextUtil.getDarkenedColor(color.method_16357(), glowing), glowing && (isVeryNear.get() != false || color == class_1767.field_7963), glowing ? combinedLight : 0xF000F0, style);
        }
    }
}

