/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.entity;

import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1676;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2643;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3857;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5712;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ImprovedProjectileEntity
extends class_3857 {
    private static final class_2940<Byte> ID_FLAGS = class_2945.method_12791(ImprovedProjectileEntity.class, (class_2941)class_2943.field_13319);
    protected boolean touchedGround = false;
    protected int groundTime = 0;
    protected int maxAge = 200;
    protected int maxGroundTime = 20;
    protected float waterDeceleration = 0.8f;

    protected ImprovedProjectileEntity(class_1299<? extends class_3857> type, class_1937 world) {
        super(type, world);
    }

    protected ImprovedProjectileEntity(class_1299<? extends class_3857> type, double x, double y, double z, class_1937 world) {
        this(type, world);
        this.method_5814(x, y, z);
    }

    protected ImprovedProjectileEntity(class_1299<? extends class_3857> type, class_1309 thrower, class_1937 world) {
        this(type, thrower.method_23317(), thrower.method_23320() - (double)0.1f, thrower.method_23321(), world);
        this.method_7432((class_1297)thrower);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(ID_FLAGS, (Object)0);
    }

    private void setFlag(int id, boolean value) {
        byte b0 = (Byte)this.field_6011.method_12789(ID_FLAGS);
        if (value) {
            this.field_6011.method_12778(ID_FLAGS, (Object)((byte)(b0 | id)));
        } else {
            this.field_6011.method_12778(ID_FLAGS, (Object)((byte)(b0 & ~id)));
        }
    }

    public void setNoPhysics(boolean noPhysics) {
        this.field_5960 = noPhysics;
        this.setFlag(2, noPhysics);
    }

    public boolean isNoPhysics() {
        if (!this.field_6002.field_9236) {
            return this.field_5960;
        }
        return ((Byte)this.field_6011.method_12789(ID_FLAGS) & 2) != 0;
    }

    public void method_5773() {
        class_265 voxelshape;
        this.method_5670();
        if (!this.field_28646) {
            this.method_32875(class_5712.field_28161, this.method_24921());
            this.field_28646 = true;
        }
        class_243 movement = this.method_18798();
        double velX = movement.field_1352;
        double velY = movement.field_1351;
        double velZ = movement.field_1350;
        boolean noPhysics = this.isNoPhysics();
        class_2338 blockpos = this.method_24515();
        class_2680 blockstate = this.field_6002.method_8320(blockpos);
        if (!(blockstate.method_26215() || noPhysics || (voxelshape = blockstate.method_26220((class_1922)this.field_6002, blockpos)).method_1110())) {
            class_243 vector3d1 = this.method_19538();
            for (class_238 aabb : voxelshape.method_1090()) {
                if (!aabb.method_996(blockpos).method_1006(vector3d1)) continue;
                this.touchedGround = true;
                break;
            }
        }
        if (this.method_5721()) {
            this.method_5646();
        }
        if (this.touchedGround && !noPhysics) {
            ++this.groundTime;
        } else {
            this.groundTime = 0;
            this.method_26962();
            class_243 pos = this.method_19538();
            boolean client = this.field_6002.field_9236;
            class_243 newPos = pos.method_1019(movement);
            class_3965 blockHitResult = this.field_6002.method_17742(new class_3959(pos, newPos, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this));
            if (blockHitResult.method_17783() != class_239.class_240.field_1333 && !noPhysics) {
                newPos = blockHitResult.method_17784();
            }
            if (client) {
                this.spawnTrailParticles(pos, newPos);
            }
            double posX = newPos.field_1352;
            double posY = newPos.field_1351;
            double posZ = newPos.field_1350;
            if (!this.method_5740() && !noPhysics) {
                this.method_18800(velX, velY - (double)this.method_7490(), velZ);
            }
            float deceleration = this.getDeceleration();
            if (this.method_5799()) {
                if (client) {
                    for (int j = 0; j < 4; ++j) {
                        double pY = posY + (double)this.method_17682() / 2.0;
                        this.field_6002.method_8406((class_2394)class_2398.field_11247, posX - velX * 0.25, pY - velY * 0.25, posZ - velZ * 0.25, velX, velY, velZ);
                    }
                }
                deceleration = this.waterDeceleration;
            }
            this.method_18799(this.method_18798().method_1021((double)deceleration));
            this.method_5814(posX, posY, posZ);
            this.method_5852();
            if (!this.method_31481()) {
                class_3966 hitEntity = this.findHitEntity(pos, newPos);
                if (hitEntity != null) {
                    blockHitResult = hitEntity;
                }
                class_239.class_240 type = blockHitResult.method_17783();
                boolean portalHit = false;
                if (type == class_239.class_240.field_1331) {
                    class_1297 entity = ((class_3966)blockHitResult).method_17782();
                    if (entity instanceof class_1657) {
                        class_1657 p2;
                        class_1657 p1 = (class_1657)entity;
                        class_1297 class_12972 = this.method_24921();
                        if (class_12972 instanceof class_1657 && !(p2 = (class_1657)class_12972).method_7256(p1)) {
                            blockHitResult = null;
                        }
                    }
                } else if (type == class_239.class_240.field_1332) {
                    class_2338 hitPos = blockHitResult.method_17777();
                    class_2680 hitState = this.field_6002.method_8320(hitPos);
                    if (hitState.method_27852(class_2246.field_10316)) {
                        this.method_5717(hitPos);
                        portalHit = true;
                    } else if (hitState.method_27852(class_2246.field_10613)) {
                        class_2586 class_25862 = this.field_6002.method_8321(hitPos);
                        if (class_25862 instanceof class_2643) {
                            class_2643 tile = (class_2643)class_25862;
                            if (class_2643.method_30276((class_1297)this)) {
                                class_2643.method_11409((class_1937)this.field_6002, (class_2338)hitPos, (class_2680)hitState, (class_1297)this, (class_2643)tile);
                            }
                        }
                        portalHit = true;
                    }
                }
                if (!(portalHit || blockHitResult == null || type == class_239.class_240.field_1333 || noPhysics || ForgeHelper.onProjectileImpact((class_1676)this, (class_239)blockHitResult))) {
                    this.method_7488((class_239)blockHitResult);
                    this.field_6007 = true;
                }
            }
        }
        if (this.hasReachedEndOfLife() && !this.method_31481()) {
            this.reachedEndOfLife();
        }
    }

    protected float getDeceleration() {
        return 0.99f;
    }

    public boolean hasReachedEndOfLife() {
        return this.field_6012 > this.maxAge || this.groundTime > this.maxGroundTime;
    }

    public void reachedEndOfLife() {
        this.method_5650(class_1297.class_5529.field_26999);
    }

    @Nullable
    protected class_3966 findHitEntity(class_243 oPos, class_243 pos) {
        return class_1675.method_18077((class_1937)this.field_6002, (class_1297)this, (class_243)oPos, (class_243)pos, (class_238)this.method_5829().method_18804(this.method_18798()).method_1014(1.0), x$0 -> this.method_26958((class_1297)x$0));
    }

    public void spawnTrailParticles(class_243 currentPos, class_243 newPos) {
    }

    public void method_5652(@NotNull class_2487 tag) {
        super.method_5652(tag);
        tag.method_10556("touchedGround", this.touchedGround);
    }

    public void method_5749(@NotNull class_2487 tag) {
        super.method_5749(tag);
        this.touchedGround = tag.method_10577("touchedGround");
    }
}

