/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.map.markers;

import java.util.Objects;
import net.mehvahdjukaar.moonlight.api.map.CustomMapDecoration;
import net.mehvahdjukaar.moonlight.api.map.type.MapDecorationType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_22;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

public abstract class MapBlockMarker<D extends CustomMapDecoration> {
    protected final MapDecorationType<D, ?> type;
    private class_2338 pos;
    private int rot = 0;
    private class_2561 name;
    private boolean persistent;

    protected MapBlockMarker(MapDecorationType<D, ?> type) {
        this.type = type;
    }

    public void loadFromNBT(class_2487 compound) {
        this.pos = class_2512.method_10691((class_2487)compound.method_10562("Pos"));
        this.name = compound.method_10545("Name") ? class_2561.class_2562.method_10877((String)compound.method_10558("Name")) : null;
        this.persistent = compound.method_10577("Persistent");
    }

    public class_2487 saveToNBT(class_2487 compound) {
        compound.method_10566("Pos", (class_2520)class_2512.method_10692((class_2338)this.getPos()));
        if (this.name != null) {
            compound.method_10582("Name", class_2561.class_2562.method_10867((class_2561)this.name));
        }
        if (this.persistent) {
            compound.method_10556("Persistent", true);
        }
        return compound;
    }

    public boolean shouldRefresh() {
        if (this.persistent) {
            return false;
        }
        return this.type.isFromWorld();
    }

    public boolean shouldSave() {
        return this.persistent || this.type.isFromWorld();
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapBlockMarker that = (MapBlockMarker)o;
        return Objects.equals(this.type, that.type) && Objects.equals(this.pos, that.pos) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.pos, this.name);
    }

    private String getPosSuffix() {
        return this.pos.method_10263() + "," + this.pos.method_10264() + "," + this.pos.method_10260();
    }

    public MapDecorationType<D, ?> getType() {
        return this.type;
    }

    public String getTypeId() {
        return Utils.getID(this.type).toString();
    }

    public String getMarkerId() {
        return this.getTypeId() + "-" + this.getPosSuffix();
    }

    public class_2338 getPos() {
        return this.pos;
    }

    public void setPos(class_2338 pos) {
        this.pos = pos;
    }

    public void setRotation(int rot) {
        this.rot = rot;
    }

    public float getRotation() {
        return this.rot;
    }

    public class_2561 getName() {
        return this.name;
    }

    public void setName(class_2561 name) {
        this.name = name;
    }

    @Nullable
    protected abstract D doCreateDecoration(byte var1, byte var2, byte var3);

    public D createDecorationFromMarker(class_22 data) {
        double worldX = this.getPos().method_10263();
        double worldZ = this.getPos().method_10260();
        double rotation = this.getRotation();
        int i = 1 << data.field_119;
        float f = (float)(worldX - (double)data.field_116) / (float)i;
        float f1 = (float)(worldZ - (double)data.field_115) / (float)i;
        byte mapX = (byte)((double)(f * 2.0f) + 0.5);
        byte mapY = (byte)((double)(f1 * 2.0f) + 0.5);
        if (f >= -64.0f && f1 >= -64.0f && f <= 64.0f && f1 <= 64.0f) {
            byte rot = (byte)((rotation += rotation < 0.0 ? -8.0 : 8.0) * 16.0 / 360.0);
            return this.doCreateDecoration(mapX, mapY, rot);
        }
        return null;
    }
}

