/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.resources;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.management.openmbean.InvalidOpenTypeException;
import net.mehvahdjukaar.moonlight.api.client.TextureCache;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicTexturePack;
import net.mehvahdjukaar.moonlight.api.resources.recipe.IRecipeTemplate;
import net.mehvahdjukaar.moonlight.api.resources.recipe.TemplateRecipeManager;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_1867;
import net.minecraft.class_1869;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_799;
import org.jetbrains.annotations.NotNull;

public class RPUtils {
    /*
     * Enabled aggressive exception aggregation
     */
    public static String serializeJson(JsonElement json) throws IOException {
        try (StringWriter stringWriter = new StringWriter();){
            String string;
            try (JsonWriter jsonWriter = new JsonWriter((Writer)stringWriter);){
                jsonWriter.setLenient(true);
                jsonWriter.setIndent("  ");
                Streams.write((JsonElement)json, (JsonWriter)jsonWriter);
                string = stringWriter.toString();
            }
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static JsonObject deserializeJson(InputStream stream) {
        return class_3518.method_15255((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8));
    }

    public static class_2960 findFirstBlockTextureLocation(class_3300 manager, class_2248 block) throws FileNotFoundException {
        return RPUtils.findFirstBlockTextureLocation(manager, block, t -> true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static class_2960 findFirstBlockTextureLocation(class_3300 manager, class_2248 block, Predicate<String> texturePredicate) throws FileNotFoundException {
        String t;
        String cached = TextureCache.getCached((class_1935)block, texturePredicate);
        if (cached != null) {
            return new class_2960(cached);
        }
        class_2960 res = Utils.getID(block);
        Optional blockState = manager.method_14486(ResType.BLOCKSTATES.getPath(res));
        try (InputStream bsStream2 = ((class_3298)blockState.orElseThrow()).method_14482();){
            JsonObject bsElement = RPUtils.deserializeJson(bsStream2);
            String modelPath = (String)RPUtils.findAllResourcesInJsonRecursive((JsonElement)bsElement.getAsJsonObject(), s -> s.equals("model")).stream().findAny().get();
            List<String> textures = RPUtils.findAllTexturesInModelRecursive(manager, modelPath);
            for (String t2 : textures) {
                TextureCache.add((class_1935)block, t2);
                if (!texturePredicate.test(t2)) continue;
                class_2960 class_29602 = new class_2960(t2);
                return class_29602;
            }
        }
        catch (Exception bsStream2) {
            // empty catch block
        }
        List<String> hack = RPUtils.guessTextureLocation(res, manager, block);
        Iterator<String> iterator = hack.iterator();
        do {
            if (!iterator.hasNext()) throw new FileNotFoundException("Could not find any texture associated to the given block " + res);
            t = iterator.next();
            TextureCache.add((class_1935)block, t);
        } while (!texturePredicate.test(t));
        return new class_2960(t);
    }

    private static List<String> guessTextureLocation(class_2960 id, class_3300 manager, class_2248 block) {
        String name = id.method_12832();
        ArrayList<String> textures = new ArrayList<String>();
        for (WoodType w : WoodTypeRegistry.getTypes()) {
            if (!name.contains(w.id.method_12832())) continue;
            for (Map.Entry<String, Object> c : w.getChildren()) {
                if (c.getValue() != block) continue;
                if (Objects.equals(c.getKey(), "log") || c.getKey().equals("stripped_log")) {
                    textures.add(id.method_12836() + ":block/" + name + "_top");
                    textures.add(id.method_12836() + ":block/" + name + "_side");
                } else {
                    textures.add(id.method_12836() + ":block/" + name);
                }
                return textures;
            }
        }
        return List.of();
    }

    @NotNull
    private static List<String> findAllTexturesInModelRecursive(class_3300 manager, String modelPath) throws Exception {
        JsonObject modelElement;
        try (InputStream modelStream = ((class_3298)manager.method_14486(ResType.MODELS.getPath(modelPath)).get()).method_14482();){
            modelElement = RPUtils.deserializeJson(modelStream).getAsJsonObject();
        }
        catch (Exception e) {
            throw new Exception("Failed to parse model at " + modelPath);
        }
        ArrayList<String> textures = new ArrayList<String>(RPUtils.findAllResourcesInJsonRecursive((JsonElement)modelElement.getAsJsonObject("textures")));
        if (textures.isEmpty() && modelElement.has("parent")) {
            String parentPath = modelElement.get("parent").getAsString();
            textures.addAll(RPUtils.findAllTexturesInModelRecursive(manager, parentPath));
        }
        return textures;
    }

    public static class_2960 findFirstItemTextureLocation(class_3300 manager, class_1792 block) throws FileNotFoundException {
        return RPUtils.findFirstItemTextureLocation(manager, block, t -> true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static class_2960 findFirstItemTextureLocation(class_3300 manager, class_1792 item, Predicate<String> texturePredicate) throws FileNotFoundException {
        String cached = TextureCache.getCached((class_1935)item, texturePredicate);
        if (cached != null) {
            return new class_2960(cached);
        }
        class_2960 res = Utils.getID(item);
        Optional itemModel = manager.method_14486(ResType.ITEM_MODELS.getPath(res));
        try (InputStream stream = ((class_3298)itemModel.get()).method_14482();){
            String t;
            JsonObject bsElement = RPUtils.deserializeJson(stream);
            Set<String> textures = RPUtils.findAllResourcesInJsonRecursive((JsonElement)bsElement.getAsJsonObject().getAsJsonObject("textures"));
            Iterator<String> iterator = textures.iterator();
            do {
                if (!iterator.hasNext()) throw new FileNotFoundException("Could not find any texture associated to the given item " + res);
                t = iterator.next();
                TextureCache.add((class_1935)item, t);
            } while (!texturePredicate.test(t));
            class_2960 class_29602 = new class_2960(t);
            return class_29602;
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new FileNotFoundException("Could not find any texture associated to the given item " + res);
    }

    public static String findFirstResourceInJsonRecursive(JsonElement element) throws NoSuchElementException {
        if (element instanceof JsonArray) {
            JsonArray array = (JsonArray)element;
            return RPUtils.findFirstResourceInJsonRecursive(array.get(0));
        }
        if (element instanceof JsonObject) {
            Set entries = element.getAsJsonObject().entrySet();
            JsonElement child = (JsonElement)((Map.Entry)entries.stream().findAny().get()).getValue();
            return RPUtils.findFirstResourceInJsonRecursive(child);
        }
        return element.getAsString();
    }

    public static Set<String> findAllResourcesInJsonRecursive(JsonElement element) {
        return RPUtils.findAllResourcesInJsonRecursive(element, s -> true);
    }

    public static Set<String> findAllResourcesInJsonRecursive(JsonElement element, Predicate<String> filter) {
        if (element instanceof JsonArray) {
            JsonArray array = (JsonArray)element;
            HashSet<String> list = new HashSet<String>();
            array.forEach(e -> list.addAll(RPUtils.findAllResourcesInJsonRecursive(e, filter)));
            return list;
        }
        if (element instanceof JsonObject) {
            JsonObject json = (JsonObject)element;
            Set entries = json.entrySet();
            HashSet<String> list = new HashSet<String>();
            for (Map.Entry c : entries) {
                if (((JsonElement)c.getValue()).isJsonPrimitive() && !filter.test((String)c.getKey())) continue;
                Set<String> l = RPUtils.findAllResourcesInJsonRecursive((JsonElement)c.getValue(), filter);
                list.addAll(l);
            }
            return list;
        }
        return Set.of(element.getAsString());
    }

    public static class_1860<?> readRecipe(class_3300 manager, String location) {
        return RPUtils.readRecipe(manager, ResType.RECIPES.getPath(location));
    }

    public static class_1860<?> readRecipe(class_3300 manager, class_2960 location) {
        class_1860 class_18602;
        block8: {
            Optional resource = manager.method_14486(location);
            InputStream stream = ((class_3298)resource.orElseThrow()).method_14482();
            try {
                JsonObject element = RPUtils.deserializeJson(stream);
                class_18602 = class_1863.method_17720((class_2960)location, (JsonObject)element);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new InvalidOpenTypeException(String.format("Failed to get recipe at %s: %s", location, e));
                }
            }
            stream.close();
        }
        return class_18602;
    }

    public static IRecipeTemplate<?> readRecipeAsTemplate(class_3300 manager, String location) {
        return RPUtils.readRecipeAsTemplate(manager, ResType.RECIPES.getPath(location));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static IRecipeTemplate<?> readRecipeAsTemplate(class_3300 manager, class_2960 location) {
        Optional resource = manager.method_14486(location);
        try (InputStream stream = ((class_3298)resource.orElseThrow()).method_14482();){
            JsonObject element = RPUtils.deserializeJson(stream);
            try {
                IRecipeTemplate<?> iRecipeTemplate = TemplateRecipeManager.read(element);
                return iRecipeTemplate;
            }
            catch (Exception e) {
                Moonlight.LOGGER.error((Object)element);
                Moonlight.LOGGER.error((Object)location);
                throw e;
            }
        }
        catch (Exception e) {
            throw new InvalidOpenTypeException(String.format("Failed to get recipe at %s: %s", location, e));
        }
    }

    public static <T extends BlockType> class_1860<?> makeSimilarRecipe(class_1860<?> original, T originalMat, T destinationMat, String baseID) {
        if (original instanceof class_1869) {
            class_1869 or = (class_1869)original;
            ArrayList<class_1856> newList = new ArrayList<class_1856>();
            for (class_1856 ingredient : or.method_8117()) {
                class_1792 i;
                if (ingredient == null || ingredient.method_8105().length <= 0 || (i = BlockType.changeItemType(ingredient.method_8105()[0].method_7909(), originalMat, destinationMat)) == null) continue;
                newList.add(class_1856.method_8091((class_1935[])new class_1935[]{i}));
            }
            class_1792 originalRes = or.method_8110().method_7909();
            class_1792 newRes = BlockType.changeItemType(originalRes, originalMat, destinationMat);
            if (newRes == null) {
                throw new UnsupportedOperationException("Failed to convert recipe");
            }
            class_1799 result = newRes.method_8389().method_7854();
            class_2960 newId = new class_2960(baseID + "/" + destinationMat.getAppendableId());
            class_2371 ingredients = class_2371.method_10212((Object)class_1856.field_9017, (Object[])((class_1856[])newList.toArray(class_1856[]::new)));
            return new class_1869(newId, or.method_8112(), or.method_8150(), or.method_8158(), ingredients, result);
        }
        if (original instanceof class_1867) {
            class_1867 or = (class_1867)original;
            ArrayList<class_1856> newList = new ArrayList<class_1856>();
            for (class_1856 ingredient : or.method_8117()) {
                class_1792 i;
                if (ingredient == null || ingredient.method_8105().length <= 0 || (i = BlockType.changeItemType(ingredient.method_8105()[0].method_7909(), originalMat, destinationMat)) == null) continue;
                newList.add(class_1856.method_8091((class_1935[])new class_1935[]{i}));
            }
            Iterator originalRes = or.method_8110().method_7909();
            class_1792 newRes = BlockType.changeItemType((class_1792)originalRes, originalMat, destinationMat);
            if (newRes == null) {
                throw new UnsupportedOperationException("Failed to convert recipe");
            }
            class_1799 result = newRes.method_8389().method_7854();
            class_2960 newId = new class_2960(baseID + "/" + destinationMat.getAppendableId());
            class_2371 ingredients = class_2371.method_10212((Object)class_1856.field_9017, (Object[])((class_1856[])newList.toArray(class_1856[]::new)));
            return new class_1867(newId, or.method_8112(), result, ingredients);
        }
        throw new UnsupportedOperationException(String.format("Original recipe %s must be Shaped or Shapeless", original));
    }

    public static void addCrossbowModel(class_3300 manager, DynamicTexturePack pack, Consumer<CrossbowModelAdder> modelConsumer) {
        class_2960 res = new class_2960("crossbow");
        Optional o = manager.method_14486(ResType.ITEM_MODELS.getPath(res));
        if (o.isPresent()) {
            try (InputStream model = ((class_3298)o.get()).method_14482();){
                JsonObject json = RPUtils.deserializeJson(model);
                JsonArray overrides = json.getAsJsonArray("overrides");
                modelConsumer.accept(ov -> overrides.add((JsonElement)RPUtils.serializeOverride(ov)));
                json.add("overrides", (JsonElement)overrides);
                pack.addItemModel(res, (JsonElement)json);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static JsonObject serializeOverride(class_799 override) {
        JsonObject json = new JsonObject();
        json.addProperty("model", override.method_3472().toString());
        JsonObject predicates = new JsonObject();
        override.method_33690().forEach(p -> predicates.addProperty(p.method_33692().toString(), (Number)Float.valueOf(p.method_33693())));
        json.add("predicate", (JsonElement)predicates);
        return json;
    }

    @FunctionalInterface
    public static interface CrossbowModelAdder {
        public void add(class_799 var1);
    }
}

