/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.resources.pack;

import com.google.gson.JsonElement;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import net.mehvahdjukaar.moonlight.api.integration.ModernFixCompat;
import net.mehvahdjukaar.moonlight.api.platform.PlatformHelper;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.StaticResource;
import net.mehvahdjukaar.moonlight.api.resources.assets.LangBuilder;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3270;
import net.minecraft.class_3272;
import net.minecraft.class_3274;
import net.minecraft.class_3281;
import net.minecraft.class_3288;
import net.minecraft.class_5250;
import net.minecraft.class_5352;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public abstract class DynamicResourcePack
implements class_3262 {
    @ApiStatus.Internal
    public static final List<DynamicResourcePack> INSTANCES = new ArrayList<DynamicResourcePack>();
    protected static final Logger LOGGER = LogManager.getLogger();
    public static final List<class_2960> NO_RESOURCES = Collections.emptyList();
    protected final boolean hidden;
    protected final boolean fixed;
    protected final class_3288.class_3289 position;
    protected final class_3264 packType;
    protected final class_3272 packInfo;
    protected final class_2561 title;
    protected final class_2960 resourcePackName;
    protected final Set<String> namespaces = new HashSet<String>();
    protected final Map<class_2960, byte[]> resources = new ConcurrentHashMap<class_2960, byte[]>();
    protected final Map<String, byte[]> rootResources = new ConcurrentHashMap<String, byte[]>();
    protected final String mainNamespace;
    public boolean generateDebugResources = false;
    public boolean canBeCleared = true;
    public Set<class_2960> persistentResources = new HashSet<class_2960>();
    boolean addToPersistent = false;
    private static final boolean MODERN_FIX = PlatformHelper.isModLoaded("modernfix") && ModernFixCompat.areLazyResourcesOn();

    protected DynamicResourcePack(class_2960 name, class_3264 type) {
        this(name, type, class_3288.class_3289.field_14280, false, false);
    }

    protected DynamicResourcePack(class_2960 name, class_3264 type, class_3288.class_3289 position, boolean fixed, boolean hidden) {
        this.packType = type;
        class_5250 component = class_2561.method_43471((String)LangBuilder.getReadableName(name.method_12836() + "_dynamic_resources"));
        this.packInfo = new class_3272((class_2561)component, 6);
        this.resourcePackName = name;
        this.mainNamespace = name.method_12836();
        this.namespaces.add(name.method_12836());
        this.title = class_2561.method_43471((String)LangBuilder.getReadableName(name.toString()));
        this.position = position;
        this.fixed = fixed;
        this.hidden = hidden;
        this.generateDebugResources = PlatformHelper.isDev();
    }

    public void addNamespaces(String ... namespaces) {
        this.namespaces.addAll(Arrays.asList(namespaces));
    }

    public class_2561 getTitle() {
        return this.title;
    }

    public String method_14409() {
        return this.title.getString();
    }

    public String toString() {
        return this.method_14409();
    }

    public void registerPack() {
        PlatformHelper.registerResourcePack(this.packType, () -> new class_3288(this.method_14409(), true, () -> this, this.getTitle(), this.packInfo.method_14423(), class_3281.field_14224, class_3288.class_3289.field_14280, this.fixed, class_5352.field_25348));
        INSTANCES.add(this);
    }

    public Set<String> method_14406(class_3264 packType) {
        return this.namespaces;
    }

    public <T> T method_14407(class_3270<T> serializer) {
        return (T)(serializer instanceof class_3274 ? this.packInfo : null);
    }

    public void addRootResource(String name, byte[] resource) {
        this.rootResources.put(name, resource);
    }

    @Nullable
    public InputStream method_14410(String pFileName) throws IOException {
        byte[] buf = this.rootResources.get(pFileName);
        if (buf != null) {
            return new ByteArrayInputStream(buf);
        }
        throw this.makeException(pFileName);
    }

    public Collection<class_2960> method_14408(class_3264 packType, String namespace, String id, Predicate<class_2960> filter) {
        if (packType == this.packType && packType == class_3264.field_14190 && this.namespaces.contains(namespace)) {
            return this.resources.keySet().stream().filter(r -> r.method_12836().equals(namespace) && r.method_12832().startsWith(id)).filter(filter).toList();
        }
        return NO_RESOURCES;
    }

    public InputStream method_14405(class_3264 type, class_2960 id) throws IOException {
        if (type != this.packType) {
            throw new IOException(String.format("Tried to access wrong type of resource on %s.", this.resourcePackName));
        }
        if (this.resources.containsKey(id)) {
            try {
                return new ByteArrayInputStream(this.resources.get(id));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        throw this.makeException(String.format("%s/%s/%s", type.method_14413(), id.method_12836(), id.method_12832()));
    }

    public boolean method_14411(class_3264 type, class_2960 id) {
        return type == this.packType && this.resources.containsKey(id);
    }

    public void close() {
        if (this.packType == class_3264.field_14188) {
            // empty if block
        }
    }

    public void clearResources() {
        if (this.canBeCleared) {
            for (class_2960 r : this.resources.keySet()) {
                if (this.persistentResources.contains(r)) continue;
                this.resources.remove(r);
            }
        }
    }

    private FileNotFoundException makeException(String pFileName) {
        return new FileNotFoundException(String.format(Locale.ROOT, "'%s' in ResourcePack '%s'", pFileName, this.resourcePackName));
    }

    protected void addBytes(class_2960 path, byte[] bytes) {
        this.namespaces.add(path.method_12836());
        this.resources.put(path, bytes);
        if (this.addToPersistent || this.modernFixHack(path)) {
            this.persistentResources.add(path);
        }
        if (this.generateDebugResources) {
            try {
                Path p = Paths.get("debug", "generated_resource_pack").resolve(path.method_12836() + "/" + path.method_12832());
                Files.createDirectories(p.getParent(), new FileAttribute[0]);
                Files.write(p, bytes, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void addResource(StaticResource resource) {
        this.addBytes(resource.location, resource.data);
    }

    private void addJson(class_2960 path, JsonElement json) {
        try {
            this.addBytes(path, RPUtils.serializeJson(json).getBytes());
        }
        catch (IOException e) {
            LOGGER.error("Failed to write JSON {} to resource pack {}.", (Object)path, (Object)this.resourcePackName, (Object)e);
        }
    }

    public void addJson(class_2960 location, JsonElement json, ResType resType) {
        this.addJson(resType.getPath(location), json);
    }

    public void addBytes(class_2960 location, byte[] bytes, ResType resType) {
        this.addBytes(resType.getPath(location), bytes);
    }

    public class_3264 getPackType() {
        return this.packType;
    }

    private boolean modernFixHack(class_2960 path) {
        if (MODERN_FIX) {
            String p = path.method_12832();
            return p.startsWith("model") || p.startsWith("blockstate");
        }
        return false;
    }
}

