/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.network;

import java.util.Objects;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mehvahdjukaar.moonlight.api.entity.IExtraClientSpawnData;
import net.mehvahdjukaar.moonlight.api.platform.network.ChannelHandler;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_3532;
import net.minecraft.class_638;

public class ClientBoundSpawnCustomEntityMessage
implements Message {
    private final class_1297 entity;
    private final int typeId;
    private final int entityId;
    private final UUID uuid;
    private final double posX;
    private final double posY;
    private final double posZ;
    private final byte pitch;
    private final byte yaw;
    private final byte headYaw;
    private final int velX;
    private final int velY;
    private final int velZ;
    private final class_2540 buf;

    public ClientBoundSpawnCustomEntityMessage(class_1297 e) {
        this.entity = e;
        this.typeId = class_2378.field_11145.method_10206((Object)e.method_5864());
        this.entityId = e.method_5628();
        this.uuid = e.method_5667();
        this.posX = e.method_23317();
        this.posY = e.method_23318();
        this.posZ = e.method_23321();
        this.pitch = (byte)class_3532.method_15375((float)(e.method_36455() * 256.0f / 360.0f));
        this.yaw = (byte)class_3532.method_15375((float)(e.method_36454() * 256.0f / 360.0f));
        this.headYaw = (byte)(e.method_5791() * 256.0f / 360.0f);
        class_243 vec3d = e.method_18798();
        double d1 = class_3532.method_15350((double)vec3d.field_1352, (double)-3.9, (double)3.9);
        double d2 = class_3532.method_15350((double)vec3d.field_1351, (double)-3.9, (double)3.9);
        double d3 = class_3532.method_15350((double)vec3d.field_1350, (double)-3.9, (double)3.9);
        this.velX = (int)(d1 * 8000.0);
        this.velY = (int)(d2 * 8000.0);
        this.velZ = (int)(d3 * 8000.0);
        this.buf = null;
    }

    public ClientBoundSpawnCustomEntityMessage(class_2540 buf) {
        this.entity = null;
        this.typeId = buf.method_10816();
        this.entityId = buf.readInt();
        this.uuid = new UUID(buf.readLong(), buf.readLong());
        this.posX = buf.readDouble();
        this.posY = buf.readDouble();
        this.posZ = buf.readDouble();
        this.pitch = buf.readByte();
        this.yaw = buf.readByte();
        this.headYaw = buf.readByte();
        this.velX = buf.readShort();
        this.velY = buf.readShort();
        this.velZ = buf.readShort();
        this.buf = new class_2540(buf.copy());
        buf.clear();
    }

    @Override
    public void writeToBuffer(class_2540 buf) {
        buf.method_10804(this.typeId);
        buf.writeInt(this.entityId);
        buf.writeLong(this.uuid.getMostSignificantBits());
        buf.writeLong(this.uuid.getLeastSignificantBits());
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
        buf.writeByte((int)this.pitch);
        buf.writeByte((int)this.yaw);
        buf.writeByte((int)this.headYaw);
        buf.writeShort(this.velX);
        buf.writeShort(this.velY);
        buf.writeShort(this.velZ);
        class_1297 class_12972 = this.entity;
        if (class_12972 instanceof IExtraClientSpawnData) {
            IExtraClientSpawnData spawnData = (IExtraClientSpawnData)class_12972;
            spawnData.writeSpawnData(buf);
        }
    }

    @Override
    public void handle(ChannelHandler.Context context) {
        class_1937 world;
        class_1297 e;
        class_1299 type = (class_1299)class_2378.field_11145.method_10200(this.typeId);
        if (type != null && (e = type.method_5883(world = context.getSender().method_37908())) != null) {
            e.method_43391(this.posX, this.posY, this.posZ);
            e.method_5641(this.posX, this.posY, this.posZ, (float)(this.yaw * 360) / 256.0f, (float)(this.pitch * 360) / 256.0f);
            e.method_5847((float)(this.headYaw * 360) / 256.0f);
            e.method_5636((float)(this.headYaw * 360) / 256.0f);
            e.method_5838(this.entityId);
            e.method_5826(this.uuid);
            Objects.requireNonNull(class_638.class);
            this.clientSideStuff(world, e);
            e.method_5750((double)this.velX / 8000.0, (double)this.velY / 8000.0, (double)this.velZ / 8000.0);
            if (e instanceof IExtraClientSpawnData) {
                IExtraClientSpawnData spawnData = (IExtraClientSpawnData)e;
                spawnData.readSpawnData(this.buf);
            }
        }
        this.buf.clear();
    }

    @Environment(value=EnvType.CLIENT)
    private void clientSideStuff(class_1937 world, class_1297 e) {
        ((class_638)world).method_2942(this.entityId, e);
    }
}

