/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.moregeodes.blocks;

import carpet.CarpetSettings;
import com.github.thedeathlycow.moregeodes.MoreGeodes;
import com.github.thedeathlycow.moregeodes.blocks.CrystalBlock;
import com.github.thedeathlycow.moregeodes.blocks.CrystalClusterBlock;
import com.github.thedeathlycow.moregeodes.blocks.LargeCrystalClusterBlock;
import com.github.thedeathlycow.moregeodes.sounds.CrystalBlockSoundGroup;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1810;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3612;
import net.minecraft.class_3619;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class GeodeBuddingBlock
extends CrystalBlock {
    private static final class_2350[] DIRECTIONS = class_2350.values();
    private final List<class_2248> clusters;

    public GeodeBuddingBlock(CrystalBlockSoundGroup hitSoundGroup, class_4970.class_2251 settings, List<class_2248> clusters) {
        super(hitSoundGroup, settings);
        this.clusters = clusters;
    }

    public class_3619 method_9527(class_2680 state) {
        if (MoreGeodes.isCarpetLoaded() && CarpetSettings.movableAmethyst) {
            return class_3619.field_15974;
        }
        return class_3619.field_15971;
    }

    public void method_9556(class_1937 world, class_1657 player, class_2338 pos, class_2680 state, @Nullable class_2586 blockEntity, class_1799 stack) {
        super.method_9556(world, player, pos, state, blockEntity, stack);
        if (MoreGeodes.isCarpetLoaded() && CarpetSettings.movableAmethyst && stack.method_7909() instanceof class_1810 && class_1890.method_8225((class_1887)class_1893.field_9099, (class_1799)stack) > 0) {
            GeodeBuddingBlock.method_9577((class_1937)world, (class_2338)pos, (class_1799)this.method_8389().method_7854());
        }
    }

    public void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (this.shouldGrow(random)) {
            class_2350 directionToGrow = DIRECTIONS[random.method_43048(DIRECTIONS.length)];
            this.growCrystalOnce(world, pos, directionToGrow);
        }
    }

    public List<class_2248> getClusters() {
        return Collections.unmodifiableList(this.clusters);
    }

    public List<class_2680> getClusterStates() {
        return this.getClusters().stream().map(class_2248::method_9564).collect(Collectors.toList());
    }

    protected boolean shouldGrow(class_5819 random) {
        return random.method_43048(5) == 0;
    }

    protected void growCrystalOnce(class_3218 world, class_2338 pos, class_2350 directionToGrow) {
        class_2338 positionToGrow = pos.method_10093(directionToGrow);
        class_2680 currentStateInGrow = world.method_8320(positionToGrow);
        Optional<class_2248> nextBud = this.getNextBlockForGrowth(currentStateInGrow, directionToGrow);
        nextBud.ifPresent(nextGrowth -> {
            class_2680 nextBudState = (class_2680)((class_2680)nextGrowth.method_9564().method_11657((class_2769)CrystalClusterBlock.FACING, (Comparable)directionToGrow)).method_11657((class_2769)CrystalClusterBlock.WATERLOGGED, (Comparable)Boolean.valueOf(currentStateInGrow.method_26227().method_15772() == class_3612.field_15910));
            if (nextGrowth instanceof LargeCrystalClusterBlock) {
                boolean canGrow;
                class_2350 facing = (class_2350)nextBudState.method_11654((class_2769)CrystalClusterBlock.FACING);
                class_2338 headPos = positionToGrow.method_10093(facing);
                class_2680 headState = world.method_8320(headPos);
                boolean bl = canGrow = (this.stateCanGrowNewBud(headState) || this.stateCanGrowBud(headState, facing)) && nextBudState.method_26184((class_4538)world, positionToGrow);
                if (canGrow) {
                    LargeCrystalClusterBlock.placeAt((class_1936)world, nextBudState, positionToGrow, 3);
                }
            } else {
                world.method_8652(positionToGrow, nextBudState, 3);
            }
        });
    }

    protected Optional<class_2248> getNextBlockForGrowth(class_2680 currentState, class_2350 offsetFromSource) {
        class_2248 currentBlock = currentState.method_26204();
        Iterator<class_2248> buds = this.clusters.iterator();
        if (this.stateCanGrowNewBud(currentState) && buds.hasNext()) {
            return Optional.of(buds.next());
        }
        if (this.stateCanGrowBud(currentState, offsetFromSource)) {
            class_2248 bud = buds.next();
            while (buds.hasNext()) {
                if (bud == currentBlock) {
                    return Optional.of(buds.next());
                }
                bud = buds.next();
            }
        }
        return Optional.empty();
    }

    private boolean stateCanGrowBud(class_2680 state, class_2350 direction) {
        return state.method_28498((class_2769)CrystalClusterBlock.FACING) && state.method_11654((class_2769)CrystalClusterBlock.FACING) == direction && this.clusters.contains(state.method_26204());
    }

    private boolean stateCanGrowNewBud(class_2680 state) {
        return state.method_26215() || state.method_27852(class_2246.field_10382) && state.method_26227().method_15761() == 8;
    }
}

