/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.merequester.platform;

import com.almostreliable.merequester.Utils;
import com.almostreliable.merequester.mixin.accessors.ScreenMixin;
import com.almostreliable.merequester.network.DragAndDropPacket;
import com.almostreliable.merequester.network.RequestUpdatePacket;
import com.almostreliable.merequester.network.RequesterSyncPacket;
import com.almostreliable.merequester.platform.Config;
import eu.midnightdust.lib.config.MidnightConfig;
import java.util.List;
import net.fabricmc.fabric.api.client.itemgroup.FabricItemGroupBuilder;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_4068;
import net.minecraft.class_437;

public final class Platform {
    private Platform() {
    }

    public static void initConfig() {
        MidnightConfig.init((String)"merequester", Config.class);
    }

    public static int getRequestLimit() {
        return Config.REQUESTS;
    }

    public static double getIdleEnergy() {
        return Config.IDLE_ENERGY;
    }

    public static boolean requireChannel() {
        return Config.REQUIRE_CHANNEL;
    }

    public static class_1761 createTab() {
        return FabricItemGroupBuilder.build((class_2960)Utils.getRL("tab"), () -> ((class_1792)class_2378.field_11142.method_10223(Utils.getRL("requester_terminal"))).method_7854());
    }

    public static void sendRequestUpdate(long requesterId, int requestIndex, boolean state) {
        ClientPlayNetworking.send((class_2960)RequestUpdatePacket.CHANNEL, (class_2540)RequestUpdatePacket.encode(requesterId, requestIndex, state));
    }

    public static void sendRequestUpdate(long requesterId, int requestIndex, long amount, long batch) {
        ClientPlayNetworking.send((class_2960)RequestUpdatePacket.CHANNEL, (class_2540)RequestUpdatePacket.encode(requesterId, requestIndex, amount, batch));
    }

    public static void sendDragAndDrop(long requesterId, int requestIndex, class_1799 item) {
        ClientPlayNetworking.send((class_2960)DragAndDropPacket.CHANNEL, (class_2540)DragAndDropPacket.encode(requesterId, requestIndex, item));
    }

    public static void sendClearData(class_1657 player) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            ServerPlayNetworking.send((class_3222)serverPlayer, (class_2960)RequesterSyncPacket.CHANNEL, (class_2540)RequesterSyncPacket.encode());
        }
    }

    public static void sendInventoryData(class_1657 player, long requesterId, class_2487 data) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            ServerPlayNetworking.send((class_3222)serverPlayer, (class_2960)RequesterSyncPacket.CHANNEL, (class_2540)RequesterSyncPacket.encode(requesterId, data));
        }
    }

    public static List<class_4068> getRenderables(class_437 screen) {
        return Utils.cast(screen, ScreenMixin.class).merequester$getRenderables();
    }
}

