/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.merequester.requester.abstraction;

import appeng.api.inventories.InternalInventory;
import appeng.api.networking.IGrid;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.helpers.InventoryAction;
import appeng.menu.AEBaseMenu;
import appeng.menu.me.interaction.EmptyingAction;
import appeng.menu.me.interaction.StackInteractions;
import com.almostreliable.merequester.MERequester;
import com.almostreliable.merequester.platform.Platform;
import com.almostreliable.merequester.requester.RequesterBlockEntity;
import com.almostreliable.merequester.requester.Requests;
import com.almostreliable.merequester.requester.abstraction.RequestTracker;
import javax.annotation.Nullable;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import net.minecraft.class_3917;

public abstract class AbstractRequesterMenu
extends AEBaseMenu {
    public static final String SORT_BY_ID = "sort_by";
    public static final String UNIQUE_NAME_ID = "unique_name";
    private long idSerial = Long.MIN_VALUE;

    protected AbstractRequesterMenu(class_3917<?> menuType, int id, class_1661 playerInventory, Object host) {
        super(menuType, id, playerInventory, host);
        this.createPlayerInventorySlots(playerInventory);
    }

    public void doAction(class_3222 player, InventoryAction action, int slot, long id) {
        RequestTracker requestTracker = this.getRequestTracker(id);
        if (requestTracker == null) {
            return;
        }
        if (slot < 0 || slot >= requestTracker.getServer().size()) {
            MERequester.LOGGER.warn("Requester Screen refers to invalid slot {} of {}", (Object)slot, (Object)requestTracker.getName());
            return;
        }
        InternalInventory requestSlot = requestTracker.getServer().getSlotInv(slot);
        class_1799 requestStack = requestSlot.getStackInSlot(0);
        class_1799 carriedStack = this.method_34255();
        switch (action) {
            case PICKUP_OR_SET_DOWN: {
                requestSlot.setItemDirect(0, carriedStack.method_7960() ? class_1799.field_8037 : carriedStack.method_7972());
                break;
            }
            case SPLIT_OR_PLACE_SINGLE: {
                if (carriedStack.method_7960()) {
                    requestSlot.setItemDirect(0, class_1799.field_8037);
                    break;
                }
                class_1799 copy = carriedStack.method_7972();
                copy.method_7939(1);
                requestSlot.setItemDirect(0, copy);
                break;
            }
            case SHIFT_CLICK: {
                requestSlot.setItemDirect(0, class_1799.field_8037);
                break;
            }
            case EMPTY_ITEM: {
                EmptyingAction emptyingAction = StackInteractions.getEmptyingAction((class_1799)carriedStack);
                if (emptyingAction == null) break;
                requestSlot.insertItem(0, GenericStack.wrapInItemStack((AEKey)emptyingAction.what(), (long)emptyingAction.maxAmount()), false);
                break;
            }
            case CREATIVE_DUPLICATE: {
                if (!player.method_31549().field_7477 || !carriedStack.method_7960()) break;
                if (requestStack.method_7960()) {
                    this.method_34254(class_1799.field_8037);
                    break;
                }
                class_1799 stack = requestStack.method_7972();
                stack.method_7939(stack.method_7914());
                this.method_34254(stack);
                break;
            }
        }
    }

    public void applyDragAndDrop(class_3222 player, int requestIndex, long requesterId, class_1799 item) {
        this.method_34254(item);
        this.doAction(player, InventoryAction.PICKUP_OR_SET_DOWN, requestIndex, requesterId);
        this.method_34254(class_1799.field_8037);
    }

    public void updateRequesterState(long requesterId, int requestIndex, boolean state) {
        RequestTracker requestTracker = this.getRequestTracker(requesterId);
        if (requestTracker == null) {
            return;
        }
        Requests.Request request = requestTracker.getServer().get(requestIndex);
        request.updateState(state);
    }

    public void updateRequesterNumbers(long requesterId, int requestIndex, long amount, long batch) {
        RequestTracker requestTracker = this.getRequestTracker(requesterId);
        if (requestTracker == null) {
            return;
        }
        Requests.Request request = requestTracker.getServer().get(requestIndex);
        request.updateAmount(amount);
        request.updateBatch(batch);
    }

    protected abstract void sendFullUpdate(@Nullable IGrid var1);

    protected abstract void sendPartialUpdate();

    protected void syncRequestTrackerFull(RequestTracker requestTracker) {
        Requests server = requestTracker.getServer();
        Requests client = requestTracker.getClient();
        class_2487 tag = server.serialize();
        client.deserialize(tag);
        tag.method_10582(UNIQUE_NAME_ID, requestTracker.getName());
        tag.method_10544(SORT_BY_ID, requestTracker.getSortBy());
        Platform.sendInventoryData(this.getPlayer(), requestTracker.getId(), tag);
    }

    protected void syncRequestTrackerPartial(RequestTracker requestTracker) {
        Requests server = requestTracker.getServer();
        Requests client = requestTracker.getClient();
        class_2487 tag = null;
        for (int i = 0; i < server.size(); ++i) {
            Requests.Request clientRequest;
            Requests.Request serverRequest = server.get(i);
            if (!serverRequest.isDifferent(clientRequest = client.get(i))) continue;
            if (tag == null) {
                tag = new class_2487();
                tag.method_10582(UNIQUE_NAME_ID, requestTracker.getName());
                tag.method_10544(SORT_BY_ID, requestTracker.getSortBy());
            }
            class_2487 serverData = serverRequest.serialize();
            tag.method_10566(String.valueOf(i), (class_2520)serverData);
            clientRequest.deserialize(serverData);
        }
        if (tag != null) {
            Platform.sendInventoryData(this.getPlayer(), requestTracker.getId(), tag);
        }
    }

    protected RequestTracker createTracker(RequesterBlockEntity requester) {
        RequestTracker requestTracker = new RequestTracker(requester, this.idSerial);
        ++this.idSerial;
        return requestTracker;
    }

    @Nullable
    protected abstract RequestTracker getRequestTracker(long var1);
}

