/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.numismaticoverhaul.client.gui.purse;

import com.glisco.numismaticoverhaul.NumismaticOverhaul;
import com.glisco.numismaticoverhaul.client.gui.purse.AlwaysOnTopTexturedButtonWidget;
import com.glisco.numismaticoverhaul.currency.Currency;
import com.glisco.numismaticoverhaul.currency.CurrencyComponent;
import com.glisco.numismaticoverhaul.currency.CurrencyConverter;
import com.glisco.numismaticoverhaul.currency.CurrencyResolver;
import com.glisco.numismaticoverhaul.network.RequestPurseActionC2SPacket;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_6379;
import net.minecraft.class_6382;
import org.apache.commons.lang3.mutable.MutableInt;

public class PurseWidget
extends class_332
implements class_4068,
class_364,
class_6379 {
    public static final class_2960 TEXTURE = NumismaticOverhaul.id("textures/gui/purse_widget.png");
    private final class_310 client;
    private final int x;
    private final int y;
    private boolean active = false;
    private final List<class_4185> buttons = new ArrayList<class_4185>();
    private final MutableInt goldAmount = new MutableInt(0);
    private final MutableInt silverAmount = new MutableInt(0);
    private final MutableInt bronzeAmount = new MutableInt(0);
    private final CurrencyComponent currencyStorage;

    public PurseWidget(int x, int y, class_310 client, CurrencyComponent currencyStorage) {
        this.client = client;
        this.x = x;
        this.y = y;
        this.buttons.add((class_4185)new SmallPurseAdjustButton(x + 18, y + 10, button -> this.modifyInBounds(this.goldAmount, true, Currency.GOLD), true));
        this.buttons.add((class_4185)new SmallPurseAdjustButton(x + 18, y + 16, button -> this.modifyInBounds(this.goldAmount, false, Currency.GOLD), false));
        this.buttons.add((class_4185)new SmallPurseAdjustButton(x + 18, y + 22, button -> this.modifyInBounds(this.silverAmount, true, Currency.SILVER), true));
        this.buttons.add((class_4185)new SmallPurseAdjustButton(x + 18, y + 28, button -> this.modifyInBounds(this.silverAmount, false, Currency.SILVER), false));
        this.buttons.add((class_4185)new SmallPurseAdjustButton(x + 18, y + 34, button -> this.modifyInBounds(this.bronzeAmount, true, Currency.BRONZE), true));
        this.buttons.add((class_4185)new SmallPurseAdjustButton(x + 18, y + 40, button -> this.modifyInBounds(this.bronzeAmount, false, Currency.BRONZE), false));
        this.buttons.add((class_4185)new AlwaysOnTopTexturedButtonWidget(x + 3, y + 46, 24, 8, 37, 0, 16, TEXTURE, button -> {
            if (class_437.method_25442() && class_437.method_25441()) {
                NumismaticOverhaul.CHANNEL.clientHandle().send((Record)RequestPurseActionC2SPacket.extractAll());
            } else if (this.selectedValue() > 0L) {
                NumismaticOverhaul.CHANNEL.clientHandle().send((Record)RequestPurseActionC2SPacket.extract(this.selectedValue()));
                this.resetSelectedValue();
            }
        }));
        this.currencyStorage = currencyStorage;
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        if (!this.active) {
            return;
        }
        RenderSystem.disableDepthTest();
        RenderSystem.setShaderTexture((int)0, (class_2960)TEXTURE);
        this.method_25302(matrices, this.x, this.y, 0, 0, 37, 60);
        for (class_4185 button : this.buttons) {
            button.method_25394(matrices, mouseX, mouseY, delta);
        }
        this.client.field_1772.method_30883(matrices, (class_2561)class_2561.method_43470((String)("" + this.goldAmount)), (float)(this.x + 5), (float)(this.y + 12), 0xFFFFFF);
        this.client.field_1772.method_30883(matrices, (class_2561)class_2561.method_43470((String)("" + this.silverAmount)), (float)(this.x + 5), (float)(this.y + 24), 0xFFFFFF);
        this.client.field_1772.method_30883(matrices, (class_2561)class_2561.method_43470((String)("" + this.bronzeAmount)), (float)(this.x + 5), (float)(this.y + 36), 0xFFFFFF);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!this.active || this.client.field_1724.method_7325()) {
            return false;
        }
        for (class_4185 buttonWidget : this.buttons) {
            if (!buttonWidget.method_25402(mouseX, mouseY, button)) continue;
            return true;
        }
        return this.method_25405(mouseX, mouseY);
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return mouseX >= (double)this.x && mouseX <= (double)(this.x + 37) && mouseY >= (double)this.y && mouseY <= (double)(this.y + 57) && this.active;
    }

    public void toggleActive() {
        this.active = !this.active;
    }

    private void modifyInBounds(MutableInt value, boolean add, Currency currency) {
        this.modifyInBounds(value, class_437.method_25442() ? 10 : 1, add, currency);
    }

    private void modifyInBounds(MutableInt value, int modifyBy, boolean add, Currency currency) {
        long stepSize = currency.getRawValue(1L);
        long possibleSteps = (this.currencyStorage.getValue() - this.selectedValue()) / stepSize;
        int upperBound = CurrencyConverter.asInt(Math.min((long)value.intValue() + possibleSteps, 99L));
        if (add) {
            value.add(modifyBy);
        } else {
            value.subtract(modifyBy);
        }
        if (value.intValue() < 0) {
            value.setValue(0);
        }
        if (value.intValue() > upperBound) {
            value.setValue(upperBound);
        }
    }

    private long selectedValue() {
        return CurrencyResolver.combineValues(new long[]{this.bronzeAmount.getValue().intValue(), this.silverAmount.getValue().intValue(), this.goldAmount.getValue().intValue()});
    }

    private void resetSelectedValue() {
        this.currencyStorage.silentModify(-this.selectedValue());
        int oldGoldAmount = this.goldAmount.intValue();
        int oldSilverAmount = this.silverAmount.intValue();
        int oldBronzeAmount = this.bronzeAmount.intValue();
        this.goldAmount.setValue(0);
        this.bronzeAmount.setValue(0);
        this.silverAmount.setValue(0);
        this.modifyInBounds(this.goldAmount, oldGoldAmount, true, Currency.GOLD);
        this.modifyInBounds(this.silverAmount, oldSilverAmount, true, Currency.SILVER);
        this.modifyInBounds(this.bronzeAmount, oldBronzeAmount, true, Currency.BRONZE);
    }

    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33786;
    }

    public void method_37020(class_6382 builder) {
    }

    public static class SmallPurseAdjustButton
    extends AlwaysOnTopTexturedButtonWidget {
        public SmallPurseAdjustButton(int x, int y, class_4185.class_4241 pressAction, boolean add) {
            super(x, y, 9, 5, add ? 37 : 46, 24, 10, TEXTURE, pressAction);
        }
    }
}

