/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.numismaticoverhaul.currency;

import com.glisco.numismaticoverhaul.currency.CurrencyConverter;
import com.glisco.numismaticoverhaul.currency.CurrencyResolver;
import com.glisco.numismaticoverhaul.item.CurrencyItem;
import com.glisco.numismaticoverhaul.item.MoneyBagItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;

public class CurrencyHelper {
    public static long getMoneyInInventory(class_1657 player, boolean remove) {
        long value = 0L;
        for (int i = 0; i < player.method_31548().method_5439(); ++i) {
            class_1792 class_17922;
            class_1799 stack = player.method_31548().method_5438(i);
            if (CurrencyHelper.isCombined(stack) || !((class_17922 = stack.method_7909()) instanceof CurrencyItem)) continue;
            CurrencyItem currencyItem = (CurrencyItem)class_17922;
            value += currencyItem.getValue(stack);
            if (!remove) continue;
            player.method_31548().method_7378(stack);
        }
        return value;
    }

    public static int getValue(List<class_1799> stacks) {
        return stacks.stream().mapToInt(stack -> {
            if (stack == null) {
                return 0;
            }
            if (CurrencyHelper.isCombined(stack)) {
                return 0;
            }
            class_1792 patt1514$temp = stack.method_7909();
            if (!(patt1514$temp instanceof CurrencyItem)) {
                return 0;
            }
            CurrencyItem currencyItem = (CurrencyItem)patt1514$temp;
            return (int)currencyItem.getValue((class_1799)stack);
        }).sum();
    }

    public static void offerAsCoins(class_1657 player, long value) {
        for (class_1799 itemStack : CurrencyConverter.getAsValidStacks(value)) {
            player.method_31548().method_7398(itemStack);
        }
    }

    public static boolean deduceFromInventory(class_1657 player, long value) {
        long presentInInventory = CurrencyHelper.getMoneyInInventory(player, false);
        if (presentInInventory < value) {
            return false;
        }
        CurrencyHelper.getMoneyInInventory(player, true);
        CurrencyHelper.offerAsCoins(player, presentInInventory - value);
        return true;
    }

    public static List<class_1799> getAsStacks(long value, int maxStacks) {
        ArrayList<class_1799> stacks = new ArrayList<class_1799>();
        List<class_1799> rawStacks = CurrencyConverter.getAsValidStacks(value);
        if (rawStacks.size() <= maxStacks) {
            stacks.addAll(rawStacks);
        } else {
            stacks.add(MoneyBagItem.create(value));
        }
        return stacks;
    }

    public static class_1799 getClosest(long value) {
        long[] values = CurrencyResolver.splitValues(value);
        for (int i = 0; i < 2 && values[i + 1] != 0L; ++i) {
            int n = i + 1;
            values[n] = values[n] + (long)Math.round((float)values[i] / 100.0f);
            values[i] = 0L;
        }
        return CurrencyConverter.getAsItemStackList(CurrencyResolver.combineValues(values)).get(0);
    }

    public static long[] getFromNbt(class_2487 nbt, String key) {
        if (nbt.method_10573(key, 12)) {
            return (long[])nbt.method_10565(key).clone();
        }
        if (!nbt.method_10573(key, 11)) {
            return new long[0];
        }
        int[] intArray = nbt.method_10561(key);
        long[] longArray = new long[intArray.length];
        for (int i = 0; i < intArray.length; ++i) {
            longArray[i] = intArray[i];
        }
        return longArray;
    }

    private static boolean isCombined(class_1799 stack) {
        return stack.method_7985() && stack.method_7969().method_10573("Combined", 1);
    }
}

