/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.numismaticoverhaul.item;

import com.glisco.numismaticoverhaul.ModComponents;
import com.glisco.numismaticoverhaul.currency.CurrencyComponent;
import com.glisco.numismaticoverhaul.currency.CurrencyConverter;
import com.glisco.numismaticoverhaul.currency.CurrencyHelper;
import com.glisco.numismaticoverhaul.currency.CurrencyResolver;
import com.glisco.numismaticoverhaul.item.CoinItem;
import com.glisco.numismaticoverhaul.item.CurrencyItem;
import com.glisco.numismaticoverhaul.item.CurrencyTooltipData;
import com.glisco.numismaticoverhaul.item.NumismaticOverhaulItems;
import io.wispforest.owo.nbt.NbtKey;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1727;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_5632;

public class MoneyBagItem
extends class_1792
implements CurrencyItem {
    private static final NbtKey<Long> VALUE = new NbtKey("Value", NbtKey.Type.LONG);
    private static final NbtKey<long[]> VALUES = new NbtKey("Values", NbtKey.Type.LONG_ARRAY);
    private static final NbtKey<Boolean> COMBINED = new NbtKey("Combined", NbtKey.Type.BOOLEAN);

    public MoneyBagItem() {
        super(new class_1792.class_1793().method_7889(1));
    }

    public class_1799 method_7854() {
        class_1799 defaultStack = super.method_7854();
        defaultStack.put(VALUE, (Object)0L);
        return defaultStack;
    }

    public static class_1799 create(long value) {
        class_1799 stack = new class_1799((class_1935)NumismaticOverhaulItems.MONEY_BAG);
        stack.put(VALUE, (Object)value);
        return stack;
    }

    public static class_1799 createCombined(long[] values) {
        class_1799 stack = new class_1799((class_1935)NumismaticOverhaulItems.MONEY_BAG);
        stack.put(VALUES, (Object)values);
        stack.put(COMBINED, (Object)true);
        return stack;
    }

    @Override
    public long getValue(class_1799 stack) {
        if (stack.method_7909() != NumismaticOverhaulItems.MONEY_BAG) {
            return 0L;
        }
        if (!stack.has(COMBINED)) {
            return (Long)stack.get(VALUE);
        }
        return CurrencyResolver.combineValues(CurrencyHelper.getFromNbt(stack.method_7948(), "Values"));
    }

    @Override
    public long[] getCombinedValue(class_1799 stack) {
        if (!stack.has(COMBINED)) {
            return CurrencyResolver.splitValues((Long)stack.get(VALUE));
        }
        return CurrencyHelper.getFromNbt(stack.method_7948(), "Values");
    }

    public void setValue(class_1799 stack, long value) {
        stack.method_7948().method_10544("Value", value);
    }

    public void setCombinedValue(class_1799 stack, long[] values) {
        stack.method_7948().method_10564("Values", values);
    }

    public boolean method_31566(class_1799 clickedStack, class_1799 otherStack, class_1735 slot, class_5536 clickType, class_1657 player, class_5630 cursorStackReference) {
        if (slot instanceof class_1727) {
            return false;
        }
        if (clickType == class_5536.field_27014 && clickedStack.method_7909() == this && otherStack.method_7960()) {
            boolean canBeCompacted;
            List<class_1799> stackRepresentation = CurrencyConverter.getAsValidStacks(this.getCombinedValue(clickedStack));
            if (stackRepresentation.isEmpty()) {
                return false;
            }
            class_1799 coinStack = stackRepresentation.get(0);
            cursorStackReference.method_32332(coinStack);
            long[] values = this.getCombinedValue(clickedStack);
            int n = ((CoinItem)coinStack.method_7909()).currency.ordinal();
            values[n] = values[n] - (long)coinStack.method_7947();
            long newValue = CurrencyResolver.combineValues(values);
            boolean bl = canBeCompacted = values[0] < 100L && values[1] < 100L && values[2] < 100L;
            if (newValue == 0L) {
                slot.method_7673(class_1799.field_8037);
            } else if (canBeCompacted && CurrencyConverter.getAsValidStacks(newValue).size() == 1) {
                slot.method_7673(CurrencyConverter.getAsValidStacks(newValue).get(0));
            } else {
                this.setCombinedValue(clickedStack, values);
            }
        } else if (clickType == class_5536.field_27013) {
            class_1792 coinStack = otherStack.method_7909();
            if (!(coinStack instanceof CurrencyItem)) {
                return false;
            }
            CurrencyItem currencyItem = (CurrencyItem)coinStack;
            long[] clickedValues = this.getCombinedValue(clickedStack);
            long[] otherValues = currencyItem.getCombinedValue(otherStack);
            for (int i = 0; i < clickedValues.length; ++i) {
                int n = i;
                clickedValues[n] = clickedValues[n] + otherValues[i];
            }
            class_1799 stack = MoneyBagItem.createCombined(clickedValues);
            if (!slot.method_7680(stack)) {
                return false;
            }
            slot.method_7673(stack);
            cursorStackReference.method_32332(class_1799.field_8037);
        }
        return true;
    }

    public Optional<class_5632> method_32346(class_1799 stack) {
        long[] lArray;
        long[] lArray2 = this.getCombinedValue(stack);
        if (CurrencyItem.hasOriginalValue(stack)) {
            lArray = CurrencyResolver.splitValues(CurrencyItem.getOriginalValue(stack));
        } else {
            long[] lArray3 = new long[1];
            lArray = lArray3;
            lArray3[0] = -1L;
        }
        return Optional.of(new CurrencyTooltipData(lArray2, lArray));
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        if (((Boolean)stack.get(COMBINED)).booleanValue()) {
            return;
        }
        if (!(entity instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)entity;
        player.method_31548().method_7378(stack);
        for (class_1799 toOffer : CurrencyConverter.getAsValidStacks(this.getValue(stack))) {
            player.method_31548().method_7398(toOffer);
        }
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        ((CurrencyComponent)ModComponents.CURRENCY.get((Object)user)).modify(this.getValue(user.method_5998(hand)));
        user.method_6122(hand, class_1799.field_8037);
        return class_1271.method_22427((Object)class_1799.field_8037);
    }

    @Override
    public boolean wasAdjusted(class_1799 other) {
        return true;
    }

    public class_2561 method_7848() {
        return super.method_7848().method_27661().method_10862(NumismaticOverhaulItems.SILVER_COIN.NAME_STYLE);
    }
}

