/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.config.ui;

import io.wispforest.owo.config.Option;
import io.wispforest.owo.config.annotation.RangeConstraint;
import io.wispforest.owo.config.ui.OptionComponents;
import io.wispforest.owo.config.ui.component.ListOptionContainer;
import io.wispforest.owo.config.ui.component.OptionComponent;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.parsing.UIModel;
import io.wispforest.owo.util.NumberReflection;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.class_2960;

public interface OptionComponentFactory<T> {
    public static final OptionComponentFactory<? extends Number> NUMBER = (model, option) -> {
        Field field = option.backingField().field();
        boolean floatingPoint = NumberReflection.isFloatingPointType(field.getType());
        if (field.isAnnotationPresent(RangeConstraint.class)) {
            return OptionComponents.createSlider(model, option, floatingPoint);
        }
        return OptionComponents.createTextBox(model, option, configTextBox -> configTextBox.configureForNumber(option.clazz()));
    };
    public static final OptionComponentFactory<? extends CharSequence> STRING = (model, option) -> OptionComponents.createTextBox(model, option, configTextBox -> {
        if (option.constraint() != null) {
            configTextBox.applyPredicate(option.constraint()::test);
        }
    });
    public static final OptionComponentFactory<class_2960> IDENTIFIER = (model, option) -> OptionComponents.createTextBox(model, option, configTextBox -> {
        configTextBox.inputPredicate(s -> s.matches("[a-z0-9_.:\\-]*"));
        configTextBox.applyPredicate(s -> class_2960.method_12829((String)s) != null);
        configTextBox.valueParser(class_2960::new);
    });
    public static final OptionComponentFactory<Boolean> BOOLEAN = OptionComponents::createToggleButton;
    public static final OptionComponentFactory<? extends Enum<?>> ENUM = OptionComponents::createEnumButton;
    public static final OptionComponentFactory<List<?>> LIST = (model, option) -> {
        ListOptionContainer layout = new ListOptionContainer(option);
        return new Result(layout, layout);
    };

    public Result make(UIModel var1, Option<T> var2);

    public record Result(Component baseComponent, OptionComponent optionContainer) {
    }
}

