/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.mixin;

import io.wispforest.owo.client.screens.OwoScreenHandler;
import io.wispforest.owo.client.screens.ScreenInternals;
import io.wispforest.owo.client.screens.ScreenhandlerMessageData;
import io.wispforest.owo.client.screens.SyncedProperty;
import io.wispforest.owo.network.NetworkException;
import io.wispforest.owo.network.serialization.PacketBufSerializer;
import io.wispforest.owo.util.pond.OwoScreenHandlerExtension;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1703.class})
public abstract class ScreenHandlerMixin
implements OwoScreenHandler,
OwoScreenHandlerExtension {
    @Shadow
    private boolean field_29209;
    private final List<SyncedProperty<?>> owo$properties = new ArrayList();
    private final Map<Class<?>, ScreenhandlerMessageData<?>> owo$messages = new LinkedHashMap();
    private final List<ScreenhandlerMessageData<?>> owo$clientboundMessages = new ArrayList();
    private final List<ScreenhandlerMessageData<?>> owo$serverboundMessages = new ArrayList();
    private class_1657 owo$player = null;

    @Override
    public void owo$attachToPlayer(class_1657 player) {
        this.owo$player = player;
    }

    @Override
    public class_1657 player() {
        return this.owo$player;
    }

    @Override
    public <R extends Record> void addServerboundMessage(Class<R> messageClass, Consumer<R> handler) {
        int id = this.owo$serverboundMessages.size();
        ScreenhandlerMessageData<R> messageData = new ScreenhandlerMessageData<R>(id, false, PacketBufSerializer.get(messageClass), handler);
        this.owo$serverboundMessages.add(messageData);
        if (this.owo$messages.put(messageClass, messageData) != null) {
            throw new NetworkException(messageClass + " is already registered as a message!");
        }
    }

    @Override
    public <R extends Record> void addClientboundMessage(Class<R> messageClass, Consumer<R> handler) {
        int id = this.owo$clientboundMessages.size();
        ScreenhandlerMessageData<R> messageData = new ScreenhandlerMessageData<R>(id, true, PacketBufSerializer.get(messageClass), handler);
        this.owo$clientboundMessages.add(messageData);
        if (this.owo$messages.put(messageClass, messageData) != null) {
            throw new NetworkException(messageClass + " is already registered as a message!");
        }
    }

    @Override
    public <R extends Record> void sendMessage(@NotNull R message) {
        if (this.owo$player == null) {
            throw new NetworkException("Tried to send a message before player was attached");
        }
        ScreenhandlerMessageData<?> messageData = this.owo$messages.get(message.getClass());
        if (messageData == null) {
            throw new NetworkException("Tried to send message of unknown type " + message.getClass());
        }
        class_2540 buf = PacketByteBufs.create();
        buf.method_10804(messageData.id());
        messageData.serializer().serializer().accept((Object)buf, message);
        if (messageData.clientbound()) {
            class_1657 class_16572 = this.owo$player;
            if (!(class_16572 instanceof class_3222)) {
                throw new NetworkException("Tried to send clientbound message on the server");
            }
            class_3222 serverPlayer = (class_3222)class_16572;
            ServerPlayNetworking.send((class_3222)serverPlayer, (class_2960)ScreenInternals.LOCAL_PACKET, (class_2540)buf);
        } else {
            if (!this.owo$player.field_6002.field_9236) {
                throw new NetworkException("Tried to send serverbound message on the client");
            }
            this.owo$sendToServer(ScreenInternals.LOCAL_PACKET, buf);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private void owo$sendToServer(class_2960 channel, class_2540 data) {
        ClientPlayNetworking.send((class_2960)channel, (class_2540)data);
    }

    @Override
    public void owo$handlePacket(class_2540 buf, boolean clientbound, Executor executor) {
        int id = buf.method_10816();
        ScreenhandlerMessageData<?> messageData = (clientbound ? this.owo$clientboundMessages : this.owo$serverboundMessages).get(id);
        Object message = messageData.serializer().deserializer().apply((Object)buf);
        executor.execute(() -> messageData.handler().accept(message));
    }

    @Override
    public <T> SyncedProperty<T> createProperty(Class<T> klass, T initial) {
        SyncedProperty<T> prop = new SyncedProperty<T>(this.owo$properties.size(), klass, initial);
        this.owo$properties.add(prop);
        return prop;
    }

    @Override
    public void owo$readPropertySync(class_2540 buf) {
        int count = buf.method_10816();
        for (int i = 0; i < count; ++i) {
            int idx = buf.method_10816();
            this.owo$properties.get(idx).read(buf);
        }
    }

    @Inject(method={"syncState"}, at={@At(value="RETURN")})
    private void syncOnSyncState(CallbackInfo ci) {
        this.syncProperties();
    }

    @Inject(method={"sendContentUpdates"}, at={@At(value="RETURN")})
    private void syncOnSendContentUpdates(CallbackInfo ci) {
        if (this.field_29209) {
            return;
        }
        this.syncProperties();
    }

    private void syncProperties() {
        if (this.owo$player == null) {
            return;
        }
        class_1657 class_16572 = this.owo$player;
        if (!(class_16572 instanceof class_3222)) {
            return;
        }
        class_3222 player = (class_3222)class_16572;
        int count = 0;
        for (SyncedProperty<?> property : this.owo$properties) {
            if (!property.needsSync()) continue;
            ++count;
        }
        if (count == 0) {
            return;
        }
        class_2540 buf = PacketByteBufs.create();
        buf.method_10804(count);
        for (SyncedProperty<?> prop : this.owo$properties) {
            if (!prop.needsSync()) continue;
            buf.method_10804(prop.index());
            prop.write(buf);
        }
        ServerPlayNetworking.send((class_3222)player, (class_2960)ScreenInternals.SYNC_PROPERTIES, (class_2540)buf);
    }
}

