/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.container;

import io.wispforest.owo.ui.base.BaseParentComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.Size;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.parsing.UIModel;
import io.wispforest.owo.ui.parsing.UIParsing;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.class_4587;
import org.w3c.dom.Element;

public abstract class FlowLayout
extends BaseParentComponent {
    protected final List<Component> children = new ArrayList<Component>();
    protected final List<Component> childrenView = Collections.unmodifiableList(this.children);
    protected Size contentSize = Size.zero();
    protected int gap = 0;

    protected FlowLayout(Sizing horizontalSizing, Sizing verticalSizing) {
        super(horizontalSizing, verticalSizing);
    }

    @Override
    protected int determineHorizontalContentSize(Sizing sizing) {
        return this.contentSize.width() + ((Insets)this.padding.get()).horizontal();
    }

    @Override
    protected int determineVerticalContentSize(Sizing sizing) {
        return this.contentSize.height() + ((Insets)this.padding.get()).vertical();
    }

    public FlowLayout child(Component child) {
        this.children.add(child);
        this.updateLayout();
        return this;
    }

    public FlowLayout children(Collection<Component> children) {
        this.children.addAll(children);
        this.updateLayout();
        return this;
    }

    public FlowLayout child(int index, Component child) {
        this.children.add(index, child);
        this.updateLayout();
        return this;
    }

    public FlowLayout children(int index, Collection<Component> children) {
        this.children.addAll(index, children);
        this.updateLayout();
        return this;
    }

    @Override
    public FlowLayout removeChild(Component child) {
        if (this.children.remove(child)) {
            child.dismount(Component.DismountReason.REMOVED);
            this.updateLayout();
        }
        return this;
    }

    public FlowLayout clearChildren() {
        for (Component child : this.children) {
            child.dismount(Component.DismountReason.REMOVED);
        }
        this.children.clear();
        this.updateLayout();
        return this;
    }

    @Override
    public List<Component> children() {
        return this.childrenView;
    }

    public FlowLayout gap(int gap) {
        this.gap = gap;
        return this;
    }

    public int gap() {
        return this.gap;
    }

    @Override
    public void draw(class_4587 matrices, int mouseX, int mouseY, float partialTicks, float delta) {
        super.draw(matrices, mouseX, mouseY, partialTicks, delta);
        this.drawChildren(matrices, mouseX, mouseY, partialTicks, delta, this.children);
    }

    @Override
    public void parseProperties(UIModel model, Element element, Map<String, Element> children) {
        super.parseProperties(model, element, children);
        List components = UIParsing.get(children, "children", e -> UIParsing.allChildrenOfType(e, (short)1)).orElse(Collections.emptyList());
        for (Element child : components) {
            this.child(model.parseComponent(Component.class, child));
        }
    }

    public static FlowLayout parse(Element element) {
        UIParsing.expectAttributes(element, "direction");
        return element.getAttribute("direction").equals("vertical") ? Containers.verticalFlow(Sizing.content(), Sizing.content()) : Containers.horizontalFlow(Sizing.content(), Sizing.content());
    }
}

