/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.parsing;

import io.wispforest.owo.Owo;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.parsing.IncompatibleUIModelException;
import io.wispforest.owo.ui.parsing.UIModelParsingException;
import io.wispforest.owo.ui.parsing.UIParsing;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class UIModel {
    private static final Pattern PARAMETER_PATTERN = Pattern.compile("\\{\\{[-_a-zA-Z]+}}");
    private final Element componentsElement;
    private final Map<String, Element> templates;
    private final Deque<ExpansionFrame> expansionStack = new ArrayDeque<ExpansionFrame>();

    protected UIModel(Element componentsElement, Map<String, Element> templates) {
        this.componentsElement = componentsElement;
        this.templates = templates;
    }

    protected UIModel(Element docElement) {
        docElement.normalize();
        if (!docElement.getNodeName().equals("owo-ui")) {
            throw new UIModelParsingException("Missing 'owo-ui' root element");
        }
        Map<String, Element> children = UIParsing.childElements(docElement);
        if (!children.containsKey("components")) {
            throw new UIModelParsingException("Missing 'components' element in UI model");
        }
        List componentsList = UIParsing.allChildrenOfType(children.get("components"), (short)1);
        if (componentsList.size() != 1) {
            throw new UIModelParsingException("Invalid number of children in 'components' element - a single child must be declared");
        }
        this.componentsElement = (Element)componentsList.get(0);
        this.templates = UIParsing.get(children, "templates", UIParsing::childElements).orElse(Collections.emptyMap());
    }

    @Nullable
    public static UIModel load(Path path) {
        UIModel uIModel;
        block8: {
            InputStream in = Files.newInputStream(path, new OpenOption[0]);
            try {
                uIModel = UIModel.load(in);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception error) {
                    Owo.LOGGER.warn("Could not load UI model from file {}", (Object)path, (Object)error);
                    return null;
                }
            }
            in.close();
        }
        return uIModel;
    }

    public static UIModel load(InputStream stream) throws ParserConfigurationException, IOException, SAXException, UIModelParsingException {
        return new UIModel(DocumentBuilderFactory.newDefaultInstance().newDocumentBuilder().parse(stream).getDocumentElement());
    }

    public <T extends ParentComponent> OwoUIAdapter<T> createAdapter(Class<T> expectedRootComponentClass, class_437 screen) {
        return OwoUIAdapter.create(screen, (horizontalSizing, verticalSizing) -> this.parseComponentTree(expectedRootComponentClass));
    }

    public <T extends ParentComponent> OwoUIAdapter<T> createAdapterWithoutScreen(int x, int y, int width, int height, Class<T> expectedRootComponentClass) {
        return OwoUIAdapter.createWithoutScreen(x, y, width, height, (horizontalSizing, verticalSizing) -> this.parseComponentTree(expectedRootComponentClass));
    }

    public <T extends Component> T parseComponent(Class<T> expectedClass, Element componentElement) {
        if (componentElement.getNodeName().equals("template")) {
            String templateName = componentElement.getAttribute("name").strip();
            if (templateName.isEmpty()) {
                throw new UIModelParsingException("Template element is missing 'name' attribute");
            }
            HashMap<String, String> templateParams = new HashMap<String, String>();
            HashMap<String, Element> childParams = new HashMap<String, Element>();
            for (Element element : UIParsing.allChildrenOfType(componentElement, (short)1)) {
                if (element.getNodeName().equals("child")) {
                    childParams.put(element.getAttribute("id"), (Element)UIParsing.allChildrenOfType(element, (short)1).get(0));
                    continue;
                }
                templateParams.put(element.getNodeName(), element.getTextContent());
            }
            return this.expandTemplate(expectedClass, templateName, templateParams::get, childParams::get);
        }
        Component component = UIParsing.getFactory(componentElement).apply(componentElement);
        component.parseProperties(this, componentElement, UIParsing.childElements(componentElement));
        if (!expectedClass.isAssignableFrom(component.getClass())) {
            String idString = componentElement.hasAttribute("id") ? " with id '" + componentElement.getAttribute("id") + "'" : "";
            throw new IncompatibleUIModelException("Expected component '" + componentElement.getNodeName() + "'" + idString + " to be a " + expectedClass.getSimpleName() + ", but it is a " + component.getClass().getSimpleName());
        }
        return (T)component;
    }

    public <T extends Component> T expandTemplate(Class<T> expectedClass, String name, Function<String, String> parameterSupplier, Function<String, Element> childSupplier) {
        if (this.expansionStack.isEmpty()) {
            this.expansionStack.push(new ExpansionFrame(parameterSupplier, childSupplier));
        } else {
            ExpansionFrame currentFrame = this.expansionStack.peek();
            this.expansionStack.push(new ExpansionFrame(this.cascadeIfNull(currentFrame.parameterSupplier, parameterSupplier), this.cascadeIfNull(currentFrame.childSupplier, childSupplier)));
        }
        Element template = this.templates.get(name);
        if (template == null) {
            throw new UIModelParsingException("Unknown template '" + name + "'");
        }
        template = (Element)template.cloneNode(true);
        this.expandChildren(template);
        this.applySubstitutions(template);
        Component component = this.parseComponent(Component.class, (Element)UIParsing.allChildrenOfType(template, (short)1).get(0));
        if (!expectedClass.isAssignableFrom(component.getClass())) {
            throw new IncompatibleUIModelException("Expected template '" + name + "' to expand into a " + expectedClass.getSimpleName() + ", but it expanded into a " + component.getClass().getSimpleName());
        }
        this.expansionStack.pop();
        return (T)component;
    }

    public <T extends Component> T expandTemplate(Class<T> expectedClass, String name, Map<String, String> parameters) {
        return this.expandTemplate(expectedClass, name, parameters::get, s -> null);
    }

    protected <T extends ParentComponent> T parseComponentTree(Class<T> expectedRootComponentClass) {
        ParentComponent documentComponent = (ParentComponent)this.parseComponent(expectedRootComponentClass, this.componentsElement);
        documentComponent.sizing(Sizing.fill(100), Sizing.fill(100));
        return (T)documentComponent;
    }

    protected void applySubstitutions(Element template) {
        Function<String, String> parameterSupplier = this.expansionStack.peek().parameterSupplier;
        Function<MatchResult, String> replacer = matchResult -> {
            String paramName = matchResult.group().substring(2, matchResult.group().length() - 2);
            String substitution = (String)parameterSupplier.apply(paramName);
            if (substitution == null) {
                throw new IncompatibleUIModelException("No substitution provided for template parameter '" + paramName + "'");
            }
            return Matcher.quoteReplacement(substitution);
        };
        for (Element child : UIParsing.allChildrenOfType(template, (short)1)) {
            for (Text node : UIParsing.allChildrenOfType(child, (short)3)) {
                String textContent = node.getTextContent();
                node.setTextContent(PARAMETER_PATTERN.matcher(textContent).replaceAll(replacer));
            }
            for (int i = 0; i < child.getAttributes().getLength(); ++i) {
                Attr attr = (Attr)child.getAttributes().item(i);
                attr.setValue(PARAMETER_PATTERN.matcher(attr.getValue()).replaceAll(replacer));
            }
            this.applySubstitutions(child);
        }
    }

    protected void expandChildren(Element template) {
        Function<String, Element> childSupplier = this.expansionStack.peek().childSupplier;
        for (Element child : UIParsing.allChildrenOfType(template, (short)1)) {
            if (child.getNodeName().equals("template-child")) {
                String childId = child.getAttribute("id");
                Element expanded = childSupplier.apply(childId);
                if (expanded != null) {
                    expanded = (Element)expanded.cloneNode(true);
                    Map<String, Element> expandedChildren = UIParsing.childElements(expanded);
                    for (Element element : UIParsing.allChildrenOfType(child, (short)1)) {
                        if (expandedChildren.containsKey(element.getTagName())) continue;
                        expanded.appendChild(element);
                    }
                    template.replaceChild(expanded, child);
                } else {
                    throw new IncompatibleUIModelException("No expansion provided for template child '" + childId + "'");
                }
            }
            this.expandChildren(child);
        }
    }

    protected <T, S> Function<T, S> cascadeIfNull(Function<T, S> first, Function<T, S> second) {
        return t -> {
            Object firstValue = first.apply(t);
            return firstValue == null ? second.apply(t) : firstValue;
        };
    }

    private record ExpansionFrame(Function<String, String> parameterSupplier, Function<String, Element> childSupplier) {
    }
}

