/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.util;

import com.mojang.blaze3d.systems.RenderSystem;
import io.wispforest.owo.ui.core.PositionedRectangle;
import io.wispforest.owo.ui.core.Size;
import io.wispforest.owo.ui.util.Drawer;
import net.minecraft.class_2960;
import net.minecraft.class_4587;

public class NinePatchRenderer {
    private final class_2960 texture;
    private final int u;
    private final int v;
    private final Size cornerPatchSize;
    private final Size centerPatchSize;
    private final Size textureSize;
    private final boolean repeat;

    public NinePatchRenderer(class_2960 texture, int u, int v, Size cornerPatchSize, Size centerPatchSize, Size textureSize, boolean repeat) {
        this.texture = texture;
        this.u = u;
        this.v = v;
        this.textureSize = textureSize;
        this.cornerPatchSize = cornerPatchSize;
        this.centerPatchSize = centerPatchSize;
        this.repeat = repeat;
    }

    public NinePatchRenderer(class_2960 texture, int u, int v, Size patchSize, Size textureSize, boolean repeat) {
        this(texture, u, v, patchSize, patchSize, textureSize, repeat);
    }

    public NinePatchRenderer(class_2960 texture, Size patchSize, Size textureSize, boolean repeat) {
        this(texture, 0, 0, patchSize, textureSize, repeat);
    }

    public void draw(class_4587 matrices, PositionedRectangle rectangle) {
        this.draw(matrices, rectangle.x(), rectangle.y(), rectangle.width(), rectangle.height());
    }

    public void draw(class_4587 matrices, int x, int y, int width, int height) {
        Drawer.recordQuads();
        RenderSystem.setShaderTexture((int)0, (class_2960)this.texture);
        int rightEdge = this.cornerPatchSize.width() + this.centerPatchSize.width();
        int bottomEdge = this.cornerPatchSize.height() + this.centerPatchSize.height();
        Drawer.method_25290((class_4587)matrices, (int)x, (int)y, (float)this.u, (float)this.v, (int)this.cornerPatchSize.width(), (int)this.cornerPatchSize.height(), (int)this.textureSize.width(), (int)this.textureSize.height());
        Drawer.method_25290((class_4587)matrices, (int)(x + width - this.cornerPatchSize.width()), (int)y, (float)(this.u + rightEdge), (float)this.v, (int)this.cornerPatchSize.width(), (int)this.cornerPatchSize.height(), (int)this.textureSize.width(), (int)this.textureSize.height());
        Drawer.method_25290((class_4587)matrices, (int)x, (int)(y + height - this.cornerPatchSize.height()), (float)this.u, (float)(this.v + bottomEdge), (int)this.cornerPatchSize.width(), (int)this.cornerPatchSize.height(), (int)this.textureSize.width(), (int)this.textureSize.height());
        Drawer.method_25290((class_4587)matrices, (int)(x + width - this.cornerPatchSize.width()), (int)(y + height - this.cornerPatchSize.height()), (float)(this.u + rightEdge), (float)(this.v + bottomEdge), (int)this.cornerPatchSize.width(), (int)this.cornerPatchSize.height(), (int)this.textureSize.width(), (int)this.textureSize.height());
        if (this.repeat) {
            this.drawRepeated(matrices, x, y, width, height);
        } else {
            this.drawStretched(matrices, x, y, width, height);
        }
        Drawer.submitQuads();
    }

    protected void drawStretched(class_4587 matrices, int x, int y, int width, int height) {
        int doubleCornerHeight = this.cornerPatchSize.height() * 2;
        int doubleCornerWidth = this.cornerPatchSize.width() * 2;
        int rightEdge = this.cornerPatchSize.width() + this.centerPatchSize.width();
        int bottomEdge = this.cornerPatchSize.height() + this.centerPatchSize.height();
        if (width > doubleCornerWidth && height > doubleCornerHeight) {
            Drawer.method_25293((class_4587)matrices, (int)(x + this.cornerPatchSize.width()), (int)(y + this.cornerPatchSize.height()), (int)(width - doubleCornerWidth), (int)(height - doubleCornerHeight), (float)(this.u + this.cornerPatchSize.width()), (float)(this.v + this.cornerPatchSize.height()), (int)this.centerPatchSize.width(), (int)this.centerPatchSize.height(), (int)this.textureSize.width(), (int)this.textureSize.height());
        }
        if (width > doubleCornerWidth) {
            Drawer.method_25293((class_4587)matrices, (int)(x + this.cornerPatchSize.width()), (int)y, (int)(width - doubleCornerWidth), (int)this.cornerPatchSize.height(), (float)(this.u + this.cornerPatchSize.width()), (float)this.v, (int)this.centerPatchSize.width(), (int)this.cornerPatchSize.height(), (int)this.textureSize.width(), (int)this.textureSize.height());
            Drawer.method_25293((class_4587)matrices, (int)(x + this.cornerPatchSize.width()), (int)(y + height - this.cornerPatchSize.height()), (int)(width - doubleCornerWidth), (int)this.cornerPatchSize.height(), (float)(this.u + this.cornerPatchSize.width()), (float)(this.v + bottomEdge), (int)this.centerPatchSize.width(), (int)this.cornerPatchSize.height(), (int)this.textureSize.width(), (int)this.textureSize.height());
        }
        if (height > doubleCornerHeight) {
            Drawer.method_25293((class_4587)matrices, (int)x, (int)(y + this.cornerPatchSize.height()), (int)this.cornerPatchSize.width(), (int)(height - doubleCornerHeight), (float)this.u, (float)(this.v + this.cornerPatchSize.height()), (int)this.cornerPatchSize.width(), (int)this.centerPatchSize.height(), (int)this.textureSize.width(), (int)this.textureSize.height());
            Drawer.method_25293((class_4587)matrices, (int)(x + width - this.cornerPatchSize.width()), (int)(y + this.cornerPatchSize.height()), (int)this.cornerPatchSize.width(), (int)(height - doubleCornerHeight), (float)(this.u + rightEdge), (float)(this.v + this.cornerPatchSize.height()), (int)this.cornerPatchSize.width(), (int)this.centerPatchSize.height(), (int)this.textureSize.width(), (int)this.textureSize.height());
        }
    }

    protected void drawRepeated(class_4587 matrices, int x, int y, int width, int height) {
        int drawHeight;
        int leftoverHeight;
        int doubleCornerHeight = this.cornerPatchSize.height() * 2;
        int doubleCornerWidth = this.cornerPatchSize.width() * 2;
        int rightEdge = this.cornerPatchSize.width() + this.centerPatchSize.width();
        int bottomEdge = this.cornerPatchSize.height() + this.centerPatchSize.height();
        if (width > doubleCornerWidth && height > doubleCornerHeight) {
            for (leftoverHeight = height - doubleCornerHeight; leftoverHeight > 0; leftoverHeight -= this.centerPatchSize.height()) {
                drawHeight = Math.min(this.centerPatchSize.height(), leftoverHeight);
                for (int leftoverWidth = width - doubleCornerWidth; leftoverWidth > 0; leftoverWidth -= this.centerPatchSize.width()) {
                    int drawWidth = Math.min(this.centerPatchSize.width(), leftoverWidth);
                    Drawer.method_25293((class_4587)matrices, (int)(x + this.cornerPatchSize.width() + leftoverWidth - drawWidth), (int)(y + this.cornerPatchSize.height() + leftoverHeight - drawHeight), (int)drawWidth, (int)drawHeight, (float)(this.u + this.cornerPatchSize.width() + this.centerPatchSize.width() - drawWidth), (float)(this.v + this.cornerPatchSize.height() + this.centerPatchSize.height() - drawHeight), (int)drawWidth, (int)drawHeight, (int)this.textureSize.width(), (int)this.textureSize.height());
                }
            }
        }
        if (width > doubleCornerWidth) {
            for (int leftoverWidth = width - doubleCornerWidth; leftoverWidth > 0; leftoverWidth -= this.centerPatchSize.width()) {
                int drawWidth = Math.min(this.centerPatchSize.width(), leftoverWidth);
                Drawer.method_25293((class_4587)matrices, (int)(x + this.cornerPatchSize.width() + leftoverWidth - drawWidth), (int)y, (int)drawWidth, (int)this.cornerPatchSize.height(), (float)(this.u + this.cornerPatchSize.width() + this.centerPatchSize.width() - drawWidth), (float)this.v, (int)drawWidth, (int)this.cornerPatchSize.height(), (int)this.textureSize.width(), (int)this.textureSize.height());
                Drawer.method_25293((class_4587)matrices, (int)(x + this.cornerPatchSize.width() + leftoverWidth - drawWidth), (int)(y + height - this.cornerPatchSize.height()), (int)drawWidth, (int)this.cornerPatchSize.height(), (float)(this.u + this.cornerPatchSize.width() + this.centerPatchSize.width() - drawWidth), (float)(this.v + bottomEdge), (int)drawWidth, (int)this.cornerPatchSize.height(), (int)this.textureSize.width(), (int)this.textureSize.height());
            }
        }
        if (height > doubleCornerHeight) {
            for (leftoverHeight = height - doubleCornerHeight; leftoverHeight > 0; leftoverHeight -= this.centerPatchSize.height()) {
                drawHeight = Math.min(this.centerPatchSize.height(), leftoverHeight);
                Drawer.method_25293((class_4587)matrices, (int)x, (int)(y + this.cornerPatchSize.height() + leftoverHeight - drawHeight), (int)this.cornerPatchSize.width(), (int)drawHeight, (float)this.u, (float)(this.v + this.cornerPatchSize.height() + this.centerPatchSize.height() - drawHeight), (int)this.cornerPatchSize.width(), (int)drawHeight, (int)this.textureSize.width(), (int)this.textureSize.height());
                Drawer.method_25293((class_4587)matrices, (int)(x + width - this.cornerPatchSize.width()), (int)(y + this.cornerPatchSize.height() + leftoverHeight - drawHeight), (int)this.cornerPatchSize.width(), (int)drawHeight, (float)(this.u + rightEdge), (float)(this.v + this.cornerPatchSize.height() + this.centerPatchSize.height() - drawHeight), (int)this.cornerPatchSize.width(), (int)drawHeight, (int)this.textureSize.width(), (int)this.textureSize.height());
            }
        }
    }
}

