/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralium.common.configuration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraftforge.common.ForgeConfigSpec;
import org.jetbrains.annotations.NotNull;
import site.siredvin.peripheralium.api.IConfigHandler;
import site.siredvin.peripheralium.common.configuration.ConfigHolder;
import site.siredvin.peripheralium.computercraft.peripheral.operation.UnconditionalOperations;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\t\b\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0005\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004R\u0011\u0010\t\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u000b\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0004R\u0011\u0010\r\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0010\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\bR\u0011\u0010\u0012\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0004\u00a8\u0006\u0016"}, d2={"Lsite/siredvin/peripheralium/common/configuration/PeripheraliumConfig;", "", "", "getCooldownTrasholdLevel", "()I", "cooldownTrasholdLevel", "", "getFluidStorageTransferLimit", "()J", "fluidStorageTransferLimit", "getInitialCooldownSensetiveLevel", "initialCooldownSensetiveLevel", "", "isInitialCooldownEnabled", "()Z", "getItemStorageTransferLimit", "itemStorageTransferLimit", "getXpToFuelRate", "xpToFuelRate", "<init>", "()V", "CommonConfig", "peripheralium-fabric-1.19.2"})
public final class PeripheraliumConfig {
    @NotNull
    public static final PeripheraliumConfig INSTANCE = new PeripheraliumConfig();

    private PeripheraliumConfig() {
    }

    public final boolean isInitialCooldownEnabled() {
        Object object = ConfigHolder.INSTANCE.getCOMMON_CONFIG().getIS_INITIAL_COOLDOWN_ENABLED().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ConfigHolder.COMMON_CONF\u2026AL_COOLDOWN_ENABLED.get()");
        return (Boolean)object;
    }

    public final int getInitialCooldownSensetiveLevel() {
        Object object = ConfigHolder.INSTANCE.getCOMMON_CONFIG().getINITIAL_COOLDOWN_SENSENTIVE_LEVEL().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ConfigHolder.COMMON_CONF\u2026WN_SENSENTIVE_LEVEL.get()");
        return ((Number)object).intValue();
    }

    public final int getCooldownTrasholdLevel() {
        Object object = ConfigHolder.INSTANCE.getCOMMON_CONFIG().getCOOLDOWN_TRASHOLD_LEVEL().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ConfigHolder.COMMON_CONF\u2026DOWN_TRASHOLD_LEVEL.get()");
        return ((Number)object).intValue();
    }

    public final int getXpToFuelRate() {
        Object object = ConfigHolder.INSTANCE.getCOMMON_CONFIG().getXP_TO_FUEL_RATE().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ConfigHolder.COMMON_CONFIG.XP_TO_FUEL_RATE.get()");
        return ((Number)object).intValue();
    }

    public final long getItemStorageTransferLimit() {
        Object object = ConfigHolder.INSTANCE.getCOMMON_CONFIG().getITEM_STORAGE_TRANSFER_LIMIT().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ConfigHolder.COMMON_CONF\u2026RAGE_TRANSFER_LIMIT.get()");
        return ((Number)object).longValue();
    }

    public final long getFluidStorageTransferLimit() {
        Object object = ConfigHolder.INSTANCE.getCOMMON_CONFIG().getFLUID_STORAGE_TRANSFER_LIMIT().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ConfigHolder.COMMON_CONF\u2026RAGE_TRANSFER_LIMIT.get()");
        return ((Number)object).longValue();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u0001B\u0011\b\u0000\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b%\u0010&J'\u0010\b\u001a\u00020\u00072\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u00022\u0006\u0010\u0006\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\b\u0010\tR\"\u0010\u000b\u001a\u00020\n8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0012\u001a\u00020\u00118\u0006\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R\"\u0010\u0016\u001a\u00020\n8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0016\u0010\f\u001a\u0004\b\u0017\u0010\u000e\"\u0004\b\u0018\u0010\u0010R\"\u0010\u001a\u001a\u00020\u00198\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0017\u0010 \u001a\u00020\u00118\u0006\u00a2\u0006\f\n\u0004\b \u0010\u0013\u001a\u0004\b!\u0010\u0015R\"\u0010\"\u001a\u00020\n8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\"\u0010\f\u001a\u0004\b#\u0010\u000e\"\u0004\b$\u0010\u0010\u00a8\u0006'"}, d2={"Lsite/siredvin/peripheralium/common/configuration/PeripheraliumConfig$CommonConfig;", "", "", "Lsite/siredvin/peripheralium/api/IConfigHandler;", "data", "Lnet/minecraftforge/common/ForgeConfigSpec$Builder;", "builder", "", "register", "([Lsite/siredvin/peripheralium/api/IConfigHandler;Lnet/minecraftforge/common/ForgeConfigSpec$Builder;)V", "Lnet/minecraftforge/common/ForgeConfigSpec$IntValue;", "COOLDOWN_TRASHOLD_LEVEL", "Lnet/minecraftforge/common/ForgeConfigSpec$IntValue;", "getCOOLDOWN_TRASHOLD_LEVEL", "()Lnet/minecraftforge/common/ForgeConfigSpec$IntValue;", "setCOOLDOWN_TRASHOLD_LEVEL", "(Lnet/minecraftforge/common/ForgeConfigSpec$IntValue;)V", "Lnet/minecraftforge/common/ForgeConfigSpec$LongValue;", "FLUID_STORAGE_TRANSFER_LIMIT", "Lnet/minecraftforge/common/ForgeConfigSpec$LongValue;", "getFLUID_STORAGE_TRANSFER_LIMIT", "()Lnet/minecraftforge/common/ForgeConfigSpec$LongValue;", "INITIAL_COOLDOWN_SENSENTIVE_LEVEL", "getINITIAL_COOLDOWN_SENSENTIVE_LEVEL", "setINITIAL_COOLDOWN_SENSENTIVE_LEVEL", "Lnet/minecraftforge/common/ForgeConfigSpec$BooleanValue;", "IS_INITIAL_COOLDOWN_ENABLED", "Lnet/minecraftforge/common/ForgeConfigSpec$BooleanValue;", "getIS_INITIAL_COOLDOWN_ENABLED", "()Lnet/minecraftforge/common/ForgeConfigSpec$BooleanValue;", "setIS_INITIAL_COOLDOWN_ENABLED", "(Lnet/minecraftforge/common/ForgeConfigSpec$BooleanValue;)V", "ITEM_STORAGE_TRANSFER_LIMIT", "getITEM_STORAGE_TRANSFER_LIMIT", "XP_TO_FUEL_RATE", "getXP_TO_FUEL_RATE", "setXP_TO_FUEL_RATE", "<init>", "(Lnet/minecraftforge/common/ForgeConfigSpec$Builder;)V", "peripheralium-fabric-1.19.2"})
    public static final class CommonConfig {
        @NotNull
        private ForgeConfigSpec.BooleanValue IS_INITIAL_COOLDOWN_ENABLED;
        @NotNull
        private ForgeConfigSpec.IntValue INITIAL_COOLDOWN_SENSENTIVE_LEVEL;
        @NotNull
        private ForgeConfigSpec.IntValue COOLDOWN_TRASHOLD_LEVEL;
        @NotNull
        private ForgeConfigSpec.IntValue XP_TO_FUEL_RATE;
        @NotNull
        private final ForgeConfigSpec.LongValue ITEM_STORAGE_TRANSFER_LIMIT;
        @NotNull
        private final ForgeConfigSpec.LongValue FLUID_STORAGE_TRANSFER_LIMIT;

        public CommonConfig(@NotNull ForgeConfigSpec.Builder builder) {
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            builder.push("limitations");
            ForgeConfigSpec.LongValue longValue = builder.comment("Limits max item transfer per one operation").defineInRange("itemStorageTransferLimit", 128L, 1L, Long.MAX_VALUE);
            Intrinsics.checkNotNullExpressionValue((Object)longValue, (String)"builder.comment(\"Limits \u2026128L, 1L, Long.MAX_VALUE)");
            this.ITEM_STORAGE_TRANSFER_LIMIT = longValue;
            ForgeConfigSpec.LongValue longValue2 = builder.comment("Limits max fluid transfer per one operation").defineInRange("fluidStorageTransferLimit", 5305500L, 1L, Long.MAX_VALUE);
            Intrinsics.checkNotNullExpressionValue((Object)longValue2, (String)"builder.comment(\"Limits \u2026500L, 1L, Long.MAX_VALUE)");
            this.FLUID_STORAGE_TRANSFER_LIMIT = longValue2;
            builder.pop();
            builder.push("cooldown");
            ForgeConfigSpec.BooleanValue booleanValue = builder.comment("Enables initial cooldown on peripheral initialization").define("isInitialCooldownEnabled", true);
            Intrinsics.checkNotNullExpressionValue((Object)booleanValue, (String)"builder.comment(\"Enables\u2026alCooldownEnabled\", true)");
            this.IS_INITIAL_COOLDOWN_ENABLED = booleanValue;
            ForgeConfigSpec.IntValue intValue = builder.comment("Determinates initial cooldown sensentive level, values lower then this value will not trigger initial cooldown").defineInRange("initialCooldownSensetiveLevel", 6000, 0, Integer.MAX_VALUE);
            Intrinsics.checkNotNullExpressionValue((Object)intValue, (String)"builder.comment(\"Determi\u2026, 6000, 0, Int.MAX_VALUE)");
            this.INITIAL_COOLDOWN_SENSENTIVE_LEVEL = intValue;
            ForgeConfigSpec.IntValue intValue2 = builder.comment("Determinates trashold for cooldown to be stored").defineInRange("cooldownTrashholdLevel", 100, 0, Integer.MAX_VALUE);
            Intrinsics.checkNotNullExpressionValue((Object)intValue2, (String)"builder.comment(\"Determi\u2026\", 100, 0, Int.MAX_VALUE)");
            this.COOLDOWN_TRASHOLD_LEVEL = intValue2;
            builder.pop();
            builder.push("experience");
            ForgeConfigSpec.IntValue intValue3 = builder.comment("Determinates amount xp to correspond one fuel point").defineInRange("xpToFuelRate", 10, 1, Integer.MAX_VALUE);
            Intrinsics.checkNotNullExpressionValue((Object)intValue3, (String)"builder.comment(\"Determi\u2026e\", 10, 1, Int.MAX_VALUE)");
            this.XP_TO_FUEL_RATE = intValue3;
            builder.pop();
            builder.push("operations");
            this.register(UnconditionalOperations.values(), builder);
            builder.pop();
        }

        @NotNull
        public final ForgeConfigSpec.BooleanValue getIS_INITIAL_COOLDOWN_ENABLED() {
            return this.IS_INITIAL_COOLDOWN_ENABLED;
        }

        public final void setIS_INITIAL_COOLDOWN_ENABLED(@NotNull ForgeConfigSpec.BooleanValue booleanValue) {
            Intrinsics.checkNotNullParameter((Object)booleanValue, (String)"<set-?>");
            this.IS_INITIAL_COOLDOWN_ENABLED = booleanValue;
        }

        @NotNull
        public final ForgeConfigSpec.IntValue getINITIAL_COOLDOWN_SENSENTIVE_LEVEL() {
            return this.INITIAL_COOLDOWN_SENSENTIVE_LEVEL;
        }

        public final void setINITIAL_COOLDOWN_SENSENTIVE_LEVEL(@NotNull ForgeConfigSpec.IntValue intValue) {
            Intrinsics.checkNotNullParameter((Object)intValue, (String)"<set-?>");
            this.INITIAL_COOLDOWN_SENSENTIVE_LEVEL = intValue;
        }

        @NotNull
        public final ForgeConfigSpec.IntValue getCOOLDOWN_TRASHOLD_LEVEL() {
            return this.COOLDOWN_TRASHOLD_LEVEL;
        }

        public final void setCOOLDOWN_TRASHOLD_LEVEL(@NotNull ForgeConfigSpec.IntValue intValue) {
            Intrinsics.checkNotNullParameter((Object)intValue, (String)"<set-?>");
            this.COOLDOWN_TRASHOLD_LEVEL = intValue;
        }

        @NotNull
        public final ForgeConfigSpec.IntValue getXP_TO_FUEL_RATE() {
            return this.XP_TO_FUEL_RATE;
        }

        public final void setXP_TO_FUEL_RATE(@NotNull ForgeConfigSpec.IntValue intValue) {
            Intrinsics.checkNotNullParameter((Object)intValue, (String)"<set-?>");
            this.XP_TO_FUEL_RATE = intValue;
        }

        @NotNull
        public final ForgeConfigSpec.LongValue getITEM_STORAGE_TRANSFER_LIMIT() {
            return this.ITEM_STORAGE_TRANSFER_LIMIT;
        }

        @NotNull
        public final ForgeConfigSpec.LongValue getFLUID_STORAGE_TRANSFER_LIMIT() {
            return this.FLUID_STORAGE_TRANSFER_LIMIT;
        }

        private final void register(IConfigHandler[] data, ForgeConfigSpec.Builder builder) {
            for (IConfigHandler handler : data) {
                handler.addToConfig(builder);
            }
        }
    }
}

