/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralium.extra.plugins;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.peripheral.generic.data.ItemData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.peripheralium.api.peripheral.IPeripheralOperation;
import site.siredvin.peripheralium.api.peripheral.IPeripheralPlugin;
import site.siredvin.peripheralium.api.peripheral.IPluggablePeripheral;
import site.siredvin.peripheralium.common.ExtractorProxy;
import site.siredvin.peripheralium.common.configuration.PeripheraliumConfig;
import site.siredvin.peripheralium.computercraft.peripheral.BoundMethod;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 &2\u00020\u0001:\u0001&B\u001d\u0012\u0006\u0010\u001e\u001a\u00020\u001d\u0012\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020!0 \u00a2\u0006\u0004\b$\u0010%J\u001a\u0010\u0005\u001a\u00020\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002H\u0096\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u001f\u0010\r\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\f\u0012\u0002\b\u00030\u000b0\nH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ;\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u0012H\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0017J;\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u0012H\u0007\u00a2\u0006\u0004\b\u0019\u0010\u0017R\u0014\u0010\u001c\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001e\u001a\u00020\u001d8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020!0 8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010#\u00a8\u0006'"}, d2={"Lsite/siredvin/peripheralium/extra/plugins/ItemStoragePlugin;", "Lsite/siredvin/peripheralium/api/peripheral/IPeripheralPlugin;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "", "", "items", "()Ljava/util/List;", "Ldan200/computercraft/api/peripheral/IComputerAccess;", "computer", "fromName", "Ljava/util/Optional;", "itemName", "", "limit", "pullItem", "(Ldan200/computercraft/api/peripheral/IComputerAccess;Ljava/lang/String;Ljava/util/Optional;Ljava/util/Optional;)J", "toName", "pushItem", "getAdditionalType", "()Ljava/lang/String;", "additionalType", "Lnet/minecraft/class_1937;", "level", "Lnet/minecraft/class_1937;", "Lnet/fabricmc/fabric/api/transfer/v1/storage/Storage;", "Lnet/fabricmc/fabric/api/transfer/v1/item/ItemVariant;", "storage", "Lnet/fabricmc/fabric/api/transfer/v1/storage/Storage;", "<init>", "(Lnet/minecraft/class_1937;Lnet/fabricmc/fabric/api/transfer/v1/storage/Storage;)V", "Companion", "peripheralium-fabric-1.19.2"})
@SourceDebugExtension(value={"SMAP\nItemStoragePlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ItemStoragePlugin.kt\nsite/siredvin/peripheralium/extra/plugins/ItemStoragePlugin\n+ 2 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n*L\n1#1,98:1\n32#2,2:99\n*S KotlinDebug\n*F\n+ 1 ItemStoragePlugin.kt\nsite/siredvin/peripheralium/extra/plugins/ItemStoragePlugin\n*L\n36#1:99,2\n*E\n"})
public final class ItemStoragePlugin
implements IPeripheralPlugin {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final class_1937 level;
    @NotNull
    private final Storage<ItemVariant> storage;
    @NotNull
    public static final String PLUGIN_TYPE = "item_storage";

    public ItemStoragePlugin(@NotNull class_1937 level, @NotNull Storage<ItemVariant> storage) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter(storage, (String)"storage");
        this.level = level;
        this.storage = storage;
    }

    @Override
    @NotNull
    public String getAdditionalType() {
        return PLUGIN_TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LuaFunction(mainThread=true)
    @NotNull
    public final List<Map<String, ?>> items() {
        List result = new ArrayList();
        Transaction transaction = Transaction.openOuter();
        AutoCloseable autoCloseable = (AutoCloseable)transaction;
        Throwable throwable = null;
        try {
            Transaction it = (Transaction)autoCloseable;
            boolean bl = false;
            Iterator iterator = this.storage.iterator();
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"storage.iterator()");
            Iterator $this$forEach$iv = iterator;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv;
            while (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                StorageView it2 = (StorageView)element$iv;
                boolean bl2 = false;
                if (it2.isResourceBlank()) continue;
                Map map = ItemData.fill((Map)new HashMap(), (class_1799)((ItemVariant)it2.getResource()).toStack((int)it2.getAmount()));
                Intrinsics.checkNotNullExpressionValue((Object)map, (String)"fill(HashMap(), it.resou\u2026Stack(it.amount.toInt()))");
                result.add(map);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return result;
    }

    @LuaFunction(mainThread=true)
    public final long pushItem(@NotNull IComputerAccess computer, @NotNull String toName, @NotNull Optional<String> itemName, @NotNull Optional<Long> limit) {
        Predicate<ItemVariant> predicate;
        Intrinsics.checkNotNullParameter((Object)computer, (String)"computer");
        Intrinsics.checkNotNullParameter((Object)toName, (String)"toName");
        Intrinsics.checkNotNullParameter(itemName, (String)"itemName");
        Intrinsics.checkNotNullParameter(limit, (String)"limit");
        IPeripheral iPeripheral = computer.getAvailablePeripheral(toName);
        if (iPeripheral == null) {
            throw new LuaException("Target '" + toName + "' does not exist");
        }
        IPeripheral location = iPeripheral;
        Storage<ItemVariant> storage = ExtractorProxy.INSTANCE.extractItemStorage(this.level, location.getTarget());
        if (storage == null) {
            throw new LuaException("Target '" + toName + "' is not an fluid inventory");
        }
        Storage<ItemVariant> toStorage = storage;
        if (itemName.isEmpty()) {
            predicate = ItemStoragePlugin::pushItem$lambda$2;
        } else {
            Object object = class_2378.field_11142.method_10223(new class_2960(itemName.get()));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ITEM.get(ResourceLocation(itemName.get()))");
            class_1792 item = (class_1792)object;
            if (Intrinsics.areEqual((Object)item, (Object)class_1802.field_8162)) {
                throw new LuaException("There is no item " + itemName.get());
            }
            predicate = arg_0 -> ItemStoragePlugin.pushItem$lambda$3(item, arg_0);
        }
        Predicate<ItemVariant> predicate2 = predicate;
        long l = PeripheraliumConfig.INSTANCE.getItemStorageTransferLimit();
        Long l2 = limit.orElse(Long.MAX_VALUE);
        Intrinsics.checkNotNullExpressionValue((Object)l2, (String)"limit.orElse(Long.MAX_VALUE)");
        long l3 = ((Number)l2).longValue();
        long realLimit2 = Math.min(l, l3);
        return StorageUtil.move(this.storage, toStorage, predicate2, (long)realLimit2, null);
    }

    @LuaFunction(mainThread=true)
    public final long pullItem(@NotNull IComputerAccess computer, @NotNull String fromName, @NotNull Optional<String> itemName, @NotNull Optional<Long> limit) {
        Predicate<ItemVariant> predicate;
        Intrinsics.checkNotNullParameter((Object)computer, (String)"computer");
        Intrinsics.checkNotNullParameter((Object)fromName, (String)"fromName");
        Intrinsics.checkNotNullParameter(itemName, (String)"itemName");
        Intrinsics.checkNotNullParameter(limit, (String)"limit");
        IPeripheral iPeripheral = computer.getAvailablePeripheral(fromName);
        if (iPeripheral == null) {
            throw new LuaException("Target '" + fromName + "' does not exist");
        }
        IPeripheral location = iPeripheral;
        Storage<ItemVariant> storage = ExtractorProxy.INSTANCE.extractItemStorage(this.level, location.getTarget());
        if (storage == null) {
            throw new LuaException("Target '" + fromName + "' is not an fluid inventory");
        }
        Storage<ItemVariant> fromStorage = storage;
        if (itemName.isEmpty()) {
            predicate = ItemStoragePlugin::pullItem$lambda$4;
        } else {
            Object object = class_2378.field_11142.method_10223(new class_2960(itemName.get()));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ITEM.get(ResourceLocation(itemName.get()))");
            class_1792 item = (class_1792)object;
            if (Intrinsics.areEqual((Object)item, (Object)class_1802.field_8162)) {
                throw new LuaException("There is no item " + itemName.get());
            }
            predicate = arg_0 -> ItemStoragePlugin.pullItem$lambda$5(item, arg_0);
        }
        Predicate<ItemVariant> predicate2 = predicate;
        long l = PeripheraliumConfig.INSTANCE.getItemStorageTransferLimit();
        Long l2 = limit.orElse(Long.MAX_VALUE);
        Intrinsics.checkNotNullExpressionValue((Object)l2, (String)"limit.orElse(Long.MAX_VALUE)");
        long l3 = ((Number)l2).longValue();
        long realLimit2 = Math.min(l, l3);
        return StorageUtil.move(fromStorage, this.storage, predicate2, (long)realLimit2, null);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ItemStoragePlugin)) {
            return false;
        }
        return Intrinsics.areEqual(this.storage, ((ItemStoragePlugin)other).storage);
    }

    public int hashCode() {
        return this.storage.hashCode();
    }

    @Override
    @Nullable
    public IPluggablePeripheral getConnectedPeripheral() {
        return IPeripheralPlugin.DefaultImpls.getConnectedPeripheral(this);
    }

    @Override
    public void setConnectedPeripheral(@Nullable IPluggablePeripheral value) {
        IPeripheralPlugin.DefaultImpls.setConnectedPeripheral(this, value);
    }

    @Override
    @NotNull
    public List<BoundMethod> getMethods() {
        return IPeripheralPlugin.DefaultImpls.getMethods(this);
    }

    @Override
    @NotNull
    public IPeripheralOperation<?>[] getOperations() {
        return IPeripheralPlugin.DefaultImpls.getOperations(this);
    }

    private static final boolean pushItem$lambda$2(ItemVariant it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final boolean pushItem$lambda$3(class_1792 $item, ItemVariant it) {
        Intrinsics.checkNotNullParameter((Object)$item, (String)"$item");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isOf((Object)$item);
    }

    private static final boolean pullItem$lambda$4(ItemVariant it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final boolean pullItem$lambda$5(class_1792 $item, ItemVariant it) {
        Intrinsics.checkNotNullParameter((Object)$item, (String)"$item");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isOf((Object)$item);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0003\u001a\u00020\u00028\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0007"}, d2={"Lsite/siredvin/peripheralium/extra/plugins/ItemStoragePlugin$Companion;", "", "", "PLUGIN_TYPE", "Ljava/lang/String;", "<init>", "()V", "peripheralium-fabric-1.19.2"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

