/*
 * Decompiled with CFR 0.152.
 */
package net.hyper_pigeon.image2map.renderer;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.util.Arrays;
import java.util.Objects;
import net.hyper_pigeon.image2map.Image2Map;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1806;
import net.minecraft.class_1935;
import net.minecraft.class_22;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3620;

public class MapRenderer {
    private static final double[] shadeCoeffs = new double[]{0.71, 0.86, 1.0, 0.53};

    public static class_3620[] getColors() {
        class_3620[] colors = new class_3620[64];
        for (int i = 0; i <= 63; ++i) {
            colors[i] = class_3620.method_38479((int)i);
        }
        return colors;
    }

    private static double distance(double[] vectorA, double[] vectorB) {
        return Math.sqrt(Math.pow(vectorA[0] - vectorB[0], 2.0) + Math.pow(vectorA[1] - vectorB[1], 2.0) + Math.pow(vectorA[2] - vectorB[2], 2.0));
    }

    private static double[] applyShade(double[] color, int ind) {
        double coeff = shadeCoeffs[ind];
        return new double[]{color[0] * coeff, color[1] * coeff, color[2] * coeff};
    }

    public static class_1799 render(BufferedImage image, Image2Map.DitherMode mode, class_3218 world, double x, double z, class_1657 player) {
        class_1799 stack = new class_1799((class_1935)class_1802.field_8204);
        int id = world.method_17889();
        class_2487 nbt = new class_2487();
        nbt.method_10582("dimension", world.method_27983().method_29177().toString());
        nbt.method_10569("xCenter", (int)x);
        nbt.method_10569("zCenter", (int)z);
        nbt.method_10556("locked", true);
        nbt.method_10556("unlimitedTracking", false);
        nbt.method_10556("trackingPosition", false);
        nbt.method_10567("scale", (byte)3);
        class_22 state = class_22.method_32371((class_2487)nbt);
        world.method_17890(class_1806.method_17440((int)id), state);
        stack.method_7948().method_10569("map", id);
        Image resizedImage = image.getScaledInstance(128, 128, 1);
        BufferedImage resized = MapRenderer.convertToBufferedImage(resizedImage);
        int width = resized.getWidth();
        int height = resized.getHeight();
        int[][] pixels = MapRenderer.convertPixelArray(resized);
        class_3620[] mapColors = MapRenderer.getColors();
        mapColors = (class_3620[])Arrays.stream(mapColors).filter(Objects::nonNull).toArray(class_3620[]::new);
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                Color imageColor = new Color(pixels[j][i], true);
                state.field_122[i + j * width] = mode.equals((Object)Image2Map.DitherMode.FLOYD) ? (byte)MapRenderer.floydDither(mapColors, pixels, i, j, imageColor) : (byte)MapRenderer.nearestColor(mapColors, imageColor);
            }
        }
        return stack;
    }

    public static class_22 render(BufferedImage image, Image2Map.DitherMode mode, int id, class_22 state) {
        Image resizedImage = image.getScaledInstance(128, 128, 1);
        BufferedImage resized = MapRenderer.convertToBufferedImage(resizedImage);
        int width = resized.getWidth();
        int height = resized.getHeight();
        int[][] pixels = MapRenderer.convertPixelArray(resized);
        class_3620[] mapColors = MapRenderer.getColors();
        mapColors = (class_3620[])Arrays.stream(mapColors).filter(Objects::nonNull).toArray(class_3620[]::new);
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                Color imageColor = new Color(pixels[j][i], true);
                state.field_122[i + j * width] = mode.equals((Object)Image2Map.DitherMode.FLOYD) ? (byte)MapRenderer.floydDither(mapColors, pixels, i, j, imageColor) : (byte)MapRenderer.nearestColor(mapColors, imageColor);
            }
        }
        return state;
    }

    private static Color mapColorToRGBColor(class_3620[] colors, int color) {
        Color mcColor = new Color(colors[color >> 2].field_16011);
        double[] mcColorVec = new double[]{mcColor.getRed(), mcColor.getGreen(), mcColor.getBlue()};
        double coeff = shadeCoeffs[color & 3];
        return new Color((int)(mcColorVec[0] * coeff), (int)(mcColorVec[1] * coeff), (int)(mcColorVec[2] * coeff));
    }

    private static int floydDither(class_3620[] mapColors, int[][] pixels, int x, int y, Color imageColor) {
        Color pixelColor;
        int colorIndex = MapRenderer.nearestColor(mapColors, imageColor);
        Color palletedColor = MapRenderer.mapColorToRGBColor(mapColors, colorIndex);
        NegatableColor error = new NegatableColor(imageColor.getRed() - palletedColor.getRed(), imageColor.getGreen() - palletedColor.getGreen(), imageColor.getBlue() - palletedColor.getBlue());
        if (pixels[0].length > x + 1) {
            pixelColor = new Color(pixels[y][x + 1], true);
            pixels[y][x + 1] = MapRenderer.applyError(pixelColor, error, 0.4375);
        }
        if (pixels.length > y + 1) {
            if (x > 0) {
                pixelColor = new Color(pixels[y + 1][x - 1], true);
                pixels[y + 1][x - 1] = MapRenderer.applyError(pixelColor, error, 0.1875);
            }
            pixelColor = new Color(pixels[y + 1][x], true);
            pixels[y + 1][x] = MapRenderer.applyError(pixelColor, error, 0.3125);
            if (pixels[0].length > x + 1) {
                pixelColor = new Color(pixels[y + 1][x + 1], true);
                pixels[y + 1][x + 1] = MapRenderer.applyError(pixelColor, error, 0.0625);
            }
        }
        return colorIndex;
    }

    private static int applyError(Color pixelColor, NegatableColor error, double quantConst) {
        int pR = MapRenderer.clamp(pixelColor.getRed() + (int)((double)error.r * quantConst), 0, 255);
        int pG = MapRenderer.clamp(pixelColor.getGreen() + (int)((double)error.g * quantConst), 0, 255);
        int pB = MapRenderer.clamp(pixelColor.getBlue() + (int)((double)error.b * quantConst), 0, 255);
        return new Color(pR, pG, pB, pixelColor.getAlpha()).getRGB();
    }

    private static int clamp(int i, int min, int max) {
        if (min > max) {
            throw new IllegalArgumentException("max value cannot be less than min value");
        }
        if (i < min) {
            return min;
        }
        if (i > max) {
            return max;
        }
        return i;
    }

    private static int nearestColor(class_3620[] colors, Color imageColor) {
        double[] imageVec = new double[]{(double)imageColor.getRed() / 255.0, (double)imageColor.getGreen() / 255.0, (double)imageColor.getBlue() / 255.0};
        int best_color = 0;
        double lowest_distance = 10000.0;
        for (int k = 0; k < colors.length; ++k) {
            Color mcColor = new Color(colors[k].field_16011);
            double[] mcColorVec = new double[]{(double)mcColor.getRed() / 255.0, (double)mcColor.getGreen() / 255.0, (double)mcColor.getBlue() / 255.0};
            for (int shadeInd = 0; shadeInd < shadeCoeffs.length; ++shadeInd) {
                double distance = MapRenderer.distance(imageVec, MapRenderer.applyShade(mcColorVec, shadeInd));
                if (!(distance < lowest_distance)) continue;
                lowest_distance = distance;
                best_color = k == 0 && imageColor.getAlpha() == 255 ? 119 : k * shadeCoeffs.length + shadeInd;
            }
        }
        return best_color;
    }

    private static int[][] convertPixelArray(BufferedImage image) {
        byte[] pixels = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        int width = image.getWidth();
        int height = image.getHeight();
        int[][] result = new int[height][width];
        int pixelLength = 4;
        int pixel = 0;
        int row = 0;
        int col = 0;
        while (pixel + 3 < pixels.length) {
            int argb = 0;
            argb += (pixels[pixel] & 0xFF) << 24;
            argb += pixels[pixel + 1] & 0xFF;
            argb += (pixels[pixel + 2] & 0xFF) << 8;
            result[row][col] = argb += (pixels[pixel + 3] & 0xFF) << 16;
            if (++col == width) {
                col = 0;
                ++row;
            }
            pixel += 4;
        }
        return result;
    }

    private static BufferedImage convertToBufferedImage(Image image) {
        BufferedImage newImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 6);
        Graphics2D g = newImage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return newImage;
    }

    private static class NegatableColor {
        public final int r;
        public final int g;
        public final int b;

        public NegatableColor(int r, int g, int b) {
            this.r = r;
            this.g = g;
            this.b = b;
        }
    }
}

