/*
 * Decompiled with CFR 0.152.
 */
package net.hyper_pigeon.polaroidcamera.client;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Objects;
import javax.imageio.ImageIO;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.hyper_pigeon.image2map.Image2Map;
import net.hyper_pigeon.image2map.renderer.MapRenderer;
import net.hyper_pigeon.polaroidcamera.networking.PolaroidCameraNetworkingConstants;
import net.minecraft.class_1011;
import net.minecraft.class_22;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_276;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_318;
import net.minecraft.class_3675;

@Environment(value=EnvType.CLIENT)
public class PolaroidCameraClient
implements ClientModInitializer {
    public static class_304 TAKE_PICTURE_KEY;

    public void onInitializeClient() {
        TAKE_PICTURE_KEY = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.polaroid_camera.take_picture", class_3675.class_307.field_1668, 67, "Polaroid Camera"));
        ClientPlayNetworking.registerGlobalReceiver((class_2960)PolaroidCameraNetworkingConstants.CREATE_PICTURE, (client, handler, buf, responseSender) -> {
            int mapID = buf.readInt();
            class_22 mapState = class_22.method_32371((class_2487)Objects.requireNonNull(buf.method_10798()));
            client.execute(() -> {
                boolean isHUDhidden = client.field_1690.field_1842;
                client.field_1690.field_1842 = true;
                class_1011 nativeImage = class_318.method_1663((class_276)client.method_1522());
                client.field_1690.field_1842 = isHUDhidden;
                try {
                    byte[] imageBytes = nativeImage.method_24036();
                    BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(imageBytes));
                    bufferedImage = this.crop(bufferedImage, bufferedImage.getHeight(), bufferedImage.getHeight());
                    class_22 mapState1 = MapRenderer.render(bufferedImage, Image2Map.DitherMode.FLOYD, mapID, mapState);
                    class_2540 packetByteBuf = PacketByteBufs.create();
                    class_2487 nbtCompound = new class_2487();
                    packetByteBuf.writeInt(mapID);
                    packetByteBuf.method_10794(mapState1.method_75(nbtCompound));
                    ClientPlayNetworking.send((class_2960)PolaroidCameraNetworkingConstants.SPAWN_PICTURE, (class_2540)packetByteBuf);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        });
    }

    public BufferedImage crop(BufferedImage bufferedImage, int targetWidth, int targetHeight) throws IOException {
        int height = bufferedImage.getHeight();
        int width = bufferedImage.getWidth();
        int xc = (width - targetWidth) / 2;
        int yc = (height - targetHeight) / 2;
        BufferedImage croppedImage = bufferedImage.getSubimage(xc, yc, targetWidth, targetHeight);
        return croppedImage;
    }
}

