/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.blocks;

import java.util.HashSet;
import java.util.Set;
import net.creeperhost.polylib.blocks.DataRetainingBlock;
import net.creeperhost.polylib.blocks.RedstoneActivatedBlock;
import net.creeperhost.polylib.containers.PolyBlockContainerMenu;
import net.creeperhost.polylib.data.DataManagerBlock;
import net.creeperhost.polylib.data.TileDataManager;
import net.creeperhost.polylib.data.serializable.AbstractDataStore;
import net.creeperhost.polylib.data.serializable.BooleanData;
import net.creeperhost.polylib.data.serializable.EnumData;
import net.minecraft.class_1275;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public class PolyBlockEntity
extends class_2586
implements class_1275,
DataManagerBlock,
DataRetainingBlock {
    private final TileDataManager<PolyBlockEntity> dataManager = new TileDataManager<PolyBlockEntity>(this);
    private final Set<class_1657> accessingPlayers = new HashSet<class_1657>();
    private class_2561 customName = null;
    private int tick = 0;
    private EnumData<RedstoneActivatedBlock.RSMode> redstoneMode = null;
    private BooleanData isPowered = null;

    public PolyBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        if (this instanceof RedstoneActivatedBlock) {
            this.redstoneMode = this.register("rs_mode", new EnumData<RedstoneActivatedBlock.RSMode>(RedstoneActivatedBlock.RSMode.ALWAYS_ACTIVE), 9, 4, 2);
            this.isPowered = this.register("rs_powered", new BooleanData(false), 8, 4);
        }
    }

    public TileDataManager<PolyBlockEntity> getDataManager() {
        return this.dataManager;
    }

    public <D extends AbstractDataStore<?>> D register(String name, D data, int ... flags) {
        return this.dataManager.register(name, data, flags);
    }

    public void tick() {
        ++this.tick;
        this.dataManager.tick();
    }

    public Set<class_1657> getAccessingPlayers() {
        this.accessingPlayers.removeIf(e -> {
            class_1703 patt3231$temp = e.field_7512;
            if (!(patt3231$temp instanceof PolyBlockContainerMenu)) return true;
            PolyBlockContainerMenu container = (PolyBlockContainerMenu)patt3231$temp;
            if (container.tile == this) return false;
            return true;
        });
        return this.accessingPlayers;
    }

    public void onPlayerOpenContainer(class_1657 player) {
        this.accessingPlayers.add(player);
    }

    public void onPlayerCloseContainer(class_1657 player) {
        this.accessingPlayers.remove(player);
        this.accessingPlayers.removeIf(e -> {
            class_1703 patt3616$temp = e.field_7512;
            if (!(patt3616$temp instanceof PolyBlockContainerMenu)) return true;
            PolyBlockContainerMenu container = (PolyBlockContainerMenu)patt3616$temp;
            if (container.tile == this) return false;
            return true;
        });
    }

    public int getAccessDistanceSq() {
        return 64;
    }

    public class_2561 method_5477() {
        if (this.method_16914()) {
            return this.method_5797();
        }
        return class_2561.method_43471((String)this.method_11010().method_26204().method_9539());
    }

    public boolean method_16914() {
        return this.customName != null;
    }

    @Nullable
    public class_2561 method_5797() {
        return this.customName;
    }

    public void setCustomName(@Nullable class_2561 customName) {
        this.customName = customName;
    }

    public class_2561 method_5476() {
        return super.method_5476();
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        this.dataManager.save(nbt);
        this.writeExtraData(nbt);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.dataManager.load(nbt);
        this.readExtraData(nbt);
    }

    @Override
    public void writeToItemStack(class_2487 nbt, boolean willHarvest) {
        this.dataManager.saveToItem(nbt);
        this.writeExtraData(nbt);
    }

    @Override
    public void readFromItemStack(class_2487 nbt) {
        this.dataManager.loadFromItem(nbt);
        this.readExtraData(nbt);
    }

    public void writeExtraData(class_2487 nbt) {
    }

    public void readExtraData(class_2487 nbt) {
    }

    public int getTime() {
        return this.tick;
    }

    public boolean onInterval(int tickInterval) {
        return this.tick % tickInterval == 0;
    }

    public RedstoneActivatedBlock.RSMode getRSMode() {
        if (!(this instanceof RedstoneActivatedBlock)) {
            throw new IllegalStateException("Tile does not implement IRSSwitchable");
        }
        return (RedstoneActivatedBlock.RSMode)((Object)this.redstoneMode.get());
    }

    public void setRSMode(RedstoneActivatedBlock.RSMode mode) {
        if (!(this instanceof RedstoneActivatedBlock)) {
            throw new IllegalStateException("Tile does not implement IRSSwitchable");
        }
        if (this.field_11863.field_9236) {
            this.sendDataValueToServer(this.redstoneMode, (Object)mode);
        } else {
            this.redstoneMode.set(mode);
        }
    }

    public void cycleRSMode(boolean reverse) {
        this.redstoneMode.set(((RedstoneActivatedBlock.RSMode)((Object)this.redstoneMode.get())).next(reverse));
    }

    public boolean isTileEnabled() {
        if (this instanceof RedstoneActivatedBlock) {
            return ((RedstoneActivatedBlock.RSMode)((Object)this.redstoneMode.get())).canRun((Boolean)this.isPowered.get());
        }
        return true;
    }

    public void onNeighborChange(class_2248 fromBlock, class_2338 fromPos, boolean isMoving) {
        if (this instanceof RedstoneActivatedBlock) {
            boolean lastSignal = (Boolean)this.isPowered.get();
            this.isPowered.set(this.field_11863.method_8479(this.field_11867));
            if ((Boolean)this.isPowered.get() != lastSignal) {
                this.onSignalChange((Boolean)this.isPowered.get());
            }
        }
    }

    public void onSignalChange(boolean newSignal) {
    }
}

