/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.blocks;

import java.util.function.Supplier;
import net.creeperhost.polylib.blocks.ChangeListener;
import net.creeperhost.polylib.blocks.DataRetainingBlock;
import net.creeperhost.polylib.blocks.InteractableBlock;
import net.creeperhost.polylib.blocks.PolyBlock;
import net.creeperhost.polylib.blocks.PolyBlockEntity;
import net.creeperhost.polylib.blocks.RedstoneEmitter;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1275;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3468;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import org.jetbrains.annotations.Nullable;

public class PolyEntityBlock
extends PolyBlock
implements class_2343 {
    public static final String POLY_TILE_DATA_TAG = "poly_tile_data";
    private Supplier<class_2591<? extends PolyBlockEntity>> blockEntityType = null;
    private boolean enableTicking;

    public PolyEntityBlock(class_4970.class_2251 properties) {
        super(properties);
    }

    public PolyEntityBlock setBlockEntity(Supplier<class_2591<? extends PolyBlockEntity>> blockEntityType, boolean enableTicking) {
        this.blockEntityType = blockEntityType;
        this.enableTicking = enableTicking;
        return this;
    }

    @Nullable
    public class_2586 method_10123(class_2338 blockPos, class_2680 blockState) {
        return this.blockEntityType.get().method_11032(blockPos, blockState);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> entityType) {
        if (this.enableTicking && this.blockEntityType.get() == entityType) {
            return (e, e2, e3, tile) -> ((PolyBlockEntity)tile).tick();
        }
        return null;
    }

    public int method_9524(class_2680 state, class_1922 blockAccess, class_2338 pos, class_2350 side) {
        class_2586 class_25862 = blockAccess.method_8321(pos);
        if (class_25862 instanceof RedstoneEmitter) {
            RedstoneEmitter emitter = (RedstoneEmitter)class_25862;
            return emitter.getWeakPower(state, side);
        }
        return super.method_9524(state, blockAccess, pos, side);
    }

    public int method_9603(class_2680 state, class_1922 blockAccess, class_2338 pos, class_2350 side) {
        class_2586 class_25862 = blockAccess.method_8321(pos);
        if (class_25862 instanceof RedstoneEmitter) {
            RedstoneEmitter emitter = (RedstoneEmitter)class_25862;
            return emitter.getStrongPower(state, side);
        }
        return super.method_9603(state, blockAccess, pos, side);
    }

    public void method_9612(class_2680 state, class_1937 level, class_2338 pos, class_2248 blockIn, class_2338 fromPos, boolean isMoving) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof ChangeListener) {
            ChangeListener listener = (ChangeListener)class_25862;
            listener.onNeighborChange(blockIn, fromPos, isMoving);
        }
        super.method_9612(state, level, pos, blockIn, fromPos, isMoving);
    }

    public class_1269 method_9534(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof InteractableBlock) {
            InteractableBlock interactable = (InteractableBlock)class_25862;
            return interactable.onBlockUse(player, hand, hit);
        }
        return super.method_9534(state, level, pos, player, hand, hit);
    }

    public void method_9606(class_2680 state, class_1937 level, class_2338 pos, class_1657 player) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof InteractableBlock) {
            InteractableBlock interactable = (InteractableBlock)class_25862;
            interactable.onBlockAttack(player);
        }
        super.method_9606(state, level, pos, player);
    }

    public void method_9567(class_1937 level, class_2338 pos, class_2680 state, class_1309 placer, class_1799 stack) {
        class_2586 blockEntity = level.method_8321(pos);
        if (blockEntity instanceof DataRetainingBlock) {
            DataRetainingBlock retaining = (DataRetainingBlock)blockEntity;
            if (stack.method_7985() && stack.method_7969().method_10545(POLY_TILE_DATA_TAG)) {
                retaining.readFromItemStack(stack.method_7941(POLY_TILE_DATA_TAG));
            }
        }
        if (blockEntity instanceof PolyBlockEntity) {
            PolyBlockEntity polyBlock = (PolyBlockEntity)blockEntity;
            if (stack.method_7938()) {
                polyBlock.setCustomName(stack.method_7964());
            }
        }
    }

    public class_1799 method_9574(class_1922 level, class_2338 pos, class_2680 state) {
        DataRetainingBlock retaining;
        class_1799 stack = super.method_9574(level, pos, state);
        class_2586 blockEntity = level.method_8321(pos);
        if (blockEntity instanceof DataRetainingBlock && (retaining = (DataRetainingBlock)blockEntity).saveToItem() && (level instanceof class_3218 || !this.isCTRLKeyDown())) {
            class_2487 nbt = new class_2487();
            ((DataRetainingBlock)blockEntity).writeToItemStack(nbt, false);
            if (!nbt.method_33133()) {
                stack.method_7948().method_10566(POLY_TILE_DATA_TAG, (class_2520)nbt);
            }
        }
        if (blockEntity instanceof class_1275 && ((class_1275)blockEntity).method_16914()) {
            stack.method_7977(((class_1275)blockEntity).method_5477());
        }
        return stack;
    }

    private boolean isCTRLKeyDown() {
        return class_437.method_25441();
    }

    public void method_9556(class_1937 level, class_1657 player, class_2338 pos, class_2680 state, class_2586 blockEntity, class_1799 heldStack) {
        class_1275 nameable;
        DataRetainingBlock retaining;
        class_1799 stack = class_1799.field_8037;
        if (blockEntity instanceof DataRetainingBlock && (retaining = (DataRetainingBlock)blockEntity).saveToItem()) {
            class_2487 nbt = new class_2487();
            retaining.writeToItemStack(nbt, true);
            if (!nbt.method_33133()) {
                stack = new class_1799((class_1935)this, 1);
                stack.method_7948().method_10566(POLY_TILE_DATA_TAG, (class_2520)nbt);
            }
        }
        if (blockEntity instanceof class_1275 && (nameable = (class_1275)blockEntity).method_16914()) {
            if (stack.method_7960()) {
                stack = new class_1799((class_1935)this, 1);
            }
            stack.method_7977(nameable.method_5477());
        }
        if (!stack.method_7960()) {
            player.method_7259(class_3468.field_15427.method_14956((Object)this));
            player.method_7322(0.005f);
            PolyEntityBlock.method_9577((class_1937)level, (class_2338)pos, (class_1799)stack);
            level.method_8544(pos);
        } else {
            super.method_9556(level, player, pos, state, blockEntity, heldStack);
        }
    }
}

