/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.client.modulargui;

import java.util.Set;
import net.creeperhost.polylib.client.modulargui.ModularGui;
import net.creeperhost.polylib.client.modulargui.elements.GuiElement;
import net.creeperhost.polylib.client.modulargui.lib.GuiRender;
import net.creeperhost.polylib.client.modulargui.lib.container.ContainerGuiProvider;
import net.creeperhost.polylib.client.modulargui.lib.container.ContainerScreenAccess;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GeoParam;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModularGuiContainer<T extends class_1703>
extends class_465<T>
implements ContainerScreenAccess<T> {
    public final ModularGui modularGui;
    private boolean renderingSlots = false;

    public ModularGuiContainer(T containerMenu, class_1661 inventory, ContainerGuiProvider<T> provider) {
        super(containerMenu, inventory, (class_2561)class_2561.method_43473());
        provider.setMenuAccess(this);
        this.modularGui = new ModularGui(provider);
        this.modularGui.setScreen((class_437)this);
    }

    public ModularGui getModularGui() {
        return this.modularGui;
    }

    @NotNull
    public class_2561 method_25440() {
        return this.modularGui.getGuiTitle();
    }

    public boolean method_25422() {
        return this.modularGui.closeOnEscape();
    }

    protected void method_25426() {
        this.modularGui.onScreenInit(this.field_22787, this.field_22793, this.field_22789, this.field_22790);
    }

    public void method_25410(@NotNull class_310 minecraft, int width, int height) {
        super.method_25410(minecraft, width, height);
        this.modularGui.onScreenInit(minecraft, this.field_22793, width, height);
    }

    public void method_25394(class_4587 poseStack, int mouseX, int mouseY, float partialTicks) {
        GuiElement<?> root = this.modularGui.getRoot();
        this.field_2800 = (int)root.getValue(GeoParam.TOP);
        this.field_2776 = (int)root.getValue(GeoParam.LEFT);
        this.field_2792 = (int)root.getValue(GeoParam.WIDTH);
        this.field_2779 = (int)root.getValue(GeoParam.HEIGHT);
        this.modularGui.setVanillaSlotRendering(false);
        if (this.modularGui.renderBackground()) {
            this.method_25420(poseStack);
        }
        GuiRender render = new GuiRender(this.field_22787, poseStack, this.field_22787.method_22940().method_23000());
        this.modularGui.render(render, partialTicks);
        super.method_25394(poseStack, mouseX, mouseY, partialTicks);
        if (!this.handleFloatingItemRender(render, mouseX, mouseY) && !this.renderHoveredStackToolTip(render, mouseX, mouseY)) {
            this.modularGui.renderOverlay(render, partialTicks);
        }
    }

    protected boolean handleFloatingItemRender(GuiRender render, int mouseX, int mouseY) {
        class_1799 stack;
        if (this.modularGui.vanillaSlotRendering()) {
            return false;
        }
        boolean ret = false;
        class_1799 class_17992 = stack = this.field_2782.method_7960() ? this.field_2797.method_34255() : this.field_2782;
        if (!stack.method_7960()) {
            int yOffset = this.field_2782.method_7960() ? 8 : 16;
            String countOverride = null;
            if (!this.field_2782.method_7960() && this.field_2789) {
                stack = stack.method_7972();
                stack.method_7939(class_3532.method_15386((float)((float)stack.method_7947() / 2.0f)));
            } else if (this.field_2794 && this.field_2793.size() > 1) {
                stack = stack.method_7972();
                stack.method_7939(this.field_2803);
                if (stack.method_7960()) {
                    countOverride = class_124.field_1054 + "0";
                }
            }
            this.renderFloatingItem(render, stack, mouseX - 8, mouseY - yOffset, countOverride);
            ret = true;
        }
        if (!this.field_2785.method_7960()) {
            float anim = (float)(class_156.method_658() - this.field_2795) / 100.0f;
            if (anim >= 1.0f) {
                anim = 1.0f;
                this.field_2785 = class_1799.field_8037;
            }
            int xDist = this.field_2802.field_7873 - this.field_2784;
            int yDist = this.field_2802.field_7872 - this.field_2796;
            int xPos = this.field_2784 + (int)((float)xDist * anim);
            int yPos = this.field_2796 + (int)((float)yDist * anim);
            this.renderFloatingItem(render, this.field_2785, xPos + this.field_2776, yPos + this.field_2800, null);
            ret = true;
        }
        return ret;
    }

    protected boolean renderHoveredStackToolTip(GuiRender guiGraphics, int mouseX, int mouseY) {
        if (this.field_2797.method_34255().method_7960() && this.field_2787 != null && this.field_2787.method_7681()) {
            GuiElement<?> handler = this.modularGui.getSlotHandler(this.field_2787);
            if (handler != null && (handler.blockMouseOver(handler, mouseX, mouseY) || !handler.isMouseOver())) {
                return false;
            }
            class_1799 itemStack = this.field_2787.method_7677();
            guiGraphics.toolTipWithImage(this.method_25408(itemStack), itemStack.method_32347(), mouseX, mouseY);
            return true;
        }
        return false;
    }

    protected void method_37432() {
        this.modularGui.tick();
    }

    public void method_25419() {
        super.method_25419();
        this.modularGui.onGuiClose();
    }

    public void method_16014(double mouseX, double mouseY) {
        this.modularGui.mouseMoved(mouseX, mouseY);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        return this.modularGui.mouseClicked(mouseX, mouseY, button) || super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        return this.modularGui.mouseReleased(mouseX, mouseY, button) || super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double scroll) {
        return this.modularGui.mouseScrolled(mouseX, mouseY, scroll) || super.method_25401(mouseX, mouseY, scroll);
    }

    public boolean method_25404(int key, int scancode, int modifiers) {
        return this.modularGui.keyPressed(key, scancode, modifiers) || super.method_25404(key, scancode, modifiers);
    }

    public boolean method_16803(int key, int scancode, int modifiers) {
        return this.modularGui.keyReleased(key, scancode, modifiers) || super.method_16803(key, scancode, modifiers);
    }

    public boolean method_25400(char character, int modifiers) {
        return this.modularGui.charTyped(character, modifiers) || super.method_25400(character, modifiers);
    }

    protected void method_2389(class_4587 poseStack, float f, int i, int j) {
    }

    public void method_2385(class_4587 poseStack, class_1735 slot) {
        if (this.modularGui.vanillaSlotRendering()) {
            super.method_2385(poseStack, slot);
        } else {
            this.renderingSlots = true;
        }
    }

    @Override
    public void renderSlot(GuiRender render, class_1735 slot) {
        if (this.modularGui.vanillaSlotRendering()) {
            return;
        }
        int slotX = slot.field_7873 + this.field_2776;
        int slotY = slot.field_7872 + this.field_2800;
        class_1799 itemStack = slot.method_7677();
        boolean dragingToSlot = false;
        boolean dontRenderItem = slot == this.field_2777 && !this.field_2782.method_7960() && !this.field_2789;
        class_1799 itemStack2 = this.field_2797.method_34255();
        String countString = null;
        if (slot == this.field_2777 && !this.field_2782.method_7960() && this.field_2789 && !itemStack.method_7960()) {
            itemStack = itemStack.method_7972();
            itemStack.method_7939(itemStack.method_7947() / 2);
        } else if (this.field_2794 && this.field_2793.contains(slot) && !itemStack2.method_7960()) {
            if (this.field_2793.size() == 1) {
                return;
            }
            if (class_1703.method_7592((class_1735)slot, (class_1799)itemStack2, (boolean)true) && this.field_2797.method_7615(slot)) {
                itemStack = itemStack2.method_7972();
                dragingToSlot = true;
                class_1703.method_7617((Set)this.field_2793, (int)this.field_2790, (class_1799)itemStack, (int)(slot.method_7677().method_7960() ? 0 : slot.method_7677().method_7947()));
                int k = Math.min(itemStack.method_7914(), slot.method_7676(itemStack));
                if (itemStack.method_7947() > k) {
                    countString = class_124.field_1054.toString() + k;
                    itemStack.method_7939(k);
                }
            } else {
                this.field_2793.remove(slot);
                this.method_2379();
            }
        }
        if (!dontRenderItem) {
            if (dragingToSlot) {
                render.fill(slotX, slotY, slotX + 16, slotY + 16, -2130706433);
            }
            render.renderItem(itemStack, slotX, (double)slotY, 16.0, slot.field_7873 + slot.field_7872 * this.field_2792);
            render.renderItemDecorations(itemStack, (double)slotX, (double)slotY, countString);
        }
    }

    public boolean method_2387(class_1735 pSlot, double pMouseX, double pMouseY) {
        boolean ret = super.method_2387(pSlot, pMouseX, pMouseY);
        if (ret && this.renderingSlots && pSlot.method_7682()) {
            this.field_2787 = pSlot;
            return false;
        }
        return ret;
    }

    protected void method_2388(class_4587 poseStack, int i, int j) {
        this.renderingSlots = false;
    }

    public void method_2382(class_1799 itemStack, int i, int j, String string) {
        if (this.modularGui.vanillaSlotRendering()) {
            super.method_2382(itemStack, i, j, string);
        }
    }

    public void renderFloatingItem(GuiRender render, class_1799 itemStack, int x, int y, String string) {
        render.pose().method_22903();
        render.pose().method_22904(0.0, 0.0, 50.0);
        render.renderItem(itemStack, x, y);
        render.renderItemDecorations(itemStack, (double)x, (double)(y - (this.field_2782.method_7960() ? 0 : 8)), string);
        render.pose().method_22909();
    }

    @Nullable
    public class_1735 method_2386(double mouseX, double mouseY) {
        class_1735 slot = super.method_2386(mouseX, mouseY);
        if (slot == null) {
            return null;
        }
        GuiElement<?> handler = this.modularGui.getSlotHandler(slot);
        if (!(handler == null || handler.isEnabled() && handler.isMouseOver())) {
            return null;
        }
        return slot;
    }

    protected void method_2383(class_1735 slot, int i, int j, class_1713 clickType) {
        GuiElement<?> handler;
        if (slot != null && (handler = this.modularGui.getSlotHandler(slot)) != null && !handler.isEnabled()) {
            return;
        }
        super.method_2383(slot, i, j, clickType);
    }
}

