/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.client.modulargui.elements;

import java.util.function.Supplier;
import net.creeperhost.polylib.client.modulargui.elements.GuiElement;
import net.creeperhost.polylib.client.modulargui.lib.BackgroundRender;
import net.creeperhost.polylib.client.modulargui.lib.GuiRender;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GeoParam;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GuiParent;
import net.minecraft.class_1799;
import org.jetbrains.annotations.NotNull;

public class GuiItemStack
extends GuiElement<GuiItemStack>
implements BackgroundRender {
    private Supplier<class_1799> stack;
    private Supplier<Boolean> decorate = () -> true;
    private Supplier<Boolean> toolTip = () -> true;

    public GuiItemStack(@NotNull GuiParent<?> parent) {
        this(parent, () -> class_1799.field_8037);
    }

    public GuiItemStack(@NotNull GuiParent<?> parent, class_1799 itemStack) {
        super(parent);
        this.setStack(itemStack);
    }

    public GuiItemStack(@NotNull GuiParent<?> parent, Supplier<class_1799> provider) {
        super(parent);
        this.setStack(provider);
    }

    public GuiItemStack setStack(Supplier<class_1799> stackProvider) {
        this.stack = stackProvider;
        return this;
    }

    public GuiItemStack setStack(class_1799 stack) {
        this.stack = () -> stack;
        return this;
    }

    public GuiItemStack enableStackDecoration(boolean enableDecoration) {
        return this.enableStackDecoration(() -> enableDecoration);
    }

    public GuiItemStack enableStackDecoration(Supplier<Boolean> enableDecoration) {
        this.decorate = enableDecoration;
        return this;
    }

    public GuiItemStack enableStackToolTip(boolean enableToolTip) {
        return this.enableStackToolTip(() -> enableToolTip);
    }

    public GuiItemStack enableStackToolTip(Supplier<Boolean> enableToolTip) {
        this.toolTip = enableToolTip;
        return this;
    }

    public double getStackSize() {
        return Math.max(this.getValue(GeoParam.WIDTH), this.getValue(GeoParam.HEIGHT));
    }

    @Override
    public double getBackgroundDepth() {
        return this.getStackSize() * 2.0;
    }

    @Override
    public void renderBehind(GuiRender render, double mouseX, double mouseY, float partialTicks) {
        class_1799 stack = this.stack.get();
        if (stack.method_7960()) {
            return;
        }
        render.renderItem(stack, this.xMin(), this.yMin(), this.getStackSize(), (int)(this.xMin() + this.xSize() * this.yMin()));
        if (this.decorate.get().booleanValue()) {
            render.renderItemDecorations(stack, this.xMin(), this.yMin(), this.getStackSize());
        }
    }

    @Override
    public boolean renderOverlay(GuiRender render, double mouseX, double mouseY, float partialTicks, boolean consumed) {
        if (super.renderOverlay(render, mouseX, mouseY, partialTicks, consumed)) {
            return true;
        }
        if (this.isMouseOver() && !this.stack.get().method_7960()) {
            render.renderTooltip(this.stack.get(), mouseX, mouseY);
            return true;
        }
        return false;
    }
}

