/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.client.modulargui.lib.container;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.creeperhost.polylib.containers.ModularGuiContainerMenu;
import net.creeperhost.polylib.containers.slots.PolySlot;
import net.minecraft.class_1263;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1890;

public class SlotGroup {
    public final int zone;
    public final List<Integer> quickMoveTo;
    private final ModularGuiContainerMenu containerMenu;
    private final List<PolySlot> slots = new ArrayList<PolySlot>();

    public SlotGroup(ModularGuiContainerMenu containerMenu, int zone, int ... quickMoveTo) {
        this.zone = zone;
        this.containerMenu = containerMenu;
        this.quickMoveTo = Arrays.stream(quickMoveTo).boxed().toList();
    }

    public PolySlot addSlot(PolySlot slot) {
        this.slots.add(slot);
        this.containerMenu.method_7621(slot);
        this.containerMenu.mapSlot(slot, this);
        return slot;
    }

    public void addSlots(int slotCount, int startIndex, Function<Integer, PolySlot> makeSlot) {
        for (int index = startIndex; index < startIndex + slotCount; ++index) {
            this.addSlot(makeSlot.apply(index));
        }
    }

    public void addAllSlots(class_1263 container) {
        this.addAllSlots(container, PolySlot::new);
    }

    public void addAllSlots(class_1263 container, BiFunction<class_1263, Integer, PolySlot> makeSlot) {
        for (int index = 0; index < container.method_5439(); ++index) {
            this.addSlot(makeSlot.apply(container, index));
        }
    }

    public void addPlayerMain(class_1661 inventory) {
        this.addSlots(27, 9, index -> new PolySlot((class_1263)inventory, (int)index));
    }

    public void addPlayerBar(class_1661 inventory) {
        this.addSlots(9, 0, index -> new PolySlot((class_1263)inventory, (int)index));
    }

    public void addPlayerArmor(class_1661 inventory) {
        for (int i = 0; i < 4; ++i) {
            class_1304 slot = class_1304.method_20234((class_1304.class_1305)class_1304.class_1305.field_6178, (int)(3 - i));
            this.addSlot(new PolySlot((class_1263)inventory, 39 - i).onSet((oldStack, newStack) -> SlotGroup.onEquipItem(inventory, slot, newStack, oldStack)).setStackLimit(stack -> 1).setValidator(stack -> slot == class_1308.method_32326((class_1799)stack)).setCanRemove((player, stack) -> stack.method_7960() || player.method_7337() || !class_1890.method_8224((class_1799)stack)));
        }
    }

    public void addPlayerOffhand(class_1661 inventory) {
        this.addSlot(new PolySlot((class_1263)inventory, 40).onSet((oldStack, newStack) -> SlotGroup.onEquipItem(inventory, class_1304.field_6171, newStack, oldStack)));
    }

    static void onEquipItem(class_1661 inventory, class_1304 slot, class_1799 newStack, class_1799 oldStack) {
        inventory.field_7546.method_6116(slot, oldStack, newStack);
    }

    public int size() {
        return this.slots.size();
    }

    public PolySlot getSlot(int index) {
        return this.slots.get(index);
    }

    public int indexOf(class_1735 slot) {
        return this.slots.indexOf(slot);
    }

    public List<PolySlot> slots() {
        return Collections.unmodifiableList(this.slots);
    }
}

