/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.client.modulargui.sprite;

import java.util.function.Function;
import net.minecraft.class_1011;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1079;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4730;
import org.jetbrains.annotations.Nullable;

public class Material {
    private final class_2960 atlasLocation;
    private final class_2960 texture;
    private final Function<class_2960, class_1058> spriteFunction;
    @Nullable
    private class_1921 renderType;
    @Nullable
    private class_4730 vanillaMat;

    public Material(class_2960 atlasLocation, class_2960 texture, Function<class_2960, class_1058> spriteFunction) {
        this.atlasLocation = atlasLocation;
        this.texture = texture;
        this.spriteFunction = spriteFunction;
    }

    public class_2960 atlasLocation() {
        return this.atlasLocation;
    }

    public class_2960 texture() {
        return this.texture;
    }

    public class_1058 sprite() {
        return this.spriteFunction.apply(this.texture());
    }

    public class_1921 renderType(Function<class_2960, class_1921> typeBuilder) {
        if (this.renderType == null) {
            this.renderType = typeBuilder.apply(this.atlasLocation());
        }
        return this.renderType;
    }

    public class_4588 buffer(class_4597 buffers, Function<class_2960, class_1921> typeBuilder) {
        return buffers.getBuffer(this.renderType(typeBuilder));
    }

    public class_4730 getVanillaMat() {
        if (this.vanillaMat == null) {
            this.vanillaMat = new class_4730(this.atlasLocation, this.texture);
        }
        return this.vanillaMat;
    }

    public static Material fromAtlas(class_2960 atlasLocation, String texture) {
        return new Material(atlasLocation, new class_2960(atlasLocation.method_12836(), texture), e -> (class_1058)class_310.method_1551().method_1549(atlasLocation).apply(e));
    }

    @Nullable
    public static Material fromSprite(@Nullable class_1058 sprite) {
        if (sprite == null) {
            return null;
        }
        return new Material(sprite.method_24119().method_24106(), sprite.method_4598(), e -> sprite.method_24119().method_4608(e));
    }

    public static Material fromRawTexture(class_2960 texture) {
        return new Material(texture, texture, FullSprite::new);
    }

    private static class FullSprite
    extends class_1058 {
        private FullSprite(class_2960 location) {
            super(new class_1059(location), new class_1058.class_4727(location, 1, 1, class_1079.field_21768), 0, 1, 1, 0, 0, new class_1011(1, 1, false));
        }

        public float method_4580(double u) {
            return (float)u / 16.0f;
        }

        public float method_4570(double v) {
            return (float)v / 16.0f;
        }
    }
}

