/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.FluidStackHooks;
import net.creeperhost.polylib.client.model.Model3D;
import net.creeperhost.polylib.client.render.RenderResizableCuboid;
import net.minecraft.class_1159;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_757;

public class RenderUtils {
    public static final int FULL_LIGHT = 0xF000F0;

    public static void renderObject(Model3D object, class_4587 matrix, class_4588 buffer, int argb, int light) {
        if (object != null) {
            RenderResizableCuboid.INSTANCE.renderCube(object, matrix, buffer, argb, light);
        }
    }

    public static int calculateGlowLight(int light, FluidStack fluid) {
        return fluid.isEmpty() ? light : RenderUtils.calculateGlowLight(light, 1);
    }

    public static int calculateGlowLight(int light, int glow) {
        return 0xF000F0;
    }

    public static int getColorARGB(FluidStack fluidStack, float fluidScale) {
        if (fluidStack.isEmpty()) {
            return -1;
        }
        return RenderUtils.getColorARGB(fluidStack);
    }

    private static int getColorARGB(FluidStack fluidStack) {
        return FluidStackHooks.getColor((FluidStack)fluidStack);
    }

    public static float getRed(int color) {
        return (float)(color >> 16 & 0xFF) / 255.0f;
    }

    public static float getGreen(int color) {
        return (float)(color >> 8 & 0xFF) / 255.0f;
    }

    public static float getBlue(int color) {
        return (float)(color & 0xFF) / 255.0f;
    }

    public static float getAlpha(int color) {
        return (float)(color >> 24 & 0xFF) / 255.0f;
    }

    public static void renderTooltipBox(class_4587 poseStack, int x, int y, int width, int height) {
        poseStack.method_22903();
        class_289 tesselator = class_289.method_1348();
        class_287 bufferBuilder = tesselator.method_1349();
        RenderSystem.setShader(class_757::method_34540);
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        class_1159 matrix4f = poseStack.method_23760().method_23761();
        RenderUtils.fillGradient(matrix4f, bufferBuilder, x - 3, y - 4, x + width + 3, y - 3, 400, -267386864, -267386864);
        RenderUtils.fillGradient(matrix4f, bufferBuilder, x - 3, y + height + 3, x + width + 3, y + height + 4, 400, -267386864, -267386864);
        RenderUtils.fillGradient(matrix4f, bufferBuilder, x - 3, y - 3, x + width + 3, y + height + 3, 400, -267386864, -267386864);
        RenderUtils.fillGradient(matrix4f, bufferBuilder, x - 4, y - 3, x - 3, y + height + 3, 400, -267386864, -267386864);
        RenderUtils.fillGradient(matrix4f, bufferBuilder, x + width + 3, y - 3, x + width + 4, y + height + 3, 400, -267386864, -267386864);
        RenderUtils.fillGradient(matrix4f, bufferBuilder, x - 3, y - 3 + 1, x - 3 + 1, y + height + 3 - 1, 400, 0x505000FF, 1344798847);
        RenderUtils.fillGradient(matrix4f, bufferBuilder, x + width + 2, y - 3 + 1, x + width + 3, y + height + 3 - 1, 400, 0x505000FF, 1344798847);
        RenderUtils.fillGradient(matrix4f, bufferBuilder, x - 3, y - 3, x + width + 3, y - 3 + 1, 400, 0x505000FF, 0x505000FF);
        RenderUtils.fillGradient(matrix4f, bufferBuilder, x - 3, y + height + 2, x + width + 3, y + height + 3, 400, 1344798847, 1344798847);
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
        RenderSystem.disableBlend();
        RenderSystem.enableTexture();
        class_4597.class_4598 bufferSource = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
        poseStack.method_22904(0.0, 0.0, 400.0);
        bufferSource.method_22993();
        poseStack.method_22909();
    }

    public static void fillGradient(class_1159 matrix4f, class_287 bufferBuilder, int i, int j, int k, int l, int m, int n, int o) {
        float f = (float)(n >> 24 & 0xFF) / 255.0f;
        float g = (float)(n >> 16 & 0xFF) / 255.0f;
        float h = (float)(n >> 8 & 0xFF) / 255.0f;
        float p = (float)(n & 0xFF) / 255.0f;
        float q = (float)(o >> 24 & 0xFF) / 255.0f;
        float r = (float)(o >> 16 & 0xFF) / 255.0f;
        float s = (float)(o >> 8 & 0xFF) / 255.0f;
        float t = (float)(o & 0xFF) / 255.0f;
        bufferBuilder.method_22918(matrix4f, (float)k, (float)j, (float)m).method_22915(g, h, p, f).method_1344();
        bufferBuilder.method_22918(matrix4f, (float)i, (float)j, (float)m).method_22915(g, h, p, f).method_1344();
        bufferBuilder.method_22918(matrix4f, (float)i, (float)l, (float)m).method_22915(r, s, t, q).method_1344();
        bufferBuilder.method_22918(matrix4f, (float)k, (float)l, (float)m).method_22915(r, s, t, q).method_1344();
    }
}

