/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.fabric.inventory.fluid;

import com.google.common.collect.Iterables;
import dev.architectury.fluid.FluidStack;
import net.creeperhost.polylib.inventory.fluid.PolyFluidHandler;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_3611;
import org.jetbrains.annotations.NotNull;

public class FabricPolyFluidWrapper
implements PolyFluidHandler {
    private final Storage<FluidVariant> storage;

    public FabricPolyFluidWrapper(Storage<FluidVariant> storage) {
        this.storage = storage;
    }

    @Override
    public int getTanks() {
        return Iterables.size(this.storage);
    }

    @Override
    @NotNull
    public FluidStack getFluidInTank(int tank) {
        StorageView view = (StorageView)Iterables.get(this.storage, (int)tank);
        return FluidStack.create((class_3611)((FluidVariant)view.getResource()).getFluid(), (long)view.getAmount());
    }

    @Override
    public long getTankCapacity(int tank) {
        StorageView view = (StorageView)Iterables.get(this.storage, (int)tank);
        return view.getCapacity();
    }

    @Override
    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        StorageView view = (StorageView)Iterables.get(this.storage, (int)tank);
        return view.isResourceBlank() || ((FluidVariant)view.getResource()).getFluid().method_15780(stack.getFluid());
    }

    @Override
    public long fill(FluidStack resource, boolean simulate) {
        long inserted;
        if (!this.storage.supportsInsertion()) {
            return 0L;
        }
        try (Transaction transaction = Transaction.openOuter();){
            inserted = this.storage.insert((Object)FluidVariant.of((class_3611)resource.getFluid()), resource.getAmount(), (TransactionContext)transaction);
            if (!simulate) {
                transaction.commit();
            }
        }
        return inserted;
    }

    @Override
    @NotNull
    public FluidStack drain(long maxDrain, boolean simulate) {
        if (!this.storage.supportsExtraction()) {
            return FluidStack.empty();
        }
        for (StorageView view : this.storage) {
            if (view.isResourceBlank() || view.getAmount() <= 0L) continue;
            return this.drain((FluidVariant)view.getResource(), maxDrain, simulate);
        }
        return FluidStack.empty();
    }

    @Override
    @NotNull
    public FluidStack drain(FluidStack resource, boolean simulate) {
        if (!this.storage.supportsExtraction()) {
            return FluidStack.empty();
        }
        return this.drain(FluidVariant.of((class_3611)resource.getFluid()), resource.getAmount(), simulate);
    }

    @NotNull
    private FluidStack drain(FluidVariant variant, long amount, boolean simulate) {
        try (Transaction transaction = Transaction.openOuter();){
            long extracted = this.storage.extract((Object)variant, amount, (TransactionContext)transaction);
            if (!simulate) {
                transaction.commit();
            }
            FluidStack fluidStack = extracted > 0L ? FluidStack.create((class_3611)variant.getFluid(), (long)extracted) : FluidStack.empty();
            return fluidStack;
        }
    }

    @Override
    public void _setFluidInTank(int tank, FluidStack fluidStack) {
    }
}

