/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.inventory.fluid;

import dev.architectury.fluid.FluidStack;
import net.creeperhost.polylib.PolyLibPlatform;
import net.creeperhost.polylib.inventory.fluid.PolyFluidHandler;
import net.creeperhost.polylib.inventory.fluid.PolyFluidHandlerItem;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import org.jetbrains.annotations.Nullable;

public interface FluidManager {
    public static final long BUCKET = FluidStack.bucketAmount();
    public static final long MILLIBUCKET = BUCKET / 1000L;

    default public long convert(long milliBuckets) {
        return milliBuckets * MILLIBUCKET;
    }

    @Nullable
    public PolyFluidHandler getBlockFluidHandler(class_2586 var1, @Nullable class_2350 var2);

    @Nullable
    public PolyFluidHandlerItem getItemFluidHandler(class_1799 var1);

    public static PolyFluidHandler getHandler(class_2586 tile, @Nullable class_2350 side) {
        return PolyLibPlatform.getFluidManager().getBlockFluidHandler(tile, side);
    }

    public static PolyFluidHandlerItem getHandler(class_1799 stack) {
        return PolyLibPlatform.getFluidManager().getItemFluidHandler(stack);
    }

    public static long insertFluid(class_2586 tile, FluidStack fluidStack, class_2350 side, boolean simulate) {
        PolyFluidHandler handler = FluidManager.getHandler(tile, side);
        if (handler == null) {
            return 0L;
        }
        return handler.fill(fluidStack, simulate);
    }

    public static FluidStack extractFluid(class_2586 tile, FluidStack fluidStack, class_2350 side, boolean simulate) {
        PolyFluidHandler handler = FluidManager.getHandler(tile, side);
        if (handler == null) {
            return FluidStack.empty();
        }
        return handler.drain(fluidStack, simulate);
    }

    public static FluidStack transferFluid(@Nullable PolyFluidHandler source, @Nullable PolyFluidHandler target) {
        if (source == null || target == null) {
            return FluidStack.empty();
        }
        FluidStack available = source.drain(Integer.MAX_VALUE, true);
        if (available.isEmpty()) {
            return FluidStack.empty();
        }
        long canFill = target.fill(available, true);
        if (canFill <= 0L) {
            return FluidStack.empty();
        }
        FluidStack canDrain = source.drain(canFill, true);
        if (canDrain.isEmpty()) {
            return FluidStack.empty();
        }
        if (canDrain.getAmount() != target.fill(canDrain, true)) {
            return FluidStack.empty();
        }
        return source.drain(target.fill(canDrain, false), false);
    }

    public static FluidStack transferFluid(class_2586 source, class_2350 sourceSide, @Nullable PolyFluidHandler target) {
        PolyFluidHandler sourceHandler = FluidManager.getHandler(source, sourceSide);
        return FluidManager.transferFluid(sourceHandler, target);
    }

    public static FluidStack transferFluid(@Nullable PolyFluidHandler source, class_2586 target, class_2350 targetSide) {
        PolyFluidHandler targetHandler = FluidManager.getHandler(target, targetSide);
        return FluidManager.transferFluid(source, targetHandler);
    }

    public static FluidStack transferFluid(class_2586 source, class_2350 sourceSide, class_2586 target, class_2350 targetSide) {
        PolyFluidHandler sourceHandler = FluidManager.getHandler(source, sourceSide);
        PolyFluidHandler targetHandler = FluidManager.getHandler(target, targetSide);
        return FluidManager.transferFluid(sourceHandler, targetHandler);
    }

    public static long transferFluid(FluidStack fluidStack, PolyFluidHandler source, PolyFluidHandler target) {
        long canFill = target.fill(fluidStack, true);
        return target.fill(source.drain(fluidStack.copyWithAmount(canFill), false), false);
    }

    public static long transferFluid(FluidStack fluidStack, class_2586 source, class_2350 sourceSide, PolyFluidHandler target) {
        PolyFluidHandler handler = FluidManager.getHandler(source, sourceSide);
        return handler == null ? 0L : FluidManager.transferFluid(fluidStack, handler, target);
    }

    public static long transferFluid(FluidStack fluidStack, PolyFluidHandler source, class_2586 target, class_2350 targetSide) {
        PolyFluidHandler handler = FluidManager.getHandler(target, targetSide);
        return handler == null ? 0L : FluidManager.transferFluid(fluidStack, source, handler);
    }

    public static long transferFluid(FluidStack fluidStack, class_2586 source, class_2350 sourceSide, class_2586 target, class_2350 targetSide) {
        PolyFluidHandler sourceStorage = FluidManager.getHandler(source, sourceSide);
        if (sourceStorage == null) {
            return 0L;
        }
        PolyFluidHandler targetHandler = FluidManager.getHandler(target, targetSide);
        return targetHandler == null ? 0L : FluidManager.transferFluid(fluidStack, sourceStorage, targetHandler);
    }

    public static boolean isFluidItem(class_1799 stack) {
        return FluidManager.getHandler(stack) != null;
    }

    public static boolean isFluidBlock(class_2586 tile, @Nullable class_2350 side) {
        return FluidManager.getHandler(tile, side) != null;
    }
}

