/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.polymorph.common;

import com.illusivesoulworks.polymorph.common.network.client.CPacketBlockEntityListener;
import com.illusivesoulworks.polymorph.common.network.client.CPacketPersistentRecipeSelection;
import com.illusivesoulworks.polymorph.common.network.client.CPacketPlayerRecipeSelection;
import com.illusivesoulworks.polymorph.common.network.client.CPacketStackRecipeSelection;
import com.illusivesoulworks.polymorph.common.network.server.SPacketBlockEntityRecipeSync;
import com.illusivesoulworks.polymorph.common.network.server.SPacketHighlightRecipe;
import com.illusivesoulworks.polymorph.common.network.server.SPacketPlayerRecipeSync;
import com.illusivesoulworks.polymorph.common.network.server.SPacketRecipesList;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class PolymorphFabricNetwork {
    public static final class_2960 PLAYER_SELECT = new class_2960("polymorph", "player_select");
    public static final class_2960 PERSISTENT_SELECT = new class_2960("polymorph", "persistent_select");
    public static final class_2960 STACK_SELECT = new class_2960("polymorph", "stack_select");
    public static final class_2960 RECIPES_LIST = new class_2960("polymorph", "recipes_list");
    public static final class_2960 HIGHLIGHT_RECIPE = new class_2960("polymorph", "highlight_recipe");
    public static final class_2960 RECIPE_SYNC = new class_2960("polymorph", "recipe_sync");
    public static final class_2960 BLOCK_ENTITY_SYNC = new class_2960("polymorph", "block_entity_sync");
    public static final class_2960 BLOCK_ENTITY_LISTENER = new class_2960("polymorph", "block_entity_listener");

    public static void setup() {
        PolymorphFabricNetwork.registerServerReceiver(PLAYER_SELECT, CPacketPlayerRecipeSelection::decode, CPacketPlayerRecipeSelection::handle);
        PolymorphFabricNetwork.registerServerReceiver(PERSISTENT_SELECT, CPacketPersistentRecipeSelection::decode, CPacketPersistentRecipeSelection::handle);
        PolymorphFabricNetwork.registerServerReceiver(STACK_SELECT, CPacketStackRecipeSelection::decode, CPacketStackRecipeSelection::handle);
        PolymorphFabricNetwork.registerServerReceiver(BLOCK_ENTITY_LISTENER, CPacketBlockEntityListener::decode, CPacketBlockEntityListener::handle);
    }

    public static void clientSetup() {
        PolymorphFabricNetwork.registerClientReceiver(HIGHLIGHT_RECIPE, SPacketHighlightRecipe::decode, SPacketHighlightRecipe::handle);
        PolymorphFabricNetwork.registerClientReceiver(RECIPE_SYNC, SPacketPlayerRecipeSync::decode, SPacketPlayerRecipeSync::handle);
        PolymorphFabricNetwork.registerClientReceiver(RECIPES_LIST, SPacketRecipesList::decode, SPacketRecipesList::handle);
        PolymorphFabricNetwork.registerClientReceiver(BLOCK_ENTITY_SYNC, SPacketBlockEntityRecipeSync::decode, SPacketBlockEntityRecipeSync::handle);
    }

    private static <M> void registerServerReceiver(class_2960 resourceLocation, Function<class_2540, M> decoder, BiConsumer<M, class_3222> handler) {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)resourceLocation, (server, player, listener, buf, responseSender) -> {
            Object packet = decoder.apply(buf);
            server.execute(() -> handler.accept(packet, player));
        });
    }

    private static <M> void registerClientReceiver(class_2960 resourceLocation, Function<class_2540, M> decoder, Consumer<M> handler) {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)resourceLocation, (client, listener, buf, responseSender) -> {
            Object packet = decoder.apply(buf);
            client.execute(() -> handler.accept(packet));
        });
    }
}

