/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.ponderjs;

import com.almostreliable.ponderjs.PonderJS;
import com.almostreliable.ponderjs.mixin.PonderTagRegistryAccessor;
import com.almostreliable.ponderjs.util.PonderPlatform;
import com.google.common.collect.Multimap;
import com.simibubi.create.foundation.ponder.PonderRegistry;
import com.simibubi.create.foundation.ponder.PonderTag;
import com.simibubi.create.foundation.ponder.PonderTagRegistry;
import dev.latvian.mods.kubejs.event.EventJS;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2960;

public class PonderItemTagEventJS
extends EventJS {
    public void createTag(String id, class_1799 displayItem, String title, String description, @Nullable class_1856 ingredient) {
        PonderJS.getTagByName(id).ifPresent(tag -> {
            throw new IllegalArgumentException("Tag " + id + " already exists");
        });
        class_2960 idWithNamespace = PonderJS.appendKubeToId(id);
        PonderTag ponderTag = new PonderTag(idWithNamespace).item((class_1935)displayItem.method_7909()).defaultLang(title, description);
        PonderRegistry.TAGS.listTag(ponderTag);
        if (ingredient != null) {
            this.add(ponderTag, ingredient);
        }
        PonderJS.NAMESPACES.add(idWithNamespace.method_12836());
    }

    public void createTag(String id, class_1799 displayItem, String title, String description) {
        this.createTag(id, displayItem, title, description, null);
    }

    public void removeTag(PonderTag ... tags) {
        for (PonderTag tag : tags) {
            Set items = PonderRegistry.TAGS.getItems(tag);
            PonderRegistry.TAGS.getListedTags().remove(tag);
            this.remove(tag, items);
        }
    }

    public void add(PonderTag tag, class_1856 ingredient) {
        if (ingredient.method_8103()) {
            return;
        }
        PonderTagRegistry.TagBuilder tagBuilder = PonderRegistry.TAGS.forTag(tag);
        for (class_1799 item : ingredient.method_8105()) {
            tagBuilder.add((class_1935)item.method_7909());
        }
    }

    public void remove(PonderTag tag, class_1856 ingredient) {
        if (ingredient.method_8103()) {
            return;
        }
        Set<class_2960> ids = Arrays.stream(ingredient.method_8105()).map(class_1799::method_7909).map(PonderPlatform::getItemName).collect(Collectors.toSet());
        this.remove(tag, ids);
    }

    private void remove(PonderTag tag, Set<class_2960> items) {
        Multimap<class_2960, PonderTag> tagMap = ((PonderTagRegistryAccessor)PonderRegistry.TAGS).getTags();
        for (class_2960 item : items) {
            Collection tagsForItem = tagMap.get((Object)item);
            if (!tagsForItem.remove(tag)) continue;
            ConsoleJS.CLIENT.info((Object)("Removed ponder tag " + tag.getId() + " from item " + item));
        }
    }
}

