/*
 * Decompiled with CFR 0.152.
 */
package com.hugman.promenade;

import com.google.common.reflect.Reflection;
import com.hugman.dawn.api.object.ModData;
import com.hugman.promenade.compat.init.ColumnsBundle;
import com.hugman.promenade.config.PromenadeConfig;
import com.hugman.promenade.init.AmaranthBundle;
import com.hugman.promenade.init.AnimalBundle;
import com.hugman.promenade.init.AutumnBundle;
import com.hugman.promenade.init.CherryBundle;
import com.hugman.promenade.init.CommonBundle;
import com.hugman.promenade.init.FoodBundle;
import com.hugman.promenade.init.GalleryBundle;
import com.hugman.promenade.init.MonsterBundle;
import com.hugman.promenade.init.MushroomBundle;
import com.hugman.promenade.init.OreBundle;
import com.hugman.promenade.init.PalmBundle;
import com.hugman.promenade.init.TallerNetherForestBundle;
import com.hugman.promenade.init.VanillaPilesBundle;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.ConfigSerializer;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import me.shedaniel.autoconfig.serializer.PartitioningSerializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Promenade
implements ModInitializer {
    public static final ModData MOD_DATA = new ModData("promenade");
    public static final Logger LOGGER = LogManager.getLogger();
    public static final PromenadeConfig CONFIG = (PromenadeConfig)AutoConfig.register(PromenadeConfig.class, (ConfigSerializer.Factory)PartitioningSerializer.wrap(GsonConfigSerializer::new)).getConfig();

    public void onInitialize() {
        MOD_DATA.addOldName("wild_explorer");
        Promenade.initBundles();
        MOD_DATA.registerCreators();
        Promenade.postInitBundles();
    }

    public static void initBundle(Class<?> clazz) {
        Reflection.initialize((Class[])new Class[]{clazz});
        for (Class<?> clazz2 : clazz.getClasses()) {
            Promenade.initBundle(clazz2);
        }
    }

    public static void initBundles() {
        Promenade.initBundle(CommonBundle.class);
        Promenade.initBundle(OreBundle.class);
        Promenade.initBundle(VanillaPilesBundle.class);
        Promenade.initBundle(MushroomBundle.class);
        Promenade.initBundle(AnimalBundle.class);
        Promenade.initBundle(MonsterBundle.class);
        Promenade.initBundle(AutumnBundle.class);
        Promenade.initBundle(CherryBundle.class);
        Promenade.initBundle(FoodBundle.class);
        Promenade.initBundle(PalmBundle.class);
        Promenade.initBundle(TallerNetherForestBundle.class);
        Promenade.initBundle(GalleryBundle.class);
        Promenade.initBundle(AmaranthBundle.class);
        if (FabricLoader.getInstance().isModLoaded("columns")) {
            Promenade.initBundle(ColumnsBundle.class);
            LOGGER.info("Initialized Columns compatibility");
        }
    }

    public static void postInitBundles() {
        AutumnBundle.addWanderingSales();
        CherryBundle.addWanderingSales();
        PalmBundle.addWanderingSales();
        AmaranthBundle.addToGen();
        AnimalBundle.addToGen();
        AutumnBundle.addToGen();
        CherryBundle.addToGen();
        FoodBundle.addToGen();
        GalleryBundle.addToGen();
        MonsterBundle.addToGen();
        OreBundle.addToGen();
        PalmBundle.addToGen();
        TallerNetherForestBundle.addToGen();
    }
}

