/*
 * Decompiled with CFR 0.152.
 */
package com.hugman.promenade.object.entity;

import com.hugman.promenade.init.AnimalBundle;
import com.hugman.promenade.init.data.PromenadeTags;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1353;
import net.minecraft.class_1361;
import net.minecraft.class_1374;
import net.minecraft.class_1376;
import net.minecraft.class_1391;
import net.minecraft.class_1394;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7;

public class DuckEntity
extends class_1429 {
    private static final class_2940<Integer> DUCK_TYPE = class_2945.method_12791(DuckEntity.class, (class_2941)class_2943.field_13327);
    private static final class_1856 TEMPTATION_ITEMS = class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8317, class_1802.field_8188, class_1802.field_8706, class_1802.field_8309});
    public static final String TYPE_KEY = "Type";
    public float wingRotation;
    public float destPos;
    public float oFlapSpeed;
    public float oFlap;
    public float wingRotDelta = 1.0f;

    public DuckEntity(class_1299<? extends DuckEntity> type, class_1937 worldIn) {
        super(type, worldIn);
        this.method_5941(class_7.field_18, 0.0f);
    }

    public static class_5132.class_5133 createDuckAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 4.0).method_26868(class_5134.field_23719, 0.25);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(DUCK_TYPE, (Object)0);
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityNbt) {
        class_6880 biomeEntry = world.method_23753(this.method_24515());
        Type type = Type.fromBiome((class_6880<class_1959>)biomeEntry);
        if (entityData instanceof DuckData) {
            type = ((DuckData)((Object)entityData)).type;
        } else {
            entityData = new DuckData(type);
        }
        this.setVariant(type);
        return super.method_5943(world, difficulty, spawnReason, entityData, entityNbt);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new class_1374((class_1314)this, 1.4));
        this.field_6201.method_6277(2, (class_1352)new class_1341((class_1429)this, 1.0));
        this.field_6201.method_6277(3, (class_1352)new class_1391((class_1314)this, 1.0, TEMPTATION_ITEMS, false));
        this.field_6201.method_6277(4, (class_1352)new class_1353((class_1429)this, 1.1));
        this.field_6201.method_6277(5, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(6, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
        this.field_6201.method_6277(7, (class_1352)new class_1376((class_1308)this));
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10582(TYPE_KEY, this.getVariant().getName());
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.setVariant(Type.byName(compound.method_10558(TYPE_KEY)));
    }

    protected float method_18394(class_4050 pose, class_4048 size) {
        return this.method_6109() ? size.field_18068 * 0.85f : size.field_18068 * 0.92f;
    }

    public void method_6007() {
        super.method_6007();
        boolean isAirBorne = !this.field_5952 && !this.method_5799();
        this.oFlap = this.wingRotation;
        this.oFlapSpeed = this.destPos;
        this.destPos = (float)((double)this.destPos + (double)(!isAirBorne ? -1 : 4) * 0.3);
        this.destPos = class_3532.method_15363((float)this.destPos, (float)0.0f, (float)1.0f);
        if (isAirBorne && this.wingRotDelta < 0.55f) {
            this.wingRotDelta = 0.55f;
        }
        this.wingRotDelta = (float)((double)this.wingRotDelta * 0.9);
        class_243 vec3d = this.method_18798();
        if (isAirBorne && vec3d.field_1351 < 0.0) {
            this.method_18799(vec3d.method_18805(1.0, 0.75, 1.0));
        }
        this.wingRotation += this.wingRotDelta * 2.0f;
    }

    public boolean method_26319(class_3610 fluidState) {
        return fluidState.method_39360((class_3611)class_3612.field_15910);
    }

    public void method_6091(class_243 movementInput) {
        if (this.method_6034() && this.method_5799()) {
            this.method_5724(this.method_6029(), movementInput);
            this.method_5784(class_1313.field_6308, this.method_18798());
            this.method_18799(this.method_18798().method_1021(0.9));
            if (this.method_5968() == null) {
                this.method_18799(this.method_18798().method_1031(0.0, -0.005, 0.0));
            }
        } else {
            super.method_6091(movementInput);
        }
    }

    public boolean method_5747(float distance, float multiplier, class_1282 damageSource) {
        return false;
    }

    protected class_3414 method_5994() {
        return AnimalBundle.DUCK_AMBIENT_SOUND.getSound();
    }

    protected class_3414 method_6011(class_1282 source) {
        return AnimalBundle.DUCK_HURT_SOUND.getSound();
    }

    protected class_3414 method_6002() {
        return AnimalBundle.DUCK_DEATH_SOUND.getSound();
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783(AnimalBundle.DUCK_STEP_SOUND.getSound(), 0.15f, 1.0f);
    }

    @Nullable
    public DuckEntity createChild(class_3218 serverWorld, class_1296 mate) {
        DuckEntity child = (DuckEntity)AnimalBundle.DUCK.method_5883(this.field_6002);
        if (child != null) {
            child.setVariant(this.field_5974.method_43057() < 0.5f ? ((DuckEntity)mate).getVariant() : this.getVariant());
        }
        return child;
    }

    public boolean method_6481(class_1799 stack) {
        return TEMPTATION_ITEMS.method_8093(stack);
    }

    public void method_5865(class_1297 entity) {
        super.method_5865(entity);
        float f = class_3532.method_15374((float)(this.field_6283 * ((float)Math.PI / 180)));
        float f1 = class_3532.method_15362((float)(this.field_6283 * ((float)Math.PI / 180)));
        entity.method_30634(this.method_23317() + (double)(0.1f * f), this.method_23323(0.5) + entity.method_5678() + 0.0, this.method_23321() - (double)(0.1f * f1));
        if (entity instanceof class_1309) {
            ((class_1309)entity).field_6283 = this.field_6283;
        }
    }

    public Type getVariant() {
        return Type.fromId((Integer)this.field_6011.method_12789(DUCK_TYPE));
    }

    private void setVariant(Type type) {
        this.field_6011.method_12778(DUCK_TYPE, (Object)type.getIndex());
    }

    public static enum Type {
        PEKIN(0, "pekin", PromenadeTags.Biomes.PEKIN_DUCK_SPAWN),
        MALLARD(1, "mallard", PromenadeTags.Biomes.MALLARD_DUCK_SPAWN);

        private static final Type[] typeList;
        private static final Map<String, Type> TYPES_BY_NAME;
        private final int index;
        private final String name;
        private final class_6862<class_1959> spawnBiomes;

        private Type(int indexIn, String nameIn, class_6862<class_1959> spawnBiomes) {
            this.index = indexIn;
            this.name = nameIn;
            this.spawnBiomes = spawnBiomes;
        }

        public static Type byName(String name) {
            return TYPES_BY_NAME.getOrDefault(name, PEKIN);
        }

        public static Type fromId(int index) {
            if (index < 0 || index > typeList.length) {
                index = 0;
            }
            return typeList[index];
        }

        public static Type fromBiome(class_6880<class_1959> biome) {
            List<Type> shuffledList = Arrays.asList((Type[])typeList.clone());
            Collections.shuffle(shuffledList);
            for (Type type : shuffledList) {
                if (!biome.method_40220(type.getSpawnBiomes())) continue;
                return type;
            }
            return PEKIN;
        }

        public String getName() {
            return this.name;
        }

        public class_6862<class_1959> getSpawnBiomes() {
            return this.spawnBiomes;
        }

        public int getIndex() {
            return this.index;
        }

        static {
            typeList = (Type[])Arrays.stream(Type.values()).sorted(Comparator.comparingInt(Type::getIndex)).toArray(Type[]::new);
            TYPES_BY_NAME = Arrays.stream(Type.values()).collect(Collectors.toMap(Type::getName, type -> type));
        }
    }

    public static class DuckData
    extends class_1296.class_4697 {
        public final Type type;

        public DuckData(Type typeIn) {
            super(false);
            this.type = typeIn;
        }
    }
}

