/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.color;

import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamresourceful.resourcefullib.common.utils.Scheduling;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_2583;
import net.minecraft.class_5251;

public class Color {
    private static boolean rainbowInitialized = false;
    protected static final Map<String, Color> colorsWithNames = new HashMap<String, Color>();
    public static final Codec<Color> CODEC = Codec.PASSTHROUGH.comapFlatMap(Color::decodeColor, color -> new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)new JsonPrimitive((Number)color.value)));
    public static final Color DEFAULT = Color.defaultColor();
    public static final Color RAINBOW = Color.createRainbowColor();
    private int r;
    private int g;
    private int b;
    private final int a;
    private int value;
    private boolean defaultValue;
    private boolean isRainbow;
    private float[] rgbaValue;
    public static final Codec<Color> COLOR_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("r").orElse((Object)255).forGetter(Color::getIntRed), (App)Codec.INT.fieldOf("g").orElse((Object)255).forGetter(Color::getIntGreen), (App)Codec.INT.fieldOf("b").orElse((Object)255).forGetter(Color::getIntBlue), (App)Codec.INT.fieldOf("a").orElse((Object)255).forGetter(Color::getIntAlpha)).apply((Applicative)instance, Color::new));

    public Color(int value) {
        this.a = value >> 24 & 0xFF;
        this.r = value >> 16 & 0xFF;
        this.g = value >> 8 & 0xFF;
        this.b = value & 0xFF;
        this.value = value;
        this.updateFloats();
    }

    public Color(int r, int g, int b, int a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
        this.updateValue();
        this.updateFloats();
    }

    private static Color defaultColor() {
        Color color = new Color(0xFFFFFF);
        color.defaultValue = true;
        return color;
    }

    private static Color createRainbowColor() {
        Color color = new Color(0xFF0000);
        color.isRainbow = true;
        colorsWithNames.put("rainbow", color);
        return color;
    }

    public static Color createNamedColor(String name, int value) {
        Color color = new Color(value);
        colorsWithNames.putIfAbsent(name.toLowerCase(Locale.ENGLISH), color);
        return color;
    }

    public static Color parse(String color) {
        if (colorsWithNames.containsKey(color.toLowerCase())) {
            return colorsWithNames.get(color.toLowerCase());
        }
        return new Color(Color.parseColor(color));
    }

    public static int parseColor(String color) {
        Objects.requireNonNull(color);
        if (color.startsWith("0x") || color.startsWith("#")) {
            return Long.decode(color).intValue();
        }
        if (colorsWithNames.containsKey(color.toLowerCase())) {
            return colorsWithNames.get(color.toLowerCase()).getValue();
        }
        return 0;
    }

    private void updateFloats() {
        this.rgbaValue = new float[4];
        this.rgbaValue[0] = this.getFloatRed();
        this.rgbaValue[1] = this.getFloatGreen();
        this.rgbaValue[2] = this.getFloatBlue();
        this.rgbaValue[3] = this.getFloatAlpha();
    }

    private void updateValue() {
        this.value = this.a << 24 | this.r << 16 | this.g << 8 | this.b;
    }

    public float getFloatRed() {
        return (float)this.r / 255.0f;
    }

    public float getFloatGreen() {
        return (float)this.g / 255.0f;
    }

    public float getFloatBlue() {
        return (float)this.b / 255.0f;
    }

    public float getFloatAlpha() {
        return (float)this.a / 255.0f;
    }

    public int getIntRed() {
        return this.r;
    }

    public int getIntGreen() {
        return this.g;
    }

    public int getIntBlue() {
        return this.b;
    }

    public int getIntAlpha() {
        return this.a;
    }

    public class_5251 getTextColor() {
        return class_5251.method_27717((int)this.value);
    }

    public int getValue() {
        return this.value;
    }

    public boolean isDefault() {
        return this.defaultValue;
    }

    public boolean isRainbow() {
        return this.isRainbow;
    }

    public String toString() {
        if (this.isRainbow) {
            return "rainbow";
        }
        return String.format("#%x", this.value);
    }

    public float[] getRGBComponents(float[] compArray) {
        float[] f = compArray == null ? new float[4] : compArray;
        f[0] = this.rgbaValue[0];
        f[1] = this.rgbaValue[1];
        f[2] = this.rgbaValue[2];
        f[3] = this.rgbaValue[3];
        return f;
    }

    public class_2583 getAsStyle() {
        return class_2583.field_24360.method_27703(this.getTextColor());
    }

    public static DataResult<Color> decodeColor(Dynamic<?> dynamic) {
        if (dynamic.asNumber().result().isPresent()) {
            return DataResult.success((Object)new Color(dynamic.asInt(0xFFFFFF)));
        }
        if (dynamic.asString().result().isPresent()) {
            return DataResult.success((Object)Color.parse(dynamic.asString("WHITE")));
        }
        return COLOR_CODEC.parse(dynamic).result().map(DataResult::success).orElse(DataResult.error((String)"Color input not valid!"));
    }

    public static void initRainbow() {
        if (rainbowInitialized) {
            return;
        }
        rainbowInitialized = true;
        Scheduling.schedule(() -> {
            if (Color.RAINBOW.r > 0 && Color.RAINBOW.b == 0) {
                --Color.RAINBOW.r;
                ++Color.RAINBOW.g;
            }
            if (Color.RAINBOW.g > 0 && Color.RAINBOW.r == 0) {
                --Color.RAINBOW.g;
                ++Color.RAINBOW.b;
            }
            if (Color.RAINBOW.b > 0 && Color.RAINBOW.g == 0) {
                ++Color.RAINBOW.r;
                --Color.RAINBOW.b;
            }
            RAINBOW.updateValue();
            RAINBOW.updateFloats();
        }, 0L, 40L, TimeUnit.MILLISECONDS);
    }
}

