/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.registry;

import com.teamresourceful.resourcefullib.common.registry.Definition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public class SuppliedRegistry<K, T> {
    protected final Map<K, Supplier<? extends T>> needsRegistration = new HashMap<K, Supplier<? extends T>>();
    protected List<Definition<K, ? extends T>> registration = new ArrayList<Definition<K, ? extends T>>();
    protected final String modId;
    protected Function<K, T> registryGetter;
    protected boolean registered = false;

    public SuppliedRegistry(String modId) {
        this.modId = modId;
    }

    public static <K, T> SuppliedRegistry<K, T> of(String modId) {
        return new SuppliedRegistry<K, T>(modId);
    }

    public <O extends T> Definition<K, O> register(K id, Supplier<? extends O> supplier) {
        if (this.registered) {
            throw new RuntimeException("Cannot register after registration has occurred");
        }
        this.needsRegistration.put(id, supplier);
        Definition obj = new Definition(this, id);
        this.registration.add(obj);
        return obj;
    }

    public void startRegistration(BiConsumer<K, Supplier<? extends T>> registerer, Function<K, T> getter) {
        if (this.registered) {
            throw new RuntimeException("Cannot register again after registration has occurred once");
        }
        this.registryGetter = getter;
        this.needsRegistration.forEach(registerer);
        this.needsRegistration.clear();
        this.registered = true;
        this.registration = Collections.unmodifiableList(this.registration);
    }

    public List<Definition<K, ? extends T>> getRegistration() {
        return this.registration;
    }

    public boolean isFrozen() {
        return this.registered;
    }
}

