/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.revelationary;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.dafuqs.revelationary.Revelationary;
import de.dafuqs.revelationary.api.advancements.AdvancementHelper;
import de.dafuqs.revelationary.api.revelations.RevelationAware;
import de.dafuqs.revelationary.config.RevelationaryConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2248;
import net.minecraft.class_2259;
import net.minecraft.class_2378;
import net.minecraft.class_2477;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3545;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RevelationRegistry {
    private static final Map<class_2960, List<class_2680>> ADVANCEMENT_BLOCK_REGISTRY = new HashMap<class_2960, List<class_2680>>();
    private static final Map<class_2680, class_2960> BLOCK_ADVANCEMENT_REGISTRY = new HashMap<class_2680, class_2960>();
    private static final Map<class_2680, class_2680> BLOCK_STATE_REGISTRY = new HashMap<class_2680, class_2680>();
    private static final Map<class_2248, class_2248> BLOCK_REGISTRY = new HashMap<class_2248, class_2248>();
    private static final Map<class_2960, List<class_1792>> ADVANCEMENT_ITEM_REGISTRY = new HashMap<class_2960, List<class_1792>>();
    private static final Map<class_1792, class_2960> ITEM_ADVANCEMENT_REGISTRY = new HashMap<class_1792, class_2960>();
    private static final Map<class_1792, class_1792> ITEM_REGISTRY = new HashMap<class_1792, class_1792>();
    private static final Map<class_2248, class_5250> ALTERNATE_BLOCK_TRANSLATION_STRING_REGISTRY = new HashMap<class_2248, class_5250>();
    private static final Map<class_1792, class_5250> ALTERNATE_ITEM_TRANSLATION_STRING_REGISTRY = new HashMap<class_1792, class_5250>();
    private static final Set<RevelationAware> revelationAwares = new HashSet<RevelationAware>();

    public static class_5250 getTranslationString(class_1792 item) {
        if (ALTERNATE_ITEM_TRANSLATION_STRING_REGISTRY.containsKey(item)) {
            return ALTERNATE_ITEM_TRANSLATION_STRING_REGISTRY.get(item);
        }
        boolean isBlockItem = item instanceof class_1747;
        if (isBlockItem && !RevelationaryConfig.get().NameForUnrevealedBlocks.isEmpty()) {
            return class_2561.method_43471((String)RevelationaryConfig.get().NameForUnrevealedBlocks);
        }
        if (!isBlockItem && !RevelationaryConfig.get().NameForUnrevealedItems.isEmpty()) {
            return class_2561.method_43471((String)RevelationaryConfig.get().NameForUnrevealedItems);
        }
        if (RevelationaryConfig.get().UseTargetBlockOrItemNameInsteadOfScatter) {
            return class_2561.method_43471((String)ITEM_REGISTRY.get(item).method_7876());
        }
        return class_2561.method_43470((String)("\u00a7k" + class_2477.method_10517().method_4679(item.method_7876())));
    }

    public static class_5250 getTranslationString(class_2248 block) {
        if (ALTERNATE_BLOCK_TRANSLATION_STRING_REGISTRY.containsKey(block)) {
            return ALTERNATE_BLOCK_TRANSLATION_STRING_REGISTRY.get(block);
        }
        if (!RevelationaryConfig.get().NameForUnrevealedBlocks.isEmpty()) {
            return class_2561.method_43471((String)RevelationaryConfig.get().NameForUnrevealedBlocks);
        }
        if (RevelationaryConfig.get().UseTargetBlockOrItemNameInsteadOfScatter) {
            return BLOCK_REGISTRY.get(block).method_9518();
        }
        return class_2561.method_43470((String)("\u00a7k" + class_2477.method_10517().method_4679(block.method_9539())));
    }

    public static void clear() {
        ADVANCEMENT_BLOCK_REGISTRY.clear();
        ADVANCEMENT_ITEM_REGISTRY.clear();
        BLOCK_STATE_REGISTRY.clear();
        ITEM_REGISTRY.clear();
        ALTERNATE_BLOCK_TRANSLATION_STRING_REGISTRY.clear();
        ALTERNATE_ITEM_TRANSLATION_STRING_REGISTRY.clear();
    }

    public static void registerRevelationAware(RevelationAware revelationAware) {
        revelationAwares.add(revelationAware);
    }

    public static void addRevelationAwares() {
        for (RevelationAware revelationAware : revelationAwares) {
            class_3545<class_1792, class_5250> itemTranslation;
            class_3545<class_2248, class_5250> blockTranslation;
            class_2960 advancementIdentifier = revelationAware.getCloakAdvancementIdentifier();
            for (Map.Entry<class_2680, class_2680> states : revelationAware.getBlockStateCloaks().entrySet()) {
                RevelationRegistry.registerBlockState(advancementIdentifier, states.getKey(), states.getValue());
            }
            class_3545<class_1792, class_1792> item = revelationAware.getItemCloak();
            if (item != null) {
                RevelationRegistry.registerItem(advancementIdentifier, (class_1792)item.method_15442(), (class_1792)item.method_15441());
            }
            if ((blockTranslation = revelationAware.getCloakedBlockTranslation()) != null) {
                RevelationRegistry.registerBlockTranslation((class_2248)blockTranslation.method_15442(), (class_5250)blockTranslation.method_15441());
            }
            if ((itemTranslation = revelationAware.getCloakedItemTranslation()) == null) continue;
            RevelationRegistry.registerItemTranslation((class_1792)itemTranslation.method_15442(), (class_5250)itemTranslation.method_15441());
        }
    }

    public static void registerFromJson(JsonObject jsonObject) {
        class_5250 targetText;
        class_1792 sourceItem;
        class_2960 sourceId;
        class_2960 advancementIdentifier = class_2960.method_12829((String)class_3518.method_15265((JsonObject)jsonObject, (String)"advancement"));
        if (jsonObject.has("block_states")) {
            for (Map.Entry stateEntry : jsonObject.get("block_states").getAsJsonObject().entrySet()) {
                try {
                    class_2680 sourceBlockState = class_2259.method_41956((class_2378)class_2378.field_11146, (StringReader)new StringReader((String)stateEntry.getKey()), (boolean)true).comp_622();
                    class_2680 targetBlockState = class_2259.method_41956((class_2378)class_2378.field_11146, (StringReader)new StringReader(((JsonElement)stateEntry.getValue()).getAsString()), (boolean)true).comp_622();
                    RevelationRegistry.registerBlockState(advancementIdentifier, sourceBlockState, targetBlockState);
                }
                catch (Exception e) {
                    Revelationary.logError("Error parsing block state: " + e);
                }
            }
        }
        if (jsonObject.has("items")) {
            for (Map.Entry itemEntry : jsonObject.get("items").getAsJsonObject().entrySet()) {
                sourceId = class_2960.method_12829((String)((String)itemEntry.getKey()));
                class_2960 targetId = class_2960.method_12829((String)((JsonElement)itemEntry.getValue()).getAsString());
                sourceItem = (class_1792)class_2378.field_11142.method_10223(sourceId);
                class_1792 targetItem = (class_1792)class_2378.field_11142.method_10223(targetId);
                RevelationRegistry.registerItem(advancementIdentifier, sourceItem, targetItem);
            }
        }
        if (jsonObject.has("block_name_replacements")) {
            for (Map.Entry blockNameEntry : jsonObject.get("block_name_replacements").getAsJsonObject().entrySet()) {
                sourceId = class_2960.method_12829((String)((String)blockNameEntry.getKey()));
                targetText = class_2561.method_43471((String)((JsonElement)blockNameEntry.getValue()).getAsString());
                class_2248 sourceBlock = (class_2248)class_2378.field_11146.method_10223(sourceId);
                ALTERNATE_BLOCK_TRANSLATION_STRING_REGISTRY.put(sourceBlock, targetText);
                class_1792 blockItem = sourceBlock.method_8389();
                if (blockItem == null || blockItem == class_1802.field_8162) continue;
                ALTERNATE_ITEM_TRANSLATION_STRING_REGISTRY.put(blockItem, targetText);
            }
        }
        if (jsonObject.has("item_name_replacements")) {
            for (Map.Entry itemNameEntry : jsonObject.get("item_name_replacements").getAsJsonObject().entrySet()) {
                sourceId = class_2960.method_12829((String)((String)itemNameEntry.getKey()));
                targetText = class_2561.method_43471((String)((JsonElement)itemNameEntry.getValue()).getAsString());
                sourceItem = (class_1792)class_2378.field_11142.method_10223(sourceId);
                ALTERNATE_ITEM_TRANSLATION_STRING_REGISTRY.put(sourceItem, targetText);
            }
        }
    }

    private static void registerBlockState(class_2960 advancementIdentifier, class_2680 sourceBlockState, class_2680 targetBlockState) {
        class_1792 targetBlockItem;
        if (sourceBlockState.method_26215()) {
            Revelationary.logError("Trying to register invalid block cloak. Advancement: " + advancementIdentifier + " Source Block: " + class_2378.field_11146.method_10221((Object)sourceBlockState.method_26204()) + " Target Block: " + class_2378.field_11146.method_10221((Object)targetBlockState.method_26204()));
            return;
        }
        if (ADVANCEMENT_BLOCK_REGISTRY.containsKey(advancementIdentifier)) {
            List<class_2680> list = ADVANCEMENT_BLOCK_REGISTRY.get(advancementIdentifier);
            list.add(sourceBlockState);
        } else {
            ArrayList<class_2680> list = new ArrayList<class_2680>();
            list.add(sourceBlockState);
            ADVANCEMENT_BLOCK_REGISTRY.put(advancementIdentifier, list);
        }
        class_1792 sourceBlockItem = sourceBlockState.method_26204().method_8389();
        if (sourceBlockItem != class_1802.field_8162 && (targetBlockItem = targetBlockState.method_26204().method_8389()) != class_1802.field_8162) {
            RevelationRegistry.registerItem(advancementIdentifier, sourceBlockItem, targetBlockItem);
        }
        BLOCK_STATE_REGISTRY.put(sourceBlockState, targetBlockState);
        BLOCK_REGISTRY.putIfAbsent(sourceBlockState.method_26204(), targetBlockState.method_26204());
        BLOCK_ADVANCEMENT_REGISTRY.put(sourceBlockState, advancementIdentifier);
    }

    private static void registerBlockTranslation(class_2248 sourceBlock, class_5250 targetTranslation) {
        ALTERNATE_BLOCK_TRANSLATION_STRING_REGISTRY.put(sourceBlock, targetTranslation);
    }

    public static boolean hasCloak(class_2680 blockState) {
        return BLOCK_STATE_REGISTRY.containsKey(blockState);
    }

    public static boolean isVisibleTo(class_2680 state, class_1657 player) {
        return AdvancementHelper.hasAdvancement(player, BLOCK_ADVANCEMENT_REGISTRY.getOrDefault(state, null));
    }

    @NotNull
    public static Collection<class_2680> getRevealedBlockStates(class_2960 advancement) {
        ArrayList<class_2680> blockStates = new ArrayList<class_2680>();
        if (ADVANCEMENT_BLOCK_REGISTRY.containsKey(advancement)) {
            for (class_2680 entry : ADVANCEMENT_BLOCK_REGISTRY.get(advancement)) {
                if (!(entry instanceof class_2680)) continue;
                class_2680 blockState = entry;
                blockStates.add(blockState);
            }
        }
        return blockStates;
    }

    public static Map<class_2960, List<class_2680>> getBlockStateEntries() {
        return ADVANCEMENT_BLOCK_REGISTRY;
    }

    public static List<class_2680> getBlockStateEntries(class_2960 advancement) {
        return ADVANCEMENT_BLOCK_REGISTRY.getOrDefault(advancement, Collections.EMPTY_LIST);
    }

    public static List<class_2248> getBlockEntries() {
        ArrayList<class_2248> blocks = new ArrayList<class_2248>();
        for (List<class_2680> states : ADVANCEMENT_BLOCK_REGISTRY.values()) {
            for (class_2680 state : states) {
                class_2248 block = state.method_26204();
                if (blocks.contains(block)) continue;
                blocks.add(block);
            }
        }
        return blocks;
    }

    public static List<class_2248> getBlockEntries(class_2960 advancement) {
        if (ADVANCEMENT_BLOCK_REGISTRY.containsKey(advancement)) {
            List<class_2680> states = ADVANCEMENT_BLOCK_REGISTRY.get(advancement);
            ArrayList<class_2248> blocks = new ArrayList<class_2248>();
            for (class_2680 state : states) {
                class_2248 block = state.method_26204();
                if (blocks.contains(block)) continue;
                blocks.add(block);
            }
            return blocks;
        }
        return new ArrayList<class_2248>();
    }

    private static void registerItem(class_2960 advancementIdentifier, class_1792 sourceItem, class_1792 targetItem) {
        if (sourceItem == class_1802.field_8162 || targetItem == class_1802.field_8162) {
            Revelationary.logError("Trying to register invalid item cloak. Advancement: " + advancementIdentifier + " Source Item: " + class_2378.field_11142.method_10221((Object)sourceItem) + " Target Item: " + class_2378.field_11142.method_10221((Object)targetItem));
            return;
        }
        if (ADVANCEMENT_ITEM_REGISTRY.containsKey(advancementIdentifier)) {
            List<class_1792> list = ADVANCEMENT_ITEM_REGISTRY.get(advancementIdentifier);
            if (list.contains(sourceItem)) {
                return;
            }
            list.add(sourceItem);
        } else {
            ArrayList<class_1792> list = new ArrayList<class_1792>();
            list.add(sourceItem);
            ADVANCEMENT_ITEM_REGISTRY.put(advancementIdentifier, list);
        }
        ITEM_REGISTRY.put(sourceItem, targetItem);
        ITEM_ADVANCEMENT_REGISTRY.put(sourceItem, advancementIdentifier);
    }

    private static void registerItemTranslation(class_1792 sourceItem, class_5250 targetTranslation) {
        ALTERNATE_ITEM_TRANSLATION_STRING_REGISTRY.put(sourceItem, targetTranslation);
    }

    public static boolean hasCloak(class_1792 item) {
        return ITEM_REGISTRY.containsKey(item);
    }

    @Nullable
    public static class_1792 getCloak(class_1792 item) {
        return ITEM_REGISTRY.getOrDefault(item, null);
    }

    public static boolean isVisibleTo(class_1792 item, class_1657 player) {
        return AdvancementHelper.hasAdvancement(player, ITEM_ADVANCEMENT_REGISTRY.getOrDefault(item, null));
    }

    @Nullable
    public static class_2680 getCloak(class_2680 blockState) {
        return BLOCK_STATE_REGISTRY.getOrDefault(blockState, null);
    }

    @NotNull
    public static Collection<class_1792> getRevealedItems(class_2960 advancement) {
        ArrayList<class_1792> items = new ArrayList<class_1792>();
        if (ADVANCEMENT_ITEM_REGISTRY.containsKey(advancement)) {
            for (class_1792 entry : ADVANCEMENT_ITEM_REGISTRY.get(advancement)) {
                if (!(entry instanceof class_1792)) continue;
                class_1792 item = entry;
                items.add(item);
            }
        }
        return items;
    }

    public static Map<class_2960, List<class_1792>> getItemEntries() {
        return ADVANCEMENT_ITEM_REGISTRY;
    }

    public static List<class_1792> getItemEntries(class_2960 advancement) {
        return ADVANCEMENT_ITEM_REGISTRY.getOrDefault(advancement, Collections.EMPTY_LIST);
    }

    public static void write(class_2540 buf) {
        buf.writeInt(ADVANCEMENT_BLOCK_REGISTRY.size());
        for (Map.Entry<class_2960, List<class_2680>> entry : ADVANCEMENT_BLOCK_REGISTRY.entrySet()) {
            buf.method_10812(entry.getKey());
            buf.writeInt(entry.getValue().size());
            for (class_2680 class_26802 : entry.getValue()) {
                buf.method_10814(class_2259.method_9685((class_2680)class_26802));
                buf.method_10814(class_2259.method_9685((class_2680)BLOCK_STATE_REGISTRY.get(class_26802)));
            }
        }
        buf.writeInt(ADVANCEMENT_ITEM_REGISTRY.size());
        for (Map.Entry<class_2960, List<class_2680>> entry : ADVANCEMENT_ITEM_REGISTRY.entrySet()) {
            buf.method_10812(entry.getKey());
            buf.writeInt(entry.getValue().size());
            for (class_1792 class_17922 : entry.getValue()) {
                buf.method_10814(class_2378.field_11142.method_10221((Object)class_17922).toString());
                buf.method_10814(class_2378.field_11142.method_10221((Object)ITEM_REGISTRY.get(class_17922)).toString());
            }
        }
        buf.writeInt(ALTERNATE_BLOCK_TRANSLATION_STRING_REGISTRY.size());
        for (Map.Entry<class_2960, List<class_2680>> entry : ALTERNATE_BLOCK_TRANSLATION_STRING_REGISTRY.entrySet()) {
            buf.method_10812(class_2378.field_11146.method_10221((Object)((class_2248)entry.getKey())));
            buf.method_10805((class_2561)entry.getValue());
        }
        buf.writeInt(ALTERNATE_ITEM_TRANSLATION_STRING_REGISTRY.size());
        for (Map.Entry<class_2960, List<class_2680>> entry : ALTERNATE_ITEM_TRANSLATION_STRING_REGISTRY.entrySet()) {
            buf.method_10812(class_2378.field_11142.method_10221((Object)((class_1792)entry.getKey())));
            buf.method_10805((class_2561)entry.getValue());
        }
    }

    public static void fromPacket(class_2540 buf) throws CommandSyntaxException {
        RevelationRegistry.clear();
        RevelationRegistry.addRevelationAwares();
        int blockEntries = buf.readInt();
        for (int i = 0; i < blockEntries; ++i) {
            class_2960 advancementIdentifier = buf.method_10810();
            int blockStateCount = buf.readInt();
            for (int j = 0; j < blockStateCount; ++j) {
                class_2680 sourceState = class_2259.method_41957((class_2378)class_2378.field_11146, (String)buf.method_19772(), (boolean)true).comp_622();
                class_2680 targetState = class_2259.method_41957((class_2378)class_2378.field_11146, (String)buf.method_19772(), (boolean)true).comp_622();
                if (ADVANCEMENT_BLOCK_REGISTRY.containsKey(advancementIdentifier)) {
                    advancementStates = ADVANCEMENT_BLOCK_REGISTRY.get(advancementIdentifier);
                    advancementStates.add(sourceState);
                } else {
                    advancementStates = new ArrayList();
                    advancementStates.add(sourceState);
                    ADVANCEMENT_BLOCK_REGISTRY.put(advancementIdentifier, advancementStates);
                }
                BLOCK_ADVANCEMENT_REGISTRY.put(sourceState, advancementIdentifier);
                BLOCK_STATE_REGISTRY.put(sourceState, targetState);
                BLOCK_REGISTRY.putIfAbsent(sourceState.method_26204(), targetState.method_26204());
            }
        }
        int itemEntries = buf.readInt();
        for (int i = 0; i < itemEntries; ++i) {
            class_2960 advancementIdentifier = buf.method_10810();
            int itemCount = buf.readInt();
            for (int j = 0; j < itemCount; ++j) {
                class_2960 sourceId = class_2960.method_12829((String)buf.method_19772());
                class_2960 targetId = class_2960.method_12829((String)buf.method_19772());
                class_1792 sourceItem = (class_1792)class_2378.field_11142.method_10223(sourceId);
                class_1792 targetItem = (class_1792)class_2378.field_11142.method_10223(targetId);
                if (ADVANCEMENT_ITEM_REGISTRY.containsKey(advancementIdentifier)) {
                    advancementItems = ADVANCEMENT_ITEM_REGISTRY.get(advancementIdentifier);
                    advancementItems.add(sourceItem);
                } else {
                    advancementItems = new ArrayList();
                    advancementItems.add(sourceItem);
                    ADVANCEMENT_ITEM_REGISTRY.put(advancementIdentifier, advancementItems);
                }
                ITEM_ADVANCEMENT_REGISTRY.put(sourceItem, advancementIdentifier);
                ITEM_REGISTRY.put(sourceItem, targetItem);
            }
        }
        int blockTranslations = buf.readInt();
        for (int i = 0; i < blockTranslations; ++i) {
            class_2248 block = (class_2248)class_2378.field_11146.method_10223(buf.method_10810());
            class_5250 text = (class_5250)buf.method_10808();
            ALTERNATE_BLOCK_TRANSLATION_STRING_REGISTRY.put(block, text);
        }
        int itemTranslations = buf.readInt();
        for (int i = 0; i < itemTranslations; ++i) {
            class_1792 item = (class_1792)class_2378.field_11142.method_10223(buf.method_10810());
            class_5250 text = (class_5250)buf.method_10808();
            ALTERNATE_ITEM_TRANSLATION_STRING_REGISTRY.put(item, text);
        }
    }
}

