/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.rottencreatures.client.renderer.entity.layers;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1738;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4057;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_572;
import net.minecraft.class_918;
import org.jetbrains.annotations.Nullable;

public class MummyArmorLayer<T extends class_1309, M extends class_572<T>, A extends class_572<T>>
extends class_3887<T, M> {
    private static final Map<String, class_2960> ARMOR_LOCATION_CACHE = Maps.newHashMap();
    private final A innerModel;
    private final A outerModel;

    public MummyArmorLayer(class_3883<T, M> parent, A innerModel, A outerModel) {
        super(parent);
        this.innerModel = innerModel;
        this.outerModel = outerModel;
    }

    public void render(class_4587 matrices, class_4597 source, int light, T entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        this.renderArmorPiece(matrices, source, entity, class_1304.field_6174, light, this.getArmorModel(class_1304.field_6174));
        this.renderArmorPiece(matrices, source, entity, class_1304.field_6172, light, this.getArmorModel(class_1304.field_6172));
        this.renderArmorPiece(matrices, source, entity, class_1304.field_6166, light, this.getArmorModel(class_1304.field_6166));
        this.renderArmorPiece(matrices, source, entity, class_1304.field_6169, light, this.getArmorModel(class_1304.field_6169));
    }

    private void renderArmorPiece(class_4587 matrices, class_4597 source, T entity, class_1304 slot, int light, A model) {
        class_1738 item;
        class_1799 stack = entity.method_6118(slot);
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof class_1738 && (item = (class_1738)class_17922).method_7685() == slot) {
            ((class_572)this.method_17165()).method_2818(model);
            if (model == this.innerModel) {
                ((class_572)model).field_3397.field_3656 = 10.0f;
                ((class_572)model).field_3392.field_3656 = 10.0f;
                ((class_572)model).field_3391.field_3656 = -2.0f;
            } else {
                ((class_572)model).field_3397.field_3656 = 12.0f;
                ((class_572)model).field_3392.field_3656 = 12.0f;
            }
            this.setPartVisibility(model, slot);
            boolean useInnerModel = this.usesInnerModel(slot);
            boolean hasFoil = stack.method_7958();
            if (item instanceof class_4057) {
                class_4057 dye = (class_4057)item;
                int color = dye.method_7800(stack);
                float red = (float)(color >> 16 & 0xFF) / 255.0f;
                float green = (float)(color >> 8 & 0xFF) / 255.0f;
                float blue = (float)(color & 0xFF) / 255.0f;
                this.renderModel(matrices, source, light, item, hasFoil, model, useInnerModel, red, green, blue, null);
                this.renderModel(matrices, source, light, item, hasFoil, model, useInnerModel, 1.0f, 1.0f, 1.0f, "overlay");
            } else {
                this.renderModel(matrices, source, light, item, hasFoil, model, useInnerModel, 1.0f, 1.0f, 1.0f, null);
            }
        }
    }

    protected void setPartVisibility(A model, class_1304 slot) {
        model.method_2805(false);
        switch (slot) {
            case field_6169: {
                ((class_572)model).field_3398.field_3665 = true;
                ((class_572)model).field_3394.field_3665 = true;
                break;
            }
            case field_6174: {
                ((class_572)model).field_3391.field_3665 = true;
                ((class_572)model).field_3401.field_3665 = true;
                ((class_572)model).field_27433.field_3665 = true;
                break;
            }
            case field_6172: {
                ((class_572)model).field_3391.field_3665 = true;
                ((class_572)model).field_3392.field_3665 = true;
                ((class_572)model).field_3397.field_3665 = true;
                break;
            }
            case field_6166: {
                ((class_572)model).field_3392.field_3665 = true;
                ((class_572)model).field_3397.field_3665 = true;
            }
        }
    }

    private void renderModel(class_4587 matrices, class_4597 source, int light, class_1738 item, boolean hasFoil, A model, boolean useInnerModel, float red, float green, float blue, @Nullable String overlay) {
        class_4588 vertices = class_918.method_27952((class_4597)source, (class_1921)class_1921.method_25448((class_2960)this.getArmorLocation(item, useInnerModel, overlay)), (boolean)false, (boolean)hasFoil);
        model.method_2828(matrices, vertices, light, class_4608.field_21444, red, green, blue, 1.0f);
    }

    private A getArmorModel(class_1304 slot) {
        return this.usesInnerModel(slot) ? this.innerModel : this.outerModel;
    }

    private boolean usesInnerModel(class_1304 slot) {
        return slot == class_1304.field_6172;
    }

    private class_2960 getArmorLocation(class_1738 armor, boolean legs, @Nullable String overlay) {
        String location = "textures/models/armor/" + armor.method_7686().method_7694() + "_layer_" + (legs ? 2 : 1) + (String)(overlay == null ? "" : "_" + overlay) + ".png";
        return ARMOR_LOCATION_CACHE.computeIfAbsent(location, class_2960::new);
    }
}

