/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.satin.impl;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import ladysnake.satin.Satin;
import ladysnake.satin.api.managed.ManagedFramebuffer;
import ladysnake.satin.api.managed.ManagedShaderEffect;
import ladysnake.satin.api.managed.uniform.SamplerUniformV2;
import ladysnake.satin.api.util.ShaderPrograms;
import ladysnake.satin.impl.FramebufferWrapper;
import ladysnake.satin.impl.ManagedSamplerUniformV2;
import ladysnake.satin.impl.ManagedUniformBase;
import ladysnake.satin.impl.ResettableManagedShaderBase;
import ladysnake.satin.mixin.client.AccessiblePassesShaderEffect;
import net.minecraft.class_1044;
import net.minecraft.class_1159;
import net.minecraft.class_276;
import net.minecraft.class_279;
import net.minecraft.class_280;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import org.apiguardian.api.API;

public final class ResettableManagedShaderEffect
extends ResettableManagedShaderBase<class_279>
implements ManagedShaderEffect {
    private final Consumer<ManagedShaderEffect> initCallback;
    private final Map<String, FramebufferWrapper> managedTargets;
    private final Map<String, ManagedSamplerUniformV2> managedSamplers = new HashMap<String, ManagedSamplerUniformV2>();

    @API(status=API.Status.INTERNAL)
    public ResettableManagedShaderEffect(class_2960 location, Consumer<ManagedShaderEffect> initCallback) {
        super(location);
        this.initCallback = initCallback;
        this.managedTargets = new HashMap<String, FramebufferWrapper>();
    }

    @Override
    @Nullable
    public class_279 getShaderEffect() {
        return this.getShaderOrLog();
    }

    @Override
    public void initialize() throws IOException {
        super.initialize(class_310.method_1551().method_1478());
    }

    @Override
    protected class_279 parseShader(class_3300 resourceManager, class_310 mc, class_2960 location) throws IOException {
        return new class_279(mc.method_1531(), resourceManager, mc.method_1522(), location);
    }

    @Override
    public void setup(int windowWidth, int windowHeight) {
        Preconditions.checkNotNull((Object)((class_279)this.shader));
        ((class_279)this.shader).method_1259(windowWidth, windowHeight);
        for (ManagedUniformBase uniform : this.getManagedUniforms()) {
            this.setupUniform(uniform, (class_279)this.shader);
        }
        for (FramebufferWrapper buf : this.managedTargets.values()) {
            buf.findTarget((class_279)this.shader);
        }
        this.initCallback.accept(this);
    }

    @Override
    public void render(float tickDelta) {
        class_279 sg = this.getShaderEffect();
        if (sg != null) {
            RenderSystem.disableBlend();
            RenderSystem.disableDepthTest();
            RenderSystem.enableTexture();
            RenderSystem.resetTextureMatrix();
            sg.method_1258(tickDelta);
            class_310.method_1551().method_1522().method_1235(true);
            RenderSystem.disableBlend();
            RenderSystem.blendFunc((int)770, (int)771);
            RenderSystem.enableDepthTest();
        }
    }

    @Override
    public ManagedFramebuffer getTarget(String name) {
        return this.managedTargets.computeIfAbsent(name, n -> {
            FramebufferWrapper ret = new FramebufferWrapper((String)n);
            if (this.shader != null) {
                ret.findTarget((class_279)this.shader);
            }
            return ret;
        });
    }

    @Override
    public void setUniformValue(String uniformName, int value) {
        this.findUniform1i(uniformName).set(value);
    }

    @Override
    public void setUniformValue(String uniformName, int value0, int value1) {
        this.findUniform2i(uniformName).set(value0, value1);
    }

    @Override
    public void setUniformValue(String uniformName, int value0, int value1, int value2) {
        this.findUniform3i(uniformName).set(value0, value1, value2);
    }

    @Override
    public void setUniformValue(String uniformName, int value0, int value1, int value2, int value3) {
        this.findUniform4i(uniformName).set(value0, value1, value2, value3);
    }

    @Override
    public void setUniformValue(String uniformName, float value) {
        this.findUniform1f(uniformName).set(value);
    }

    @Override
    public void setUniformValue(String uniformName, float value0, float value1) {
        this.findUniform2f(uniformName).set(value0, value1);
    }

    @Override
    public void setUniformValue(String uniformName, float value0, float value1, float value2) {
        this.findUniform3f(uniformName).set(value0, value1, value2);
    }

    @Override
    public void setUniformValue(String uniformName, float value0, float value1, float value2, float value3) {
        this.findUniform4f(uniformName).set(value0, value1, value2, value3);
    }

    @Override
    public void setUniformValue(String uniformName, class_1159 value) {
        this.findUniformMat4(uniformName).set(value);
    }

    @Override
    public void setSamplerUniform(String samplerName, class_1044 texture) {
        this.findSampler(samplerName).set(texture);
    }

    @Override
    public void setSamplerUniform(String samplerName, class_276 textureFbo) {
        this.findSampler(samplerName).set(textureFbo);
    }

    @Override
    public void setSamplerUniform(String samplerName, int textureName) {
        this.findSampler(samplerName).set(textureName);
    }

    @Override
    public SamplerUniformV2 findSampler(String samplerName) {
        return this.manageUniform(this.managedSamplers, ManagedSamplerUniformV2::new, samplerName, "sampler");
    }

    @Override
    public void setupDynamicUniforms(Runnable dynamicSetBlock) {
        this.setupDynamicUniforms(0, dynamicSetBlock);
    }

    @Override
    public void setupDynamicUniforms(int index, Runnable dynamicSetBlock) {
        AccessiblePassesShaderEffect sg = (AccessiblePassesShaderEffect)this.getShaderEffect();
        if (sg != null) {
            class_280 sm = sg.getPasses().get(index).method_1295();
            ShaderPrograms.useShader(sm.method_1270());
            dynamicSetBlock.run();
            ShaderPrograms.useShader(0);
        }
    }

    @Override
    protected boolean setupUniform(ManagedUniformBase uniform, class_279 shader) {
        return uniform.findUniformTargets(((AccessiblePassesShaderEffect)shader).getPasses());
    }

    @Override
    protected void logInitError(IOException e) {
        Satin.LOGGER.error("Could not create screen shader {}", (Object)this.getLocation(), (Object)e);
    }

    @Nullable
    private class_279 getShaderOrLog() {
        if (!this.isInitialized() && !this.isErrored()) {
            this.initializeOrLog(class_310.method_1551().method_1478());
        }
        return (class_279)this.shader;
    }
}

