/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.client.scanning;

import com.google.common.base.Strings;
import com.mojang.blaze3d.systems.RenderSystem;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import li.cil.scannable.api.API;
import li.cil.scannable.api.prefab.AbstractScanResultProvider;
import li.cil.scannable.api.scanning.BlockScannerModule;
import li.cil.scannable.api.scanning.ScanResult;
import li.cil.scannable.api.scanning.ScanResultRenderContext;
import li.cil.scannable.api.scanning.ScannerModule;
import li.cil.scannable.client.ClientConfig;
import li.cil.scannable.client.shader.Shaders;
import li.cil.scannable.common.item.ScannerModuleItem;
import li.cil.scannable.common.scanning.filter.IgnoredBlocks;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1159;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2826;
import net.minecraft.class_2841;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_4076;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4668;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5944;
import net.minecraft.class_6862;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Environment(value=EnvType.CLIENT)
public final class ScanResultProviderBlock
extends AbstractScanResultProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int MAX_RESULTS_PER_BLOCK = 8192;
    private static final int DEFAULT_COLOR = 0x4466CC;
    private final List<ScanFilterLayer> scanFilterLayers = new ArrayList<ScanFilterLayer>();
    private final List<ChunkSectionPos> pendingChunkSections = new ArrayList<ChunkSectionPos>();
    private int currentChunkSection;
    private int chunkSectionsPerTick;
    private final Map<class_2248, Map<class_2338, BlockScanResult>> resultClusters = new HashMap<class_2248, Map<class_2338, BlockScanResult>>();
    private final List<BlockScanResult> results = new ArrayList<BlockScanResult>();
    private long renderStartTime;

    @Override
    public void initialize(class_1657 player, Collection<class_1799> modules, class_243 center, float radius, int scanTicks) {
        super.initialize(player, modules, center, radius, scanTicks);
        this.scanFilterLayers.clear();
        IntObjectHashMap filterByRadius = new IntObjectHashMap();
        for (class_1799 stack : modules) {
            Optional<ScannerModule> capability = ScannerModuleItem.getModule(stack);
            capability.ifPresent(arg_0 -> this.lambda$initialize$1(stack, (IntObjectMap)filterByRadius, arg_0));
        }
        IntArrayList scanFilterKeys = new IntArrayList();
        scanFilterKeys.addAll((Collection)filterByRadius.keySet());
        scanFilterKeys.sort((a, b) -> -Integer.compare(a, b));
        if (scanFilterKeys.size() > 0) {
            class_1799 stack;
            this.radius = scanFilterKeys.getInt(0);
            stack = scanFilterKeys.iterator();
            while (stack.hasNext()) {
                int r = (Integer)stack.next();
                this.scanFilterLayers.add(new ScanFilterLayer(r, (List)filterByRadius.get(r)));
            }
            class_2338 minBlockPos = new class_2338(center).method_10080((double)(-this.radius), (double)(-this.radius), (double)(-this.radius));
            class_2338 maxBlockPos = new class_2338(center).method_10080((double)this.radius, (double)this.radius, (double)this.radius);
            class_1923 minChunkPos = new class_1923(minBlockPos);
            class_1923 maxChunkPos = new class_1923(maxBlockPos);
            int minChunkSectionIndex = Math.max(player.method_37908().method_31602(minBlockPos.method_10264()), 0);
            int maxChunkSectionIndex = Math.min(player.method_37908().method_31602(maxBlockPos.method_10264()), player.method_37908().method_32890() - 1);
            for (int chunkSectionIndex = minChunkSectionIndex; chunkSectionIndex <= maxChunkSectionIndex; ++chunkSectionIndex) {
                for (int chunkZ = minChunkPos.field_9180; chunkZ <= maxChunkPos.field_9180; ++chunkZ) {
                    for (int chunkX = minChunkPos.field_9181; chunkX <= maxChunkPos.field_9181; ++chunkX) {
                        class_1923 chunkPos = new class_1923(chunkX, chunkZ);
                        int chunkY = player.method_37908().method_31604(chunkSectionIndex);
                        double dx = Math.min(Math.abs((double)chunkPos.method_8326() - center.field_1352), Math.abs((double)chunkPos.method_8327() - center.field_1352));
                        double dz = Math.min(Math.abs((double)chunkPos.method_8328() - center.field_1350), Math.abs((double)chunkPos.method_8329() - center.field_1350));
                        double dy = Math.min(Math.abs((double)class_4076.method_32205((int)chunkY, (int)0) - center.field_1351), Math.abs((double)class_4076.method_32205((int)chunkY, (int)15) - center.field_1351));
                        double squareDistToCenter = dx * dx + dy * dy + dz * dz;
                        if (squareDistToCenter > (double)(radius * radius)) continue;
                        this.pendingChunkSections.add(new ChunkSectionPos(chunkX, chunkZ, chunkSectionIndex, squareDistToCenter));
                    }
                }
            }
            this.pendingChunkSections.sort(Comparator.comparingDouble(p -> p.squareDistToCenter));
            this.chunkSectionsPerTick = class_3532.method_15386((float)((float)this.pendingChunkSections.size() / (float)scanTicks));
            this.currentChunkSection = 0;
        }
    }

    @Override
    public void computeScanResults() {
        class_1937 level = this.player.field_6002;
        for (int i = 0; i < this.chunkSectionsPerTick; ++i) {
            class_2826[] sections;
            class_2826 section;
            if (this.currentChunkSection >= this.pendingChunkSections.size()) {
                return;
            }
            ChunkSectionPos chunkSectionPos = this.pendingChunkSections.get(this.currentChunkSection);
            ++this.currentChunkSection;
            int chunkX = chunkSectionPos.chunkX;
            int chunkZ = chunkSectionPos.chunkZ;
            int chunkSectionIndex = chunkSectionPos.chunkSectionIndex;
            class_2791 chunk = level.method_8402(chunkX, chunkZ, class_2806.field_12803, false);
            if (chunk == null || (section = (sections = chunk.method_12006())[chunkSectionIndex]) == null || section.method_38292()) continue;
            class_2841 palette = section.method_12265();
            class_2338 origin = chunk.method_12004().method_8323().method_10069(0, section.method_12259(), 0);
            int originX = origin.method_10263();
            int originY = origin.method_10264();
            int originZ = origin.method_10260();
            block1: for (int index = 0; index < 4096; ++index) {
                class_2680 state = (class_2680)palette.method_12331(index);
                class_2248 block = state.method_26204();
                Map clusters = this.resultClusters.computeIfAbsent(block, b -> new HashMap());
                if (clusters.size() > 8192 || IgnoredBlocks.contains(state)) continue;
                int x = index & 0xF;
                int z = index >> 4 & 0xF;
                int y = index >> 8 & 0xF;
                int globalX = originX + x;
                int globalY = originY + y;
                int globalZ = originZ + z;
                double squaredDistance = this.center.method_1028((double)globalX + 0.5, (double)globalY + 0.5, (double)globalZ + 0.5);
                for (ScanFilterLayer layer : this.scanFilterLayers) {
                    if (squaredDistance > (double)(layer.radius * layer.radius)) continue block1;
                    for (Predicate<class_2680> filter : layer.filters) {
                        if (!filter.test(state)) continue;
                        class_2338 pos = new class_2338(globalX, globalY, globalZ);
                        if (this.tryAddToCluster(clusters, pos)) continue block1;
                        BlockScanResult result = new BlockScanResult(state.method_26204(), pos);
                        clusters.put(pos, result);
                        this.results.add(result);
                        continue block1;
                    }
                }
            }
        }
    }

    @Override
    public void collectScanResults(class_1922 level, Consumer<ScanResult> callback) {
        for (BlockScanResult result : this.results) {
            if (!result.isRoot()) continue;
            result.bake(level);
            callback.accept(result);
        }
        this.renderStartTime = System.currentTimeMillis();
    }

    @Override
    public void render(ScanResultRenderContext context, class_4597 bufferSource, class_4587 poseStack, class_4184 renderInfo, float partialTicks, List<ScanResult> results) {
        switch (context) {
            case WORLD: {
                this.renderBlocks(poseStack, renderInfo, partialTicks, results);
                break;
            }
            case GUI: {
                this.renderBlockIcons(bufferSource, poseStack, renderInfo, results);
            }
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.scanFilterLayers.clear();
        this.chunkSectionsPerTick = 0;
        this.currentChunkSection = 0;
        this.pendingChunkSections.clear();
        this.resultClusters.clear();
        this.results.clear();
    }

    public static class_1921 getBlockScanResultRenderLayer() {
        return class_1921.method_24049((String)"scan_result", (class_293)class_290.field_20887, (class_293.class_5596)class_293.class_5596.field_27382, (int)65536, (boolean)false, (boolean)false, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34578(new class_4668.class_5942(Shaders::getScanResultShader)).method_23615(class_4668.field_21367).method_23616(class_4668.field_21350).method_23603(class_4668.field_21345).method_23604(class_4668.field_21346).method_23617(false));
    }

    private void renderBlocks(class_4587 poseStack, class_4184 renderInfo, float partialTicks, List<ScanResult> results) {
        class_5944 shader = Shaders.getScanResultShader();
        if (shader == null) {
            return;
        }
        if (class_310.method_1551().field_1773.field_3992) {
            class_1159 oldProjectionMatrix = RenderSystem.getProjectionMatrix();
            RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            poseStack.method_22903();
            try {
                class_310.method_1551().field_1773.method_3172(poseStack, renderInfo, partialTicks);
            }
            catch (Throwable e) {
                LOGGER.catching(e);
            }
            poseStack.method_22909();
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            RenderSystem.setProjectionMatrix((class_1159)oldProjectionMatrix);
        }
        shader.method_35785("time").method_1251((float)(System.currentTimeMillis() - this.renderStartTime) / 1000.0f);
        class_1921 renderType = ScanResultProviderBlock.getBlockScanResultRenderLayer();
        renderType.method_23516();
        for (ScanResult result : results) {
            BlockScanResult blockResult = (BlockScanResult)result;
            class_291 vbo = blockResult.vbo;
            vbo.method_1353();
            vbo.method_34427(poseStack.method_23760().method_23761(), RenderSystem.getProjectionMatrix(), shader);
            class_291.method_1354();
        }
        renderType.method_23518();
    }

    private void renderBlockIcons(class_4597 bufferSource, class_4587 poseStack, class_4184 renderInfo, List<ScanResult> results) {
        class_243 lookVec = new class_243(renderInfo.method_19335());
        class_243 viewerEyes = renderInfo.method_19326();
        float yaw = renderInfo.method_19330();
        float pitch = renderInfo.method_19329();
        boolean showDistance = renderInfo.method_19331().method_5715();
        results.sort(Comparator.comparing(result -> {
            BlockScanResult blockResult = (BlockScanResult)result;
            class_243 resultPos = blockResult.getPosition();
            class_243 toResult = resultPos.method_1020(viewerEyes);
            return lookVec.method_1026(toResult.method_1029());
        }));
        for (ScanResult result2 : results) {
            BlockScanResult blockResult = (BlockScanResult)result2;
            class_243 resultPos = result2.getPosition();
            class_243 toResult = resultPos.method_1020(viewerEyes);
            float lookDirDot = (float)lookVec.method_1026(toResult.method_1029());
            class_2248 block = blockResult.block;
            class_5250 label = block.method_9518();
            if (!(lookDirDot > 0.98f) || Strings.isNullOrEmpty((String)label.getString())) continue;
            float distance = showDistance ? (float)resultPos.method_1020(viewerEyes).method_1033() : 0.0f;
            ScanResultProviderBlock.renderIconLabel(bufferSource, poseStack, yaw, pitch, lookVec, viewerEyes, distance, resultPos, API.ICON_INFO, (class_2561)label);
        }
    }

    private boolean tryAddToCluster(Map<class_2338, BlockScanResult> clusters, class_2338 pos) {
        BlockScanResult root = null;
        root = this.tryAddToCluster(clusters, pos, pos.method_10078(), root);
        root = this.tryAddToCluster(clusters, pos, pos.method_10067(), root);
        root = this.tryAddToCluster(clusters, pos, pos.method_10095(), root);
        root = this.tryAddToCluster(clusters, pos, pos.method_10072(), root);
        root = this.tryAddToCluster(clusters, pos, pos.method_10084(), root);
        root = this.tryAddToCluster(clusters, pos, pos.method_10074(), root);
        return root != null;
    }

    @Nullable
    private BlockScanResult tryAddToCluster(Map<class_2338, BlockScanResult> clusters, class_2338 pos, class_2338 clusterPos, @Nullable BlockScanResult root) {
        BlockScanResult cluster = clusters.get(clusterPos);
        if (cluster == null) {
            return root;
        }
        if (root == null) {
            root = cluster.getRoot();
            root.add(pos);
            clusters.put(pos, root);
        } else {
            cluster.getRoot().setRoot(root);
        }
        return root;
    }

    private /* synthetic */ void lambda$initialize$1(class_1799 stack, IntObjectMap filterByRadius, ScannerModule module) {
        if (module instanceof BlockScannerModule) {
            BlockScannerModule blockModule = (BlockScannerModule)module;
            Predicate<class_2680> filter = blockModule.getFilter(stack);
            int localRadius = (int)Math.ceil(blockModule.adjustLocalRange(this.radius));
            ((List)filterByRadius.computeIfAbsent((Object)localRadius, r -> new ArrayList())).add(filter);
        }
    }

    private record ScanFilterLayer(int radius, List<Predicate<class_2680>> filters) {
    }

    private record ChunkSectionPos(int chunkX, int chunkZ, int chunkSectionIndex, double squareDistToCenter) {
    }

    private static final class BlockScanResult
    implements ScanResult {
        private final class_2248 block;
        private class_238 bounds;
        @Nullable
        private BlockScanResult parent;
        private final Set<class_2338> blocks;
        private int color;
        private class_291 vbo;

        BlockScanResult(class_2248 block, class_2338 pos) {
            this.block = block;
            this.bounds = new class_238(pos);
            this.blocks = new HashSet<class_2338>();
            this.blocks.add(pos);
        }

        void bake(class_1922 level) {
            class_2680 blockState = this.block.method_9564();
            this.color = blockState.method_26205((class_1922)level, (class_2338)new class_2338((class_243)this.bounds.method_1005())).field_16011;
            class_3610 fluidState = blockState.method_26227();
            if (!fluidState.method_15769()) {
                if (ClientConfig.fluidColors.containsKey((Object)class_2378.field_11154.method_10221((Object)fluidState.method_15772()))) {
                    this.color = ClientConfig.fluidColors.getInt((Object)class_2378.field_11154.method_10221((Object)fluidState.method_15772()));
                } else {
                    ClientConfig.fluidTagColors.forEach((k, v) -> {
                        class_6862 tag = class_6862.method_40092((class_5321)class_2378.field_25103, (class_2960)k);
                        if (fluidState.method_15767(tag)) {
                            this.color = v;
                        }
                    });
                }
            } else if (ClientConfig.blockColors.containsKey((Object)class_2378.field_11146.method_10221((Object)blockState.method_26204()))) {
                this.color = ClientConfig.blockColors.getInt((Object)class_2378.field_11146.method_10221((Object)blockState.method_26204()));
            } else {
                ClientConfig.blockTagColors.forEach((k, v) -> {
                    class_6862 tag = class_6862.method_40092((class_5321)class_2378.field_25105, (class_2960)k);
                    if (blockState.method_26164(tag)) {
                        this.color = v;
                    }
                });
            }
            if (this.color == 0) {
                this.color = 0x4466CC;
            }
            class_287 buffer = class_289.method_1348().method_1349();
            buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
            this.render((class_4588)buffer, new class_4587());
            this.vbo = new class_291();
            this.vbo.method_1353();
            this.vbo.method_1352(buffer.method_1326());
            class_291.method_1354();
        }

        boolean isRoot() {
            return this.parent == null;
        }

        BlockScanResult getRoot() {
            if (this.parent != null) {
                return this.parent.getRoot();
            }
            return this;
        }

        void setRoot(BlockScanResult root) {
            if (root == this) {
                return;
            }
            assert (this.parent == null);
            root.bounds = root.bounds.method_991(this.bounds);
            root.blocks.addAll(this.blocks);
            this.blocks.clear();
            this.parent = root;
        }

        void add(class_2338 pos) {
            assert (this.parent == null) : "Trying to add to non-root node.";
            this.bounds = this.bounds.method_991(new class_238(pos));
            this.blocks.add(pos);
        }

        void render(class_4588 buffer, class_4587 poseStack) {
            class_1159 matrix = poseStack.method_23760().method_23761();
            float colorNormalizer = 0.003921569f;
            float r = (float)(this.color >> 16 & 0xFF) * 0.003921569f;
            float g = (float)(this.color >> 8 & 0xFF) * 0.003921569f;
            float b = (float)(this.color & 0xFF) * 0.003921569f;
            float sizeUvX = (float)(1.0 / this.bounds.method_17939());
            float sizeUvY = (float)(1.0 / this.bounds.method_17940());
            float sizeUvZ = (float)(1.0 / this.bounds.method_17941());
            for (class_2338 cell : this.blocks) {
                float maxY;
                float minY;
                float z;
                float maxX;
                float minX;
                float y;
                float v1;
                float v0;
                float u1;
                float u0;
                float maxZ;
                float minZ;
                float maxY2;
                float minY2;
                float x;
                if (!this.blocks.contains(cell.method_10069(-1, 0, 0))) {
                    x = cell.method_10263();
                    minY2 = cell.method_10264();
                    maxY2 = cell.method_10264() + 1;
                    minZ = cell.method_10260();
                    maxZ = cell.method_10260() + 1;
                    u0 = (minY2 - (float)this.bounds.field_1322) * sizeUvY;
                    u1 = u0 + sizeUvY;
                    v0 = (minZ - (float)this.bounds.field_1321) * sizeUvZ;
                    v1 = v0 + sizeUvZ;
                    buffer.method_22918(matrix, x, minY2, minZ).method_22913(u0, v0).method_22915(r, g, b, 0.8f).method_1344();
                    buffer.method_22918(matrix, x, minY2, maxZ).method_22913(u0, v1).method_22915(r, g, b, 0.8f).method_1344();
                    buffer.method_22918(matrix, x, maxY2, maxZ).method_22913(u1, v1).method_22915(r, g, b, 0.8f).method_1344();
                    buffer.method_22918(matrix, x, maxY2, minZ).method_22913(u1, v0).method_22915(r, g, b, 0.8f).method_1344();
                }
                if (!this.blocks.contains(cell.method_10069(1, 0, 0))) {
                    x = cell.method_10263() + 1;
                    minY2 = cell.method_10264();
                    maxY2 = cell.method_10264() + 1;
                    minZ = cell.method_10260();
                    maxZ = cell.method_10260() + 1;
                    u0 = (minY2 - (float)this.bounds.field_1322) * sizeUvY;
                    u1 = u0 + sizeUvY;
                    v0 = (minZ - (float)this.bounds.field_1321) * sizeUvZ;
                    v1 = v0 + sizeUvZ;
                    buffer.method_22918(matrix, x, minY2, minZ).method_22913(u0, v0).method_22915(r, g, b, 0.8f).method_1344();
                    buffer.method_22918(matrix, x, maxY2, minZ).method_22913(u1, v0).method_22915(r, g, b, 0.8f).method_1344();
                    buffer.method_22918(matrix, x, maxY2, maxZ).method_22913(u1, v1).method_22915(r, g, b, 0.8f).method_1344();
                    buffer.method_22918(matrix, x, minY2, maxZ).method_22913(u0, v1).method_22915(r, g, b, 0.8f).method_1344();
                }
                if (!this.blocks.contains(cell.method_10069(0, -1, 0))) {
                    y = cell.method_10264();
                    minX = cell.method_10263();
                    maxX = cell.method_10263() + 1;
                    minZ = cell.method_10260();
                    maxZ = cell.method_10260() + 1;
                    u0 = (minX - (float)this.bounds.field_1323) * sizeUvX;
                    u1 = u0 + sizeUvX;
                    v0 = (minZ - (float)this.bounds.field_1321) * sizeUvZ;
                    v1 = v0 + sizeUvZ;
                    buffer.method_22918(matrix, minX, y, minZ).method_22913(u0, v0).method_22915(r, g, b, 0.7f).method_1344();
                    buffer.method_22918(matrix, maxX, y, minZ).method_22913(u1, v0).method_22915(r, g, b, 0.7f).method_1344();
                    buffer.method_22918(matrix, maxX, y, maxZ).method_22913(u1, v1).method_22915(r, g, b, 0.7f).method_1344();
                    buffer.method_22918(matrix, minX, y, maxZ).method_22913(u0, v1).method_22915(r, g, b, 0.7f).method_1344();
                }
                if (!this.blocks.contains(cell.method_10069(0, 1, 0))) {
                    y = cell.method_10264() + 1;
                    minX = cell.method_10263();
                    maxX = cell.method_10263() + 1;
                    minZ = cell.method_10260();
                    maxZ = cell.method_10260() + 1;
                    u0 = (minX - (float)this.bounds.field_1323) * sizeUvX;
                    u1 = u0 + sizeUvX;
                    v0 = (minZ - (float)this.bounds.field_1321) * sizeUvZ;
                    v1 = v0 + sizeUvZ;
                    buffer.method_22918(matrix, minX, y, minZ).method_22913(u0, v0).method_22915(r, g, b, 1.0f).method_1344();
                    buffer.method_22918(matrix, minX, y, maxZ).method_22913(u0, v1).method_22915(r, g, b, 1.0f).method_1344();
                    buffer.method_22918(matrix, maxX, y, maxZ).method_22913(u1, v1).method_22915(r, g, b, 1.0f).method_1344();
                    buffer.method_22918(matrix, maxX, y, minZ).method_22913(u1, v0).method_22915(r, g, b, 1.0f).method_1344();
                }
                if (!this.blocks.contains(cell.method_10069(0, 0, -1))) {
                    z = cell.method_10260();
                    minX = cell.method_10263();
                    maxX = cell.method_10263() + 1;
                    minY = cell.method_10264();
                    maxY = cell.method_10264() + 1;
                    u0 = (minX - (float)this.bounds.field_1323) * sizeUvX;
                    u1 = u0 + sizeUvX;
                    v0 = (minY - (float)this.bounds.field_1322) * sizeUvY;
                    v1 = v0 + sizeUvY;
                    buffer.method_22918(matrix, minX, minY, z).method_22913(u0, v0).method_22915(r, g, b, 0.9f).method_1344();
                    buffer.method_22918(matrix, minX, maxY, z).method_22913(u0, v1).method_22915(r, g, b, 0.9f).method_1344();
                    buffer.method_22918(matrix, maxX, maxY, z).method_22913(u1, v1).method_22915(r, g, b, 0.9f).method_1344();
                    buffer.method_22918(matrix, maxX, minY, z).method_22913(u1, v0).method_22915(r, g, b, 0.9f).method_1344();
                }
                if (this.blocks.contains(cell.method_10069(0, 0, 1))) continue;
                z = cell.method_10260() + 1;
                minX = cell.method_10263();
                maxX = cell.method_10263() + 1;
                minY = cell.method_10264();
                maxY = cell.method_10264() + 1;
                u0 = (minX - (float)this.bounds.field_1323) * sizeUvX;
                u1 = u0 + sizeUvX;
                v0 = (minY - (float)this.bounds.field_1322) * sizeUvY;
                v1 = v0 + sizeUvY;
                buffer.method_22918(matrix, minX, minY, z).method_22913(u0, v0).method_22915(r, g, b, 0.9f).method_1344();
                buffer.method_22918(matrix, maxX, minY, z).method_22913(u1, v0).method_22915(r, g, b, 0.9f).method_1344();
                buffer.method_22918(matrix, maxX, maxY, z).method_22913(u1, v1).method_22915(r, g, b, 0.9f).method_1344();
                buffer.method_22918(matrix, minX, maxY, z).method_22913(u0, v1).method_22915(r, g, b, 0.9f).method_1344();
            }
        }

        @Override
        @Nullable
        public class_238 getRenderBounds() {
            return this.bounds;
        }

        @Override
        public class_243 getPosition() {
            return this.bounds.method_1005();
        }

        @Override
        public void close() {
            if (this.vbo != null) {
                this.vbo.close();
                this.vbo = null;
            }
        }
    }
}

