/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.common.config;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.HashSet;
import java.util.Set;
import li.cil.scannable.common.config.fabric.CommonConfigImpl;
import li.cil.scannable.util.config.Comment;
import li.cil.scannable.util.config.ItemType;
import li.cil.scannable.util.config.Max;
import li.cil.scannable.util.config.Min;
import li.cil.scannable.util.config.Path;
import li.cil.scannable.util.config.WorldRestart;
import net.minecraft.class_156;
import net.minecraft.class_2246;
import net.minecraft.class_2378;
import net.minecraft.class_2960;

public final class CommonConfig {
    @Path(value="energy")
    @WorldRestart
    @Comment(value={"Whether to consume energy when performing a scan. Will make the scanner a chargeable item."})
    public static boolean useEnergy = true;
    @Path(value="energy")
    @WorldRestart
    @Min(value=0.0)
    @Comment(value={"Amount of energy that can be stored in a scanner."})
    public static int energyCapacityScanner = 5000;
    @Path(value="energy")
    @WorldRestart
    @Min(value=0.0)
    @Comment(value={"Amount of energy used by the range module per scan."})
    public static int energyCostModuleRange = 100;
    @Path(value="energy")
    @WorldRestart
    @Min(value=0.0)
    @Comment(value={"Amount of energy used by the animal module per scan."})
    public static int energyCostModuleAnimal = 25;
    @Path(value="energy")
    @WorldRestart
    @Min(value=0.0)
    @Comment(value={"Amount of energy used by the monster module per scan."})
    public static int energyCostModuleMonster = 50;
    @Path(value="energy")
    @WorldRestart
    @Min(value=0.0)
    @Comment(value={"Amount of energy used by the common ore module per scan."})
    public static int energyCostModuleOreCommon = 75;
    @Path(value="energy")
    @WorldRestart
    @Min(value=0.0)
    @Comment(value={"Amount of energy used by the rare ore module per scan."})
    public static int energyCostModuleOreRare = 100;
    @Path(value="energy")
    @WorldRestart
    @Min(value=0.0)
    @Comment(value={"Amount of energy used by the block module per scan."})
    public static int energyCostModuleBlock = 100;
    @Path(value="energy")
    @WorldRestart
    @Min(value=0.0)
    @Comment(value={"Amount of energy used by the fluid module per scan."})
    public static int energyCostModuleFluid = 50;
    @Path(value="energy")
    @WorldRestart
    @Min(value=0.0)
    @Comment(value={"Amount of energy used by the entity module per scan."})
    public static int energyCostModuleEntity = 75;
    @Path(value="general")
    @WorldRestart
    @Min(value=16.0)
    @Max(value=128.0)
    @Comment(value={"The basic scan radius without range modules. Higher values mean more computational\noverhead and thus potentially worse performance while scanning.\nIMPORTANT: some modules such as the block and ore scanner modules will already use\na reduced radius based on this value. Specifically, the ore scanners multiply this\nvalue by 0.25, and the block scanner multiplies it by 0.5.\nRange modules will boost the range by half this value."})
    public static int baseScanRadius = 64;
    @Path(value="general")
    @WorldRestart
    @Min(value=1000.0)
    @Max(value=300000.0)
    @Comment(value={"How long the results from a scan should remain visible, in milliseconds."})
    public static int scanStayDuration = 10000;
    @Path(value="blocks")
    @WorldRestart
    @Comment(value={"Registry names of blocks that should be ignored.\nBlocks in this list will be excluded from the default ore list based on the forge:ores\ntag and it will be impossible to tune the entity module to this block."})
    @ItemType(value=class_2960.class)
    public static Set<class_2960> ignoredBlocks = (Set)class_156.method_654(new HashSet(), c -> c.add(class_2378.field_11146.method_10221((Object)class_2246.field_10525)));
    @Path(value="blocks")
    @WorldRestart
    @Comment(value={"Tag names of block tags that should be ignored.\nBlocks matching a tag in this list will be excluded from the default ore list based on the\nforge:ores tag and it will be impossible to tune the entity module to this block."})
    @ItemType(value=class_2960.class)
    public static Set<class_2960> ignoredBlockTags = new HashSet<class_2960>();
    @Path(value="ores")
    @WorldRestart
    @Comment(value={"Registry names of blocks considered 'common ores', requiring the common ore scanner module."})
    @ItemType(value=class_2960.class)
    public static Set<class_2960> commonOreBlocks = (Set)class_156.method_654(new HashSet(), c -> c.add(class_2378.field_11146.method_10221((Object)class_2246.field_10460)));
    @Path(value="ores")
    @WorldRestart
    @Comment(value={"Block tags of blocks considered 'common ores', requiring the common ore scanner module."})
    @ItemType(value=class_2960.class)
    public static Set<class_2960> commonOreBlockTags = CommonConfig.getDefaultCommonOreTags();
    @Path(value="ores")
    @WorldRestart
    @Comment(value={"Registry names of blocks considered 'rare ores', requiring the rare ore scanner module."})
    @ItemType(value=class_2960.class)
    public static Set<class_2960> rareOreBlocks = (Set)class_156.method_654(new HashSet(), c -> c.add(class_2378.field_11146.method_10221((Object)class_2246.field_10171)));
    @Path(value="ores")
    @WorldRestart
    @Comment(value={"Block tags of blocks considered 'rare ores', requiring the common ore scanner module.\nAny block with the forge:ores tag is implicitly in this list, unless the block also\nmatches an ignored or common ore block tag, or is an ignored or common block."})
    @ItemType(value=class_2960.class)
    public static Set<class_2960> rareOreBlockTags = new HashSet<class_2960>();
    @Path(value="fluids")
    @WorldRestart
    @Comment(value={"Fluid tags of fluids that should be ignored."})
    @ItemType(value=class_2960.class)
    public static Set<class_2960> ignoredFluidTags = new HashSet<class_2960>();

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static Set<class_2960> getDefaultCommonOreTags() {
        return CommonConfigImpl.getDefaultCommonOreTags();
    }
}

