/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.common.item;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import li.cil.scannable.api.scanning.ScannerModule;
import li.cil.scannable.common.config.CommonConfig;
import li.cil.scannable.common.config.Strings;
import li.cil.scannable.common.item.ModItem;
import li.cil.scannable.common.item.fabric.ScannerModuleItemImpl;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Contract;

public class ScannerModuleItem
extends ModItem {
    private final ScannerModule module;

    ScannerModuleItem(ScannerModule module) {
        super(new class_1792.class_1793().method_7889(1));
        this.module = module;
    }

    public ScannerModule getModule() {
        return this.module;
    }

    @Contract(value="_ -> !null")
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Optional<ScannerModule> getModule(class_1799 stack) {
        return ScannerModuleItemImpl.getModule(stack);
    }

    public static int getModuleEnergyCost(class_1799 stack) {
        if (!CommonConfig.useEnergy) {
            return 0;
        }
        return ScannerModuleItem.getModule(stack).map(module -> module.getEnergyCost(stack)).orElse(0);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, @Nullable class_1937 level, List<class_2561> tooltip, class_1836 flag) {
        super.method_7851(stack, level, tooltip, flag);
        int cost = ScannerModuleItem.getModuleEnergyCost(stack);
        if (cost > 0) {
            tooltip.add(Strings.energyUsage(cost));
        }
    }
}

