/*
 * Decompiled with CFR 0.152.
 */
package me.wesley1808.servercore.common.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.file.GenericBuilder;
import com.electronwill.nightconfig.toml.TomlFormat;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.function.BiConsumer;
import me.wesley1808.servercore.common.ServerCore;
import me.wesley1808.servercore.common.config.ConfigEntry;
import me.wesley1808.servercore.common.config.tables.ActivationRangeConfig;
import me.wesley1808.servercore.common.config.tables.CommandConfig;
import me.wesley1808.servercore.common.config.tables.DynamicConfig;
import me.wesley1808.servercore.common.config.tables.EntityLimitConfig;
import me.wesley1808.servercore.common.config.tables.FeatureConfig;
import me.wesley1808.servercore.common.config.tables.MobSpawnConfig;
import me.wesley1808.servercore.common.config.tables.OptimizationConfig;
import me.wesley1808.servercore.common.dynamic.DynamicSetting;
import me.wesley1808.servercore.common.interfaces.IMobCategory;
import me.wesley1808.servercore.common.services.platform.PlatformHelper;
import org.jetbrains.annotations.Nullable;

public class Config {
    @Nullable
    private static GenericBuilder<CommentedConfig, CommentedFileConfig> configBuilder;

    public static void load(boolean afterMixinLoad) {
        if (configBuilder != null) {
            CommentedFileConfig config = (CommentedFileConfig)configBuilder.build();
            config.load();
            config.close();
            for (Table table : Table.values()) {
                Config.validate(table, config);
                if (!afterMixinLoad && !table.loadBeforeMixins) continue;
                Config.loadEntries((CommentedConfig)config.get(table.key), table.clazz);
            }
            if (afterMixinLoad) {
                Config.loadChanges();
            }
        }
    }

    public static void save() {
        if (configBuilder != null) {
            CommentedFileConfig config = (CommentedFileConfig)configBuilder.build();
            for (Table table : Table.values()) {
                Config.validate(table, config);
                Config.saveEntries((CommentedConfig)config.get(table.key), table.clazz);
                config.setComment(table.key, table.comment);
            }
            config.save();
            config.close();
        }
    }

    public static boolean isConfigAvailable() {
        return configBuilder != null;
    }

    private static void loadChanges() {
        DynamicSetting.loadCustomOrder();
        IMobCategory.reload();
    }

    private static void validate(Table table, CommentedFileConfig config) {
        if (!config.contains(table.key)) {
            config.add(table.key, (Object)CommentedConfig.inMemory());
        }
    }

    private static void loadEntries(CommentedConfig config, Class<?> clazz) {
        try {
            Config.forEachEntry(clazz, (field, entry) -> {
                String key = field.getName().toLowerCase();
                Object value = config.getOrElse(key, entry.getDefault());
                if (!entry.set(value)) {
                    ServerCore.LOGGER.error("[ServerCore] Invalid config entry found! {} = {} (Reverting back to default: {})", new Object[]{key, value, entry.getDefault()});
                }
            });
        }
        catch (Throwable throwable) {
            ServerCore.LOGGER.error("[ServerCore] An error occurred whilst loading config entries!", throwable);
        }
    }

    private static void saveEntries(CommentedConfig config, Class<?> clazz) {
        try {
            config.clear();
            Config.forEachEntry(clazz, (field, entry) -> {
                String key = field.getName().toLowerCase();
                String comment = entry.getComment();
                config.set(key, entry.get());
                if (comment != null) {
                    config.setComment(key, " " + comment.replace("\n", "\n "));
                }
            });
        }
        catch (Throwable throwable) {
            ServerCore.LOGGER.error("[ServerCore] An error occurred whilst saving configs!", throwable);
        }
    }

    public static <T> void forEachEntry(Class<?> clazz, BiConsumer<Field, ConfigEntry<T>> consumer) throws IllegalAccessException {
        for (Field field : clazz.getFields()) {
            Object object = field.get(clazz);
            if (!(object instanceof ConfigEntry)) continue;
            ConfigEntry entry = (ConfigEntry)object;
            consumer.accept(field, entry);
        }
    }

    static {
        System.setProperty("nightconfig.preserveInsertionOrder", "true");
        Path path = PlatformHelper.getConfigDir().resolve("servercore.toml");
        try {
            configBuilder = CommentedFileConfig.builder((Path)path, (ConfigFormat)TomlFormat.instance()).preserveInsertionOrder().sync();
        }
        catch (Throwable throwable) {
            ServerCore.LOGGER.error("[ServerCore] Unable to initialize config builder: {}", (Object)throwable.getMessage());
            ServerCore.LOGGER.error("[ServerCore] Load and save operations on the config file will not be available.");
            configBuilder = null;
        }
    }

    public static enum Table {
        FEATURES(FeatureConfig.class, false, "Lets you enable / disable certain features and modify them."),
        DYNAMIC(DynamicConfig.class, false, "Modifies mobcaps, no-chunk-tick, simulation and view-distance depending on the MSPT."),
        BREEDING_CAP(EntityLimitConfig.class, false, "Stops animals / villagers from breeding if there are too many of the same type nearby."),
        MOB_SPAWNING(MobSpawnConfig.class, false, "Allows you to modify individual mobcaps and their frequency of spawn attempts."),
        OPTIMIZATIONS(OptimizationConfig.class, true, "Allows you to toggle specific optimizations that don't have full vanilla parity.\nThese settings will only take effect after server restarts."),
        COMMANDS(CommandConfig.class, false, "Allows you to disable specific commands and modify the way some of them are formatted."),
        ACTIVATION_RANGE(ActivationRangeConfig.class, false, "Stops entities from ticking if they are too far away.");

        public final String key = this.name().toLowerCase();
        public final String comment;
        public final Class<?> clazz;
        public final boolean loadBeforeMixins;

        private Table(Class<?> clazz, boolean loadBeforeMixins, String comment) {
            this.comment = " " + comment.replace("\n", "\n ");
            this.clazz = clazz;
            this.loadBeforeMixins = loadBeforeMixins;
        }
    }
}

