/*
 * Decompiled with CFR 0.152.
 */
package me.wesley1808.servercore.common.dynamic;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.math.BigDecimal;
import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.function.DoubleSupplier;
import java.util.function.IntSupplier;
import me.wesley1808.servercore.common.config.tables.DynamicConfig;
import me.wesley1808.servercore.common.dynamic.DynamicManager;
import org.jetbrains.annotations.Nullable;

public enum DynamicSetting {
    VIEW_DISTANCE(DynamicConfig.VIEW_DISTANCE_UPDATE_RATE::get, DynamicConfig.VIEW_DISTANCE_INCREMENT::get, DynamicConfig.MIN_VIEW_DISTANCE::get, DynamicConfig.MAX_VIEW_DISTANCE::get, (manager, value) -> manager.modifyViewDistance(value.intValue())),
    SIMULATION_DISTANCE(DynamicConfig.UPDATE_RATE::get, DynamicConfig.SIMULATION_DISTANCE_INCREMENT::get, DynamicConfig.MIN_SIMULATION_DISTANCE::get, DynamicConfig.MAX_SIMULATION_DISTANCE::get, (manager, value) -> manager.modifySimulationDistance(value.intValue())),
    MOBCAP_MULTIPLIER(DynamicConfig.UPDATE_RATE::get, DynamicConfig.MOBCAP_INCREMENT::get, DynamicConfig.MIN_MOBCAP::get, DynamicConfig.MAX_MOBCAP::get, (manager, value) -> DynamicManager.modifyMobcaps(value)),
    CHUNK_TICK_DISTANCE(DynamicConfig.UPDATE_RATE::get, DynamicConfig.CHUNK_TICK_DISTANCE_INCREMENT::get, DynamicConfig.MIN_CHUNK_TICK_DISTANCE::get, DynamicConfig.MAX_CHUNK_TICK_DISTANCE::get);

    private final BiConsumer<DynamicManager, Double> onChanged;
    private final DoubleSupplier increment;
    private final DoubleSupplier min;
    private final DoubleSupplier max;
    private final IntSupplier interval;
    private BigDecimal value;
    private double cachedValue;
    private DynamicSetting prev;
    private DynamicSetting next;

    private DynamicSetting(IntSupplier interval, DoubleSupplier increment, DoubleSupplier min, DoubleSupplier max) {
        this(interval, increment, min, max, null);
    }

    private DynamicSetting(IntSupplier interval, DoubleSupplier increment, DoubleSupplier min, DoubleSupplier max, BiConsumer<DynamicManager, Double> onChanged) {
        this.interval = interval;
        this.onChanged = onChanged;
        this.increment = increment;
        this.min = min;
        this.max = max;
        this.reset();
    }

    public static void loadCustomOrder() {
        ObjectArrayList settings = new ObjectArrayList();
        for (String key : DynamicConfig.SETTING_ORDER.get()) {
            settings.add((Object)DynamicSetting.valueOf(key.toUpperCase(Locale.ENGLISH)));
        }
        for (int i = 0; i < settings.size(); ++i) {
            DynamicSetting setting = (DynamicSetting)((Object)settings.get(i));
            DynamicSetting prev = i == 0 ? null : (DynamicSetting)((Object)settings.get(i - 1));
            DynamicSetting next = i == settings.size() - 1 ? null : (DynamicSetting)((Object)settings.get(i + 1));
            setting.initialize(prev, next);
        }
    }

    public static void resetAll() {
        for (DynamicSetting setting : DynamicSetting.values()) {
            setting.reset();
        }
    }

    public void initialize(DynamicSetting prev, DynamicSetting next) {
        this.prev = prev;
        this.next = next;
    }

    public double get() {
        return this.cachedValue;
    }

    public boolean shouldRun(int count) {
        return count % this.interval.getAsInt() == 0;
    }

    public void reset() {
        this.set(this.max.getAsDouble(), null);
    }

    public void set(double value, @Nullable DynamicManager manager) {
        this.set(BigDecimal.valueOf(value), manager);
    }

    public void set(BigDecimal value, @Nullable DynamicManager manager) {
        this.value = value;
        this.cachedValue = value.doubleValue();
        if (this.onChanged != null && manager != null) {
            this.onChanged.accept(manager, this.cachedValue);
        }
    }

    public boolean modify(boolean increase, DynamicManager manager) {
        BigDecimal value = this.newValue(increase);
        if (this.shouldModify(value)) {
            this.set(value, manager);
            return true;
        }
        return false;
    }

    private boolean shouldModify(BigDecimal value) {
        int compared = value.compareTo(this.value);
        return !(compared == 0 || this.next == null && this.prev == null || compared >= 0 && (this.isMaximum() || this.next != null && !this.next.isMaximum()) || compared <= 0 && (this.isMinimum() || this.prev != null && !this.prev.isMinimum()));
    }

    private BigDecimal newValue(boolean increase) {
        BigDecimal value;
        BigDecimal increment = BigDecimal.valueOf(this.increment.getAsDouble());
        if (increase) {
            value = this.value.add(increment);
            double maximum = this.max.getAsDouble();
            if (value.doubleValue() > maximum) {
                return BigDecimal.valueOf(maximum);
            }
        } else {
            value = this.value.subtract(increment);
            double minimum = this.min.getAsDouble();
            if (value.doubleValue() < minimum) {
                return BigDecimal.valueOf(minimum);
            }
        }
        return value;
    }

    private boolean isMinimum() {
        return this.cachedValue <= this.min.getAsDouble();
    }

    private boolean isMaximum() {
        return this.cachedValue >= this.max.getAsDouble();
    }
}

