/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.stream.Stream;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;

public class TagHelper {
    public static final class_6862<class_1792> ITEM_DUMMY = class_6862.method_40092((class_5321)class_2378.field_25108, (class_2960)new class_2960("empty_dummy_tag"));
    private static final HashMap<class_2960, class_6862<class_1792>> ITEM_TAGS = new HashMap();
    public static final class_6862<class_2248> BLOCK_DUMMY = class_6862.method_40092((class_5321)class_2378.field_25105, (class_2960)new class_2960("empty_dummy_tag"));
    private static final HashMap<class_2960, class_6862<class_2248>> BLOCK_TAGS = new HashMap();

    public static class_6862<class_1792> getItemTagKey(class_2960 tagId) {
        if (!ITEM_TAGS.containsKey(tagId)) {
            class_6862 tag = class_6862.method_40092((class_5321)class_2378.field_25108, (class_2960)tagId);
            ITEM_TAGS.put(tagId, (class_6862<class_1792>)tag);
        }
        return ITEM_TAGS.getOrDefault(tagId, ITEM_DUMMY);
    }

    public static class_6862<class_1792> getItemTagKey(String tagId) {
        return !Strings.isNullOrEmpty((String)tagId) ? TagHelper.getItemTagKey(new class_2960(tagId.toLowerCase(Locale.ROOT))) : ITEM_DUMMY;
    }

    public static boolean isItemInTag(class_1799 stack, class_6862<class_1792> tagKey) {
        return !stack.method_7960() && TagHelper.isItemInTag(stack.method_7909(), tagKey);
    }

    public static boolean isItemInTag(class_1792 item, class_6862<class_1792> tagKey) {
        if (item != null && tagKey != null) {
            class_6880.class_6883 entry = item.method_40131();
            return entry != null && entry.method_40220(tagKey);
        }
        return false;
    }

    public static boolean isItemInTag(class_1799 stack, String tagId) {
        return !Strings.isNullOrEmpty((String)tagId) && TagHelper.isItemInTag(stack, TagHelper.getItemTagKey(tagId));
    }

    public static boolean isItemInTag(class_1792 item, String tagId) {
        return !Strings.isNullOrEmpty((String)tagId) && TagHelper.isItemInTag(item, TagHelper.getItemTagKey(tagId));
    }

    public static boolean isItemInTag(class_1799 stack, Check check, Object ... tags) {
        return !stack.method_7960() && TagHelper.isItemInTag(stack.method_7909(), check, tags);
    }

    public static boolean isItemInTag(class_1792 item, Check check, Object ... tags) {
        class_6880.class_6883 entry;
        if (item != null && (entry = item.method_40131()) != null) {
            for (Object tagId : tags) {
                class_6862 tagKey;
                class_6862 tag = null;
                if (tagId instanceof String) {
                    String string = (String)tagId;
                    if (!Strings.isNullOrEmpty((String)string)) {
                        tag = TagHelper.getItemTagKey(string);
                    }
                } else if (tagId instanceof class_6862 && (tagKey = (class_6862)tagId).comp_326() == class_2378.field_25108) {
                    tag = (class_6862)tagId;
                }
                if (tag == null) continue;
                if (entry.method_40220(tag)) {
                    if (check != Check.ANY) continue;
                    return true;
                }
                if (check != Check.ALL) continue;
                return false;
            }
        }
        return false;
    }

    public static Collection<class_1792> getItems(class_6862<class_1792> tagKey) {
        ArrayList list = Lists.newArrayList();
        for (class_6880 holder : class_2378.field_11142.method_40286(tagKey)) {
            list.add((class_1792)holder.comp_349());
        }
        return list;
    }

    public static Collection<class_1792> getItems(String tagId) {
        return !Strings.isNullOrEmpty((String)tagId) ? TagHelper.getItems(TagHelper.getItemTagKey(tagId)) : Collections.emptyList();
    }

    @NotNull
    public static class_1799 getItemStack(String tagId, int ... stackSize) {
        Collection<class_1792> results;
        int amount;
        int n = amount = stackSize != null && stackSize.length > 0 ? stackSize[0] : 1;
        if (amount > 0 && (results = TagHelper.getItems(tagId)) != null && !results.isEmpty()) {
            for (class_1792 item : results) {
                if (item == null) continue;
                return new class_1799((class_1935)item, amount);
            }
        }
        return class_1799.field_8037;
    }

    public static Stream<class_6862<class_1792>> getTags(class_1799 stack) {
        return !stack.method_7960() ? TagHelper.getTags(stack.method_7909()) : Collections.EMPTY_SET.stream();
    }

    public static Stream<class_6862<class_1792>> getTags(class_1792 item) {
        return item != null ? item.method_40131().method_40228() : Collections.EMPTY_SET.stream();
    }

    public static class_6862<class_2248> getBlockTagKey(class_2960 tagId) {
        if (!BLOCK_TAGS.containsKey(tagId)) {
            class_6862 tag = class_6862.method_40092((class_5321)class_2378.field_25105, (class_2960)tagId);
            BLOCK_TAGS.put(tagId, (class_6862<class_2248>)tag);
        }
        return BLOCK_TAGS.getOrDefault(tagId, BLOCK_DUMMY);
    }

    public static class_6862<class_2248> getBlockTagKey(String tagId) {
        return !Strings.isNullOrEmpty((String)tagId) ? TagHelper.getBlockTagKey(new class_2960(tagId.toLowerCase(Locale.ROOT))) : BLOCK_DUMMY;
    }

    public static boolean isBlockInTag(class_2680 state, class_6862<class_2248> tagKey) {
        return state != null && TagHelper.isBlockInTag(state.method_26204(), tagKey);
    }

    public static boolean isBlockInTag(class_2248 block, class_6862<class_2248> tagKey) {
        if (block != null && tagKey != null) {
            class_6880.class_6883 entry = block.method_40142();
            return entry != null && entry.method_40220(tagKey);
        }
        return false;
    }

    public static boolean isBlockInTag(class_2680 state, String tagId) {
        return !Strings.isNullOrEmpty((String)tagId) && TagHelper.isBlockInTag(state, TagHelper.getBlockTagKey(tagId));
    }

    public static boolean isBlockInTag(class_2248 block, String tagId) {
        return !Strings.isNullOrEmpty((String)tagId) && TagHelper.isBlockInTag(block, TagHelper.getBlockTagKey(tagId));
    }

    public static boolean isBlockInTag(class_2680 state, Check check, Object ... tags) {
        return state != null && TagHelper.isBlockInTag(state.method_26204(), check, tags);
    }

    public static boolean isBlockInTag(class_2248 block, Check check, Object ... tags) {
        class_6880.class_6883 entry;
        if (block != null && (entry = block.method_40142()) != null) {
            for (Object tagId : tags) {
                class_6862 tagKey;
                class_6862 tag = null;
                if (tagId instanceof String) {
                    String string = (String)tagId;
                    if (!Strings.isNullOrEmpty((String)string)) {
                        tag = TagHelper.getBlockTagKey(string);
                    }
                } else if (tagId instanceof class_6862 && (tagKey = (class_6862)tagId).comp_326() == class_2378.field_25105) {
                    tag = (class_6862)tagId;
                }
                if (tag == null) continue;
                if (entry.method_40220(tag)) {
                    if (check != Check.ANY) continue;
                    return true;
                }
                if (check != Check.ALL) continue;
                return false;
            }
        }
        return false;
    }

    public static Collection<class_2248> getBlocks(class_6862<class_2248> tagKey) {
        ArrayList list = Lists.newArrayList();
        for (class_6880 holder : class_2378.field_11146.method_40286(tagKey)) {
            list.add((class_2248)holder.comp_349());
        }
        return list;
    }

    public static Collection<class_2248> getBlocks(String tagId) {
        return !Strings.isNullOrEmpty((String)tagId) ? TagHelper.getBlocks(TagHelper.getBlockTagKey(tagId)) : Collections.emptyList();
    }

    public static Stream<class_6862<class_2248>> getTags(class_2680 state) {
        return state != null ? TagHelper.getTags(state.method_26204()) : Collections.EMPTY_SET.stream();
    }

    public static Stream<class_6862<class_2248>> getTags(class_2248 block) {
        return block != null ? block.method_40142().method_40228() : Collections.EMPTY_SET.stream();
    }

    public static enum Check {
        ANY,
        ALL;

    }
}

