/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common.network;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_634;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.tuple.Pair;
import shetiphian.core.common.DistExecutor;
import shetiphian.core.common.network.PacketBase;
import shetiphian.core.internal.ShetiPhianCore;

public abstract class PacketPipeline {
    private static final BiMap<class_2960, Class<? extends PacketBase>> PACKET_LOOKUP = HashBiMap.create();
    private String modId;
    public static MinecraftServer ACTIVE_SERVER;

    protected void initialise(String modId) {
        this.modId = modId;
        this.registerPackets();
    }

    public abstract void registerPackets();

    protected void register(String id, Class<? extends PacketBase> packet, HandledSide side) {
        class_2960 identifier = new class_2960(this.modId, id);
        if (PACKET_LOOKUP.containsKey((Object)identifier)) {
            throw new RuntimeException("Packet Registration error: '" + identifier + "' already registered to '" + packet.getName() + "'");
        }
        if (PACKET_LOOKUP.containsValue(packet)) {
            throw new RuntimeException("Packet Registration error: '" + packet.getName() + "' already registered to '" + identifier + "'");
        }
        PACKET_LOOKUP.put((Object)identifier, packet);
        if (side != HandledSide.CLIENT) {
            ServerPlayNetworking.registerGlobalReceiver((class_2960)identifier, PacketPipeline::onMessageServer);
        }
        if (side != HandledSide.SERVER) {
            DistExecutor.runWhenOn(EnvType.CLIENT, () -> () -> ClientPlayNetworking.registerGlobalReceiver((class_2960)identifier, PacketPipeline::onMessageClient));
        }
    }

    private static void onMessageServer(MinecraftServer mc, class_3222 player, class_3244 handler, class_2540 buffer, PacketSender sender) {
        PacketBase packet = PacketPipeline.onMessage(buffer);
        mc.execute(() -> packet.handleServerSide(mc, player));
    }

    @Environment(value=EnvType.CLIENT)
    private static void onMessageClient(class_310 mc, class_634 handler, class_2540 buffer, PacketSender sender) {
        PacketBase packet = PacketPipeline.onMessage(buffer);
        mc.execute(() -> packet.handleClientSide(mc, mc.field_1724));
    }

    private static PacketBase onMessage(class_2540 buffer) {
        PacketBase packet;
        Pair<class_2960, class_2540> decoded = PacketPipeline.decode(buffer);
        Class packetClass = (Class)PACKET_LOOKUP.get(decoded.getKey());
        try {
            packet = (PacketBase)packetClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
        packet.fromBytes((class_2540)decoded.getValue());
        return packet;
    }

    private static Pair<class_2960, class_2540> encode(PacketBase packet) {
        class_2960 id = (class_2960)PACKET_LOOKUP.inverse().get(packet.getClass());
        class_2540 buffer = new class_2540(Unpooled.buffer());
        packet.toBytes(buffer);
        class_2487 tag = new class_2487();
        tag.method_10582("id", id.toString());
        tag.method_10570("buffer", buffer.array());
        class_2540 encoded = new class_2540(Unpooled.buffer());
        encoded.method_10794(tag);
        return Pair.of((Object)id, (Object)encoded);
    }

    private static Pair<class_2960, class_2540> decode(class_2540 encoded) {
        class_2487 tag = encoded.method_10798();
        class_2960 id = new class_2960(tag.method_10558("id"));
        class_2540 buffer = new class_2540(Unpooled.wrappedBuffer((byte[])tag.method_10547("buffer")));
        return Pair.of((Object)id, (Object)buffer);
    }

    @Environment(value=EnvType.CLIENT)
    public void sendPacketToServer(PacketBase packet) {
        Pair<class_2960, class_2540> encoded = PacketPipeline.encode(packet);
        ClientPlayNetworking.send((class_2960)((class_2960)encoded.getKey()), (class_2540)((class_2540)encoded.getValue()));
    }

    public void sendPacketToPlayer(PacketBase packet, class_3222 player) {
        Pair<class_2960, class_2540> encoded = PacketPipeline.encode(packet);
        ServerPlayNetworking.send((class_3222)player, (class_2960)((class_2960)encoded.getKey()), (class_2540)((class_2540)encoded.getValue()));
    }

    public void sendPacketToPlayer(PacketBase packet, UUID uuid) {
        for (class_3222 player : this.getPlayers(packet)) {
            if (!player.method_5667().equals(uuid)) continue;
            this.sendPacketToPlayer(packet, player);
            break;
        }
    }

    public void sendPacketToList(PacketBase packet, Collection<class_3222> players) {
        for (class_3222 player : players) {
            this.sendPacketToPlayer(packet, player);
        }
    }

    public void sendPacketToIdList(PacketBase packet, List<UUID> players) {
        for (class_3222 player : this.getPlayers(packet)) {
            if (!players.contains(player.method_5667())) continue;
            this.sendPacketToPlayer(packet, player);
        }
    }

    public void sendPacketToAll(PacketBase packet) {
        this.sendPacketToList(packet, this.getPlayers(packet));
    }

    public void sendPacketToAllAround(PacketBase packet, class_1297 entity, double range) {
        this.sendPacketToAllAround(packet, entity.method_37908().method_8597(), entity.method_23317(), entity.method_23318(), entity.method_23321(), range);
    }

    public void sendPacketToAllAround(PacketBase packet, class_2874 dimension, class_2338 pos, double range) {
        this.sendPacketToAllAround(packet, dimension, pos.method_10263(), pos.method_10264(), pos.method_10260(), range);
    }

    public void sendPacketToAllAround(PacketBase packet, class_2874 dimension, double x, double y, double z, double range) {
        for (class_3222 player : this.getPlayers(packet)) {
            double posZ;
            double posY;
            double posX;
            if (player.method_14220().method_8597() != dimension || !((posX = x - player.method_23317()) * posX + (posY = y - player.method_23318()) * posY + (posZ = z - player.method_23321()) * posZ < range * range)) continue;
            this.sendPacketToPlayer(packet, player);
        }
    }

    public void sendPacketToDimension(PacketBase packet, class_2874 dimension) {
        for (class_3222 player : this.getPlayers(packet)) {
            if (player.method_14220().method_8597() != dimension) continue;
            this.sendPacketToPlayer(packet, player);
        }
    }

    private List<class_3222> getPlayers(PacketBase packet) {
        if (ACTIVE_SERVER == null) {
            ShetiPhianCore.LOGGER.error("Can't send packet before the server starts [" + packet + "]");
        } else {
            try {
                return ACTIVE_SERVER.method_3760().method_14571();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new ArrayList<class_3222>();
    }

    protected static enum HandledSide {
        CLIENT,
        SERVER,
        BOTH;

    }
}

