/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common.rgb16;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.function.Consumer;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_4970;
import shetiphian.core.common.Function;
import shetiphian.core.common.IColored;
import shetiphian.core.common.rgb16.BlockItemRGB16;
import shetiphian.core.common.rgb16.IRGB16_Block;
import shetiphian.core.common.rgb16.RGB16;
import shetiphian.core.common.rgb16.RGB16StackHelper;
import shetiphian.core.common.rgb16.TileEntityRGB16;

public class BlockRGB16
extends class_2248
implements class_2343,
IColored,
IRGB16_Block {
    private final BlockEntityFactory<TileEntityRGB16> supplier;
    private int[] tintedIndexes;

    public BlockRGB16(class_4970.class_2251 settings, BlockEntityFactory<TileEntityRGB16> supplier) {
        super(settings);
        this.supplier = supplier;
    }

    public BlockRGB16 callback(Consumer<BlockRGB16> consumer) {
        consumer.accept(this);
        return this;
    }

    public BlockRGB16 tint(int ... indexes) {
        this.tintedIndexes = indexes;
        return this;
    }

    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return this.supplier.create(pos, state);
    }

    protected TileEntityRGB16 getTile(class_1922 world, class_2338 pos) {
        class_2586 tile = world.method_8321(pos);
        return tile instanceof TileEntityRGB16 ? (TileEntityRGB16)tile : null;
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, class_1309 placer, class_1799 stack) {
        TileEntityRGB16 tile = this.getTile((class_1922)world, pos);
        if (tile != null && stack.method_7909() instanceof BlockItemRGB16) {
            tile.setRGB16(((BlockItemRGB16)stack.method_7909()).getRGB16(stack), placer instanceof class_1657 ? (class_1657)placer : null);
        }
    }

    @Override
    public boolean recolorBlock(class_2680 state, class_1936 world, class_2338 pos, class_1657 player, class_1268 hand, class_2350 side, class_243 hitVec, String dyeName) {
        TileEntityRGB16 tile;
        if (!Strings.isNullOrEmpty((String)dyeName) && (tile = this.getTile((class_1922)world, pos)) != null) {
            RGB16 rgb16;
            if (!world.method_8608() && (rgb16 = tile.getRGB16(player)) != null) {
                if (player == null) {
                    rgb16.setValues(dyeName);
                } else {
                    rgb16.recolor(player, dyeName);
                }
                Function.syncTile(tile);
            }
            if (player != null) {
                player.method_6104(hand);
            }
            return true;
        }
        return false;
    }

    @Override
    public int getColorFor(IColored.Data data, int index) {
        TileEntityRGB16 tile;
        if (data.world != null && data.pos != null && (this.tintedIndexes == null || Arrays.stream(this.tintedIndexes).anyMatch(value -> value == index)) && (tile = this.getTile(data.world, data.pos)) != null) {
            RGB16 rgb16 = tile.getRGB16(null);
            return rgb16 != null ? rgb16.getColor() : 0xFFFFFF;
        }
        return 0xFFFFFF;
    }

    public class_1799 method_9574(class_1922 world, class_2338 pos, class_2680 state) {
        RGB16 rgb16;
        class_1799 stack = new class_1799((class_1935)this);
        TileEntityRGB16 tile = this.getTile(world, pos);
        if (tile != null && (rgb16 = tile.getRGB16(null)) != null) {
            RGB16StackHelper.setRGB16(stack, rgb16);
        }
        return stack;
    }

    @FunctionalInterface
    public static interface BlockEntityFactory<T extends TileEntityRGB16> {
        public T create(class_2338 var1, class_2680 var2);
    }
}

