/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.internal;

import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.autoconfig.serializer.PartitioningSerializer;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;
import net.fabricmc.api.EnvType;
import net.minecraft.class_310;
import shetiphian.core.common.DistExecutor;
import shetiphian.core.common.network.PacketPlayerConfig;
import shetiphian.core.internal.ShetiPhianCore;
import shetiphian.core.internal.Values;
import shetiphian.core.internal.network.NetworkHandler;

@Config(name="shetiphiancore")
public class Configuration
extends PartitioningSerializer.GlobalData {
    @ConfigEntry.Category(value="client")
    @ConfigEntry.Gui.TransitiveObject
    public ClientFile CLIENT = new ClientFile();
    @ConfigEntry.Category(value="common")
    @ConfigEntry.Gui.TransitiveObject
    public CommonFile COMMON = new CommonFile();

    public static void sync() {
        DistExecutor.runWhenOn(EnvType.CLIENT, () -> () -> class_310.method_1551().execute(() -> {
            try {
                NetworkHandler.sendToServer(PacketPlayerConfig.sync(Values.CONFIGKEY_COLOR_BLEND_MODE, ShetiPhianCore.CONFIG.CLIENT.color_blend_mode.ordinal()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }));
    }

    @Config(name="client")
    public static class ClientFile
    implements ConfigData {
        @Comment(value="Adjust the default way RGB16 handles dyes \r\nRYB = blending is used to mix the colors \r\n > Like mixing paint, the dye will be added to the existing color \r\n > Sneak-Click to set to dye color \r\n \r\nRGB = direct value manipulation \r\n > Click to increase, Sneak-Click to decrease \r\n \r\nRYB is easier to use but RGB is more precise")
        public BlendMode color_blend_mode = BlendMode.RYB;
        @Comment(value="Choose the way items with modes/selections change \r\nBOTH (default), KEYBINDING (presets: PgUp/PgDown), SNEAK_SCROLL")
        public ToolModeControl tool_mode_change = ToolModeControl.BOTH;

        public void validatePostLoad() throws ConfigData.ValidationException {
            super.validatePostLoad();
            try {
                Configuration.sync();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public static enum BlendMode {
            RGB,
            RYB;

        }

        public static enum ToolModeControl {
            KEYBINDING,
            SNEAK_SCROLL,
            BOTH;


            public boolean isMouse() {
                return this != KEYBINDING;
            }

            public boolean isKeyboard() {
                return this != SNEAK_SCROLL;
            }
        }
    }

    @Config(name="common")
    public static class CommonFile
    implements ConfigData {
        @Comment(value="Modifies entity collision checks to work with thinner blocks \r\nUnmodified ignores blocks bellow 1/5 (slightly thicker then a lower trap door) \r\nModified processes blocks down to 3/32 (slightly thicker then carpets) \r\n \r\nIf you need to disable this to solve a compatibility issue, please report it to me \r\nNon-living entities and thinner blocks are already exempt to avoid compatibility issues")
        public boolean enable_thin_block_handler = true;
        @Comment(value="When enabled carpets on top of scaffolding can be passed through just like snow")
        public boolean enable_carpet_passthrough = true;
        @Comment(value="When enabled using bonemeal on a stripped log restores the bark")
        public boolean bonemeal_restores_bark = true;
        @Comment(value="When enabled using bonemeal on grass blocks also generates flowers from mods \r\nBy default Minecraft only picks flowers from its own FlowerFeature list, but when mods add flowers they get added to there own list")
        public boolean bonemeal_flowerfix = true;
    }
}

